#
# TABLE STRUCTURE FOR: tec_categories
#

DROP TABLE IF EXISTS `tec_categories`;

CREATE TABLE `tec_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(20) NOT NULL,
  `name` varchar(55) NOT NULL,
  `image` varchar(100) DEFAULT 'no_image.png',
  `printer_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=44 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

INSERT INTO `tec_categories` (`id`, `code`, `name`, `image`, `printer_id`) VALUES ('42', '1', 'Outros', '804f8e178792b4b2ecf2c66b21a083f8.jpg', '8');
INSERT INTO `tec_categories` (`id`, `code`, `name`, `image`, `printer_id`) VALUES ('43', '2', 'Diversos', 'fa52264e9d177e0ea667f46f3feaddba.png', '0');


#
# TABLE STRUCTURE FOR: tec_combo_items
#

DROP TABLE IF EXISTS `tec_combo_items`;

CREATE TABLE `tec_combo_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `item_code` varchar(20) NOT NULL,
  `quantity` decimal(12,4) NOT NULL,
  `price` decimal(25,2) DEFAULT NULL,
  `cost` decimal(25,2) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

#
# TABLE STRUCTURE FOR: tec_customers
#

DROP TABLE IF EXISTS `tec_customers`;

CREATE TABLE `tec_customers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(55) NOT NULL,
  `cf1` varchar(255) NOT NULL,
  `cf2` varchar(255) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `email` varchar(100) NOT NULL,
  `endereco` varchar(555) NOT NULL,
  `numero` varchar(20) NOT NULL,
  `complemento` varchar(255) NOT NULL,
  `bairro` varchar(255) NOT NULL,
  `cep` varchar(100) NOT NULL,
  `cidade` varchar(100) NOT NULL,
  `estado` varchar(100) NOT NULL,
  `obs1` varchar(2222) NOT NULL,
  `data` date DEFAULT NULL,
  `Country` varchar(255) DEFAULT NULL,
  `AccountID` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=77 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('73', 'Consumidor Final', '999999999', '', '0', 'c', 'Benguela', '0', 'Benguela', 'Benguela', '2', 'Benguela', 'Benguela', '', '2024-02-06', 'Angola', '0');
INSERT INTO `tec_customers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `endereco`, `numero`, `complemento`, `bairro`, `cep`, `cidade`, `estado`, `obs1`, `data`, `Country`, `AccountID`) VALUES ('76', 'INSTITUTO SUPERIOR DE OMBAKA', '5111049380', '', '0', 'geral@ispombaka.com', 'Rua General Faria', '0', 'Rua General Faria', 'Rua General Faria', '2', 'Benguela', 'Benguela', '', '2024-01-22', 'Angola', '0');


#
# TABLE STRUCTURE FOR: tec_expenses
#

DROP TABLE IF EXISTS `tec_expenses`;

CREATE TABLE `tec_expenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `reference` varchar(50) NOT NULL,
  `amount` decimal(25,2) NOT NULL,
  `note` varchar(1000) DEFAULT NULL,
  `created_by` varchar(55) NOT NULL,
  `attachment` varchar(55) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

INSERT INTO `tec_expenses` (`id`, `date`, `reference`, `amount`, `note`, `created_by`, `attachment`) VALUES ('1', '2021-06-06 20:38:00', 'qaw', '100000.00', '', '16', NULL);


#
# TABLE STRUCTURE FOR: tec_gift_cards
#

DROP TABLE IF EXISTS `tec_gift_cards`;

CREATE TABLE `tec_gift_cards` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `card_no` varchar(20) NOT NULL,
  `value` decimal(25,2) NOT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `balance` decimal(25,2) NOT NULL,
  `expiry` date DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `card_no` (`card_no`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

INSERT INTO `tec_gift_cards` (`id`, `date`, `card_no`, `value`, `customer_id`, `balance`, `expiry`, `created_by`) VALUES ('5', '2018-03-21 04:00:22', '2489 7897 0990 8779', '250.40', NULL, '250.40', NULL, '5');
INSERT INTO `tec_gift_cards` (`id`, `date`, `card_no`, `value`, `customer_id`, `balance`, `expiry`, `created_by`) VALUES ('6', '2019-08-12 14:00:48', '1111 1111 1111 1111', '50000.00', '74', '-121002.28', '2050-02-02', '40');
INSERT INTO `tec_gift_cards` (`id`, `date`, `card_no`, `value`, `customer_id`, `balance`, `expiry`, `created_by`) VALUES ('7', '2019-10-22 14:50:53', '4242 4242 4242 4242', '1000.00', NULL, '1000.00', NULL, '14');
INSERT INTO `tec_gift_cards` (`id`, `date`, `card_no`, `value`, `customer_id`, `balance`, `expiry`, `created_by`) VALUES ('8', '2023-03-28 17:20:11', '5901 6232 4749 8532', '100000.00', NULL, '100000.00', NULL, '16');
INSERT INTO `tec_gift_cards` (`id`, `date`, `card_no`, `value`, `customer_id`, `balance`, `expiry`, `created_by`) VALUES ('9', '2023-03-28 17:22:29', '2356 3038 9839 9057', '10000.00', '74', '4000.00', '2023-12-12', '16');


#
# TABLE STRUCTURE FOR: tec_groups
#

DROP TABLE IF EXISTS `tec_groups`;

CREATE TABLE `tec_groups` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `description` varchar(100) NOT NULL,
  `role` varchar(8) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

INSERT INTO `tec_groups` (`id`, `name`, `description`, `role`) VALUES ('1', 'admin', 'Administrator', '999');
INSERT INTO `tec_groups` (`id`, `name`, `description`, `role`) VALUES ('2', 'staff', 'Staff', '2');
INSERT INTO `tec_groups` (`id`, `name`, `description`, `role`) VALUES ('3', 'garson', 'Garson', '1');
INSERT INTO `tec_groups` (`id`, `name`, `description`, `role`) VALUES ('4', 'super_admin', 'Super Admin', '9999');
INSERT INTO `tec_groups` (`id`, `name`, `description`, `role`) VALUES ('5', 'comercial', 'Comercial', '100');


#
# TABLE STRUCTURE FOR: tec_licences
#

DROP TABLE IF EXISTS `tec_licences`;

CREATE TABLE `tec_licences` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `licence` varchar(250) NOT NULL,
  `expired_month` varchar(100) NOT NULL,
  `status` varchar(100) DEFAULT NULL,
  `insert_date` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

INSERT INTO `tec_licences` (`id`, `user_id`, `licence`, `expired_month`, `status`, `insert_date`) VALUES ('6', '7', '34b62b089b824d98abf8cb80d5582bb8edf2508d', 'MTI=', 'used', '2019-11-22');
INSERT INTO `tec_licences` (`id`, `user_id`, `licence`, `expired_month`, `status`, `insert_date`) VALUES ('7', '14', 'f87349f623bb99c8aca6ad3bb8042bd320731c86', 'MQ==', NULL, NULL);
INSERT INTO `tec_licences` (`id`, `user_id`, `licence`, `expired_month`, `status`, `insert_date`) VALUES ('8', '19', 'fe26fc0f530c2a3c2c081385aa72c268180faf1e', 'MQ==', 'used', '2019-12-03');
INSERT INTO `tec_licences` (`id`, `user_id`, `licence`, `expired_month`, `status`, `insert_date`) VALUES ('9', '15', '9ca251ba5894c956cbc5740638d40ecf810fdc36', 'MTI=', NULL, NULL);
INSERT INTO `tec_licences` (`id`, `user_id`, `licence`, `expired_month`, `status`, `insert_date`) VALUES ('10', '20', 'e6cb59ed603fb62f48f69be1febe105d15102e35', 'MTI=', 'used', '2019-12-05');
INSERT INTO `tec_licences` (`id`, `user_id`, `licence`, `expired_month`, `status`, `insert_date`) VALUES ('11', '21', '3ade9ac8f5222c2a3ecf668590725036d3f78649', 'MTI=', 'used', '2019-12-05');
INSERT INTO `tec_licences` (`id`, `user_id`, `licence`, `expired_month`, `status`, `insert_date`) VALUES ('12', '29', '0f6465f35d2dde35689663786d35b6afab8d2e74', 'MTE=', 'used', '2019-12-17');
INSERT INTO `tec_licences` (`id`, `user_id`, `licence`, `expired_month`, `status`, `insert_date`) VALUES ('13', '30', 'c3f27ea5c643a1f6ee5c7fd48a6dc89fa04cfa5f', 'MTE=', 'used', '2019-12-17');
INSERT INTO `tec_licences` (`id`, `user_id`, `licence`, `expired_month`, `status`, `insert_date`) VALUES ('14', '37', 'e4e49f67c4c9539155100730814804800373a27e', 'MTE=', 'used', '2019-12-17');
INSERT INTO `tec_licences` (`id`, `user_id`, `licence`, `expired_month`, `status`, `insert_date`) VALUES ('15', '38', '7c6ab6d418c7edf6c3c543a6b7cf219ff33f45a3', 'MTE=', 'used', '2019-12-17');
INSERT INTO `tec_licences` (`id`, `user_id`, `licence`, `expired_month`, `status`, `insert_date`) VALUES ('16', '17', '644d86894176b552ff9a6e0c775e2274847c9252', 'MTE=', 'used', '2019-12-17');


#
# TABLE STRUCTURE FOR: tec_login_attempts
#

DROP TABLE IF EXISTS `tec_login_attempts`;

CREATE TABLE `tec_login_attempts` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `ip_address` varbinary(16) NOT NULL,
  `login` varchar(100) NOT NULL,
  `time` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

INSERT INTO `tec_login_attempts` (`id`, `ip_address`, `login`, `time`) VALUES ('8', '::1', 'superadmin', '1707237234');
INSERT INTO `tec_login_attempts` (`id`, `ip_address`, `login`, `time`) VALUES ('9', '127.0.0.1', 'masctos1', '1707303199');


#
# TABLE STRUCTURE FOR: tec_mesas
#

DROP TABLE IF EXISTS `tec_mesas`;

CREATE TABLE `tec_mesas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `places` int(11) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=71 DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

INSERT INTO `tec_mesas` (`id`, `name`, `places`, `status`) VALUES ('56', 'mesa1', '2', '1');
INSERT INTO `tec_mesas` (`id`, `name`, `places`, `status`) VALUES ('58', 'mesa3', '4', '0');
INSERT INTO `tec_mesas` (`id`, `name`, `places`, `status`) VALUES ('64', 'mesa5', '0', '0');
INSERT INTO `tec_mesas` (`id`, `name`, `places`, `status`) VALUES ('65', 'mesa6', '0', '0');
INSERT INTO `tec_mesas` (`id`, `name`, `places`, `status`) VALUES ('67', 'mesa8', '0', '0');
INSERT INTO `tec_mesas` (`id`, `name`, `places`, `status`) VALUES ('68', 'mesa9', '0', '0');
INSERT INTO `tec_mesas` (`id`, `name`, `places`, `status`) VALUES ('69', 'mesa10', '0', '0');
INSERT INTO `tec_mesas` (`id`, `name`, `places`, `status`) VALUES ('70', 'mesa11', '0', '0');


#
# TABLE STRUCTURE FOR: tec_numbering
#

DROP TABLE IF EXISTS `tec_numbering`;

CREATE TABLE `tec_numbering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` int(11) NOT NULL,
  `InvoiceType` varchar(4) NOT NULL,
  `InvoiceYear` year(4) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=103 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('90', '1', 'FT', '2024');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('91', '2', 'FT', '2024');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('92', '3', 'FT', '2024');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('93', '4', 'FT', '2024');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('94', '1', 'RC', '2024');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('95', '1', 'FR', '2024');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('96', '2', 'RC', '2024');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('97', '2', 'FR', '2024');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('98', '3', 'RC', '2024');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('99', '3', 'FR', '2024');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('100', '1', 'NC', '2024');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('101', '4', 'RC', '2024');
INSERT INTO `tec_numbering` (`id`, `number`, `InvoiceType`, `InvoiceYear`) VALUES ('102', '5', 'RC', '2024');


#
# TABLE STRUCTURE FOR: tec_payments
#

DROP TABLE IF EXISTS `tec_payments`;

CREATE TABLE `tec_payments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `sale_id` int(11) DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `transaction_id` varchar(50) DEFAULT NULL,
  `paid_by` varchar(20) NOT NULL,
  `cheque_no` varchar(20) DEFAULT NULL,
  `cc_no` varchar(20) DEFAULT NULL,
  `cc_holder` varchar(25) DEFAULT NULL,
  `cc_month` varchar(2) DEFAULT NULL,
  `cc_year` varchar(4) DEFAULT NULL,
  `cc_type` varchar(20) DEFAULT NULL,
  `amount` decimal(25,2) NOT NULL,
  `currency` varchar(3) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `attachment` varchar(55) DEFAULT NULL,
  `note` varchar(1000) DEFAULT NULL,
  `pos_paid` decimal(25,2) DEFAULT '0.00',
  `pos_balance` decimal(25,2) DEFAULT '0.00',
  `gc_no` varchar(20) DEFAULT NULL,
  `reference` varchar(50) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `PaymentStatus` varchar(4) DEFAULT NULL,
  `SourcePayment` varchar(255) DEFAULT NULL,
  `PaymentType` varchar(4) DEFAULT NULL,
  `OrderReferences` varchar(255) DEFAULT NULL,
  `InvoiceNo` varchar(100) DEFAULT NULL,
  `retencao` decimal(25,2) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=41 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

INSERT INTO `tec_payments` (`id`, `date`, `sale_id`, `customer_id`, `transaction_id`, `paid_by`, `cheque_no`, `cc_no`, `cc_holder`, `cc_month`, `cc_year`, `cc_type`, `amount`, `currency`, `created_by`, `attachment`, `note`, `pos_paid`, `pos_balance`, `gc_no`, `reference`, `updated_by`, `updated_at`, `PaymentStatus`, `SourcePayment`, `PaymentType`, `OrderReferences`, `InvoiceNo`, `retencao`) VALUES ('36', '2024-02-06 17:42:24', '63', '73', NULL, 'cash', '', '', '', '', '', '', '228.00', NULL, '16', NULL, '', '228.00', '0.00', '', NULL, NULL, NULL, 'N', 'P', 'RC', 'FR SIF2024/1', 'RC  SIF2024/1', NULL);
INSERT INTO `tec_payments` (`id`, `date`, `sale_id`, `customer_id`, `transaction_id`, `paid_by`, `cheque_no`, `cc_no`, `cc_holder`, `cc_month`, `cc_year`, `cc_type`, `amount`, `currency`, `created_by`, `attachment`, `note`, `pos_paid`, `pos_balance`, `gc_no`, `reference`, `updated_by`, `updated_at`, `PaymentStatus`, `SourcePayment`, `PaymentType`, `OrderReferences`, `InvoiceNo`, `retencao`) VALUES ('37', '2024-02-06 17:43:22', '64', '73', NULL, 'cash', '', '', '', '', '', '', '2606.00', NULL, '16', NULL, '', '2606.00', '0.00', '', NULL, NULL, NULL, 'N', 'P', 'RC', 'FR SIF2024/2', 'RC  SIF2024/2', NULL);
INSERT INTO `tec_payments` (`id`, `date`, `sale_id`, `customer_id`, `transaction_id`, `paid_by`, `cheque_no`, `cc_no`, `cc_holder`, `cc_month`, `cc_year`, `cc_type`, `amount`, `currency`, `created_by`, `attachment`, `note`, `pos_paid`, `pos_balance`, `gc_no`, `reference`, `updated_by`, `updated_at`, `PaymentStatus`, `SourcePayment`, `PaymentType`, `OrderReferences`, `InvoiceNo`, `retencao`) VALUES ('38', '2024-02-06 17:44:15', '65', '73', NULL, 'cash', '', '', '', '', '', '', '4081.20', NULL, '16', NULL, '', '4081.20', '0.00', '', NULL, NULL, NULL, 'N', 'P', 'RC', 'FR SIF2024/3', 'RC  SIF2024/3', NULL);
INSERT INTO `tec_payments` (`id`, `date`, `sale_id`, `customer_id`, `transaction_id`, `paid_by`, `cheque_no`, `cc_no`, `cc_holder`, `cc_month`, `cc_year`, `cc_type`, `amount`, `currency`, `created_by`, `attachment`, `note`, `pos_paid`, `pos_balance`, `gc_no`, `reference`, `updated_by`, `updated_at`, `PaymentStatus`, `SourcePayment`, `PaymentType`, `OrderReferences`, `InvoiceNo`, `retencao`) VALUES ('39', '2024-02-06 17:49:00', '59', '73', NULL, 'cash', '', '', '', '', '', 'Visa', '20008.47', NULL, '16', NULL, '', '0.00', '0.00', '', '', NULL, NULL, 'N', 'P', 'RC', 'FT SIF2024/1', 'RC  SIF2024/4', NULL);
INSERT INTO `tec_payments` (`id`, `date`, `sale_id`, `customer_id`, `transaction_id`, `paid_by`, `cheque_no`, `cc_no`, `cc_holder`, `cc_month`, `cc_year`, `cc_type`, `amount`, `currency`, `created_by`, `attachment`, `note`, `pos_paid`, `pos_balance`, `gc_no`, `reference`, `updated_by`, `updated_at`, `PaymentStatus`, `SourcePayment`, `PaymentType`, `OrderReferences`, `InvoiceNo`, `retencao`) VALUES ('40', '2024-02-06 17:50:00', '60', '73', NULL, 'TB', '', '', '', '', '', 'Visa', '228.00', NULL, '16', NULL, '', '0.00', '0.00', '', '', NULL, NULL, 'N', 'P', 'RC', 'FT SIF2024/2', 'RC  SIF2024/5', NULL);


#
# TABLE STRUCTURE FOR: tec_printers
#

DROP TABLE IF EXISTS `tec_printers`;

CREATE TABLE `tec_printers` (
  `printer_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `profile` varchar(255) NOT NULL,
  `chars_per_line` int(11) NOT NULL,
  `ip_address` varchar(50) DEFAULT NULL,
  `port` int(11) DEFAULT NULL,
  `path` varchar(255) DEFAULT NULL,
  `date_created` datetime DEFAULT NULL,
  `date_modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`printer_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

INSERT INTO `tec_printers` (`printer_id`, `title`, `type`, `profile`, `chars_per_line`, `ip_address`, `port`, `path`, `date_created`, `date_modified`) VALUES ('7', 'hp200', 'windows', 'simple', '80', '', '0', 'mactosbarros/hp', '2021-11-29 18:29:31', '2021-11-29 18:29:31');
INSERT INTO `tec_printers` (`printer_id`, `title`, `type`, `profile`, `chars_per_line`, `ip_address`, `port`, `path`, `date_created`, `date_modified`) VALUES ('8', 'epson', 'network', 'espon tep', '80', '192.168.100.5', '80', '', '2021-11-29 18:30:12', '2021-11-29 18:30:12');


#
# TABLE STRUCTURE FOR: tec_producs_list
#

DROP TABLE IF EXISTS `tec_producs_list`;

CREATE TABLE `tec_producs_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product` int(11) NOT NULL,
  `name` char(255) NOT NULL,
  `price` decimal(25,2) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

#
# TABLE STRUCTURE FOR: tec_products
#

DROP TABLE IF EXISTS `tec_products`;

CREATE TABLE `tec_products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(50) DEFAULT NULL,
  `name` char(255) DEFAULT NULL,
  `category_id` int(11) NOT NULL DEFAULT '1',
  `percent` double(10,4) DEFAULT NULL,
  `price` decimal(25,2) NOT NULL,
  `image` varchar(255) DEFAULT 'no_image.png',
  `tax` varchar(20) DEFAULT NULL,
  `cost` decimal(25,2) DEFAULT NULL,
  `tax_method` tinyint(1) DEFAULT '1',
  `quantity` decimal(15,2) DEFAULT '0.00',
  `barcode_symbology` varchar(20) NOT NULL DEFAULT 'code39',
  `type` varchar(20) NOT NULL DEFAULT 'standard',
  `details` text,
  `alert_quantity` decimal(10,2) DEFAULT '0.00',
  `price_2` decimal(25,2) DEFAULT NULL,
  `tax_id` int(11) DEFAULT NULL,
  `tax_type` varchar(4) DEFAULT NULL,
  `grand_total` decimal(25,2) DEFAULT NULL,
  `UnitOfMeasure` varchar(255) DEFAULT NULL,
  `validity` varchar(20) DEFAULT NULL,
  `validity_date` date DEFAULT NULL,
  `qty_na_caixa` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `code` (`code`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=52 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('14', '5600751333072', 'Vinho Reflexo', '43', '0.0000', '2000.00', 'no_image.png', '14', '1439.00', '0', '6999.00', 'code39', 'standard', '', '0.00', NULL, '1', 'IVA', NULL, 'Uni', 'No', '2030-01-01', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('11', '5600336080575', 'Açucar tio lucas 1kg', '43', '0.0000', '550.00', 'no_image.png', '14', '440.00', '0', '699.00', 'code39', 'standard', 'Produto criado no dia 24 de Março de 2023', '0.00', NULL, '1', 'IVA ', NULL, 'Uni', 'No', '2030-01-01', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('13', '7891515503239', 'SALSICHA Confidence congelada', '43', '0.0000', '60.00', 'no_image.png', '14', '59.00', '0', '0.00', 'code39', 'standard', '', '50.00', NULL, '1', 'IVA', NULL, 'Uni', 'No', '2024-03-25', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('15', '5608242334683', 'SUMO TUTI LARANJA', '43', '0.0000', '700.00', 'no_image.png', '14', '698.00', '1', '697.00', 'code39', 'standard', '', '3.00', NULL, '1', 'IVA', NULL, 'Uni', 'No', '0000-00-00', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('16', '0604714970149', 'GIN PARIS', '43', '0.0000', '50.00', 'no_image.png', '14', '37.00', '0', '88.00', 'code39', 'standard', '', '40.00', NULL, '1', 'IVA', NULL, 'Uni', 'No', '2030-01-01', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('17', '5607242145630', 'AGUA PURA GR 1L', '43', '0.0000', '250.00', 'no_image.png', '14', '180.00', '0', '16.00', 'code39', 'standard', '', '6.00', NULL, '1', 'IVA ', NULL, 'Uni', 'No', '2030-01-01', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('18', '0715632885840', 'GASOSA ROSAEL LARANJA', '43', '0.0000', '150.00', 'no_image.png', '14', '100.00', '0', '18.00', 'code39', 'standard', '', '6.00', NULL, '1', 'IVA', NULL, 'Uni', 'No', '2024-03-31', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('19', '0705632885891', 'GASOSA ROSAEL LIMÃO', '43', '0.0000', '150.00', 'no_image.png', '14', '114.00', '0', '699.00', 'code39', 'standard', '', '6.00', NULL, '1', 'IVA', NULL, 'Uni', 'No', '2024-03-31', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('20', '0705632885857', 'GASOSA ROSAEL COLA', '43', '0.0000', '150.00', 'no_image.png', '14', '100.00', '0', '27.00', 'code39', 'standard', '', '6.00', NULL, '1', 'IVA', NULL, 'Uni', 'No', '2024-03-31', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('21', '5600751333089', 'VINHO PIAS - 750ML', '43', '0.0000', '2500.00', 'no_image.png', '14', '1573.00', '0', '698.00', 'code39', 'standard', '', '1.00', NULL, '1', 'IVA', NULL, 'Uni', 'No', '2030-01-01', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('22', '5607606500726', 'VINHO TINTO FORT 1L', '43', '0.0000', '1200.00', 'no_image.png', '14', '919.00', '0', '697.00', 'code39', 'standard', '', '3.00', NULL, '1', 'IVA', NULL, 'Uni', 'No', '2030-01-01', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('23', '5608242145609', 'VINHO SANGRIA TROPICAL 1L', '43', '0.0000', '1200.00', 'no_image.png', '14', '919.00', '0', '6997.00', 'code39', 'standard', '', '3.00', NULL, '1', 'IVA', NULL, 'Uni', 'No', '2030-01-01', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('24', '5607606500757', 'VINHO TINTO FORT GAR 250 ml', '43', '0.0000', '750.00', 'no_image.png', '14', '678.00', '0', '700.00', 'code39', 'standard', '', '3.00', NULL, '1', 'IVA', NULL, 'Uni', 'No', '2030-01-01', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('25', '5608242390054', 'AGUA NBOA PQ 500ml', '43', '0.0000', '100.00', 'no_image.png', '14', '64.00', '0', '699.00', 'code39', 'standard', '', '12.00', NULL, '1', 'IVA', NULL, 'Uni', 'No', '2030-01-01', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('26', '4897057900072', 'AGUA ORION 2L', '43', '0.0000', '300.00', 'no_image.png', '14', '191.67', '0', '700.00', 'code39', 'standard', '', '3.00', NULL, '1', 'IVA', NULL, 'Uni', 'No', '2030-01-01', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('27', '4897057900140', 'AGUA ORION PQ 1L', '43', '0.0000', '150.00', 'no_image.png', '14', '104.00', '0', '700.00', 'code39', 'standard', '', '12.00', NULL, '1', 'IVA', NULL, 'Uni', 'No', '2030-01-01', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('28', '5601151977804', 'SUMOL EM LATA LARANJA', '43', '0.0000', '300.00', 'no_image.png', '14', '272.00', '0', '13.00', 'code39', 'standard', '', '6.00', NULL, '1', 'IVA', NULL, 'Uni', 'No', '2030-01-01', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('29', '6009880197330', 'SUMO LULU 12 FRUTOS PAC 1L', '43', '0.0000', '750.00', 'no_image.png', '14', '461.00', '0', '700.00', 'code39', 'standard', '', '3.00', NULL, '1', 'IVA', NULL, 'Uni', 'No', '2030-01-01', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('30', '5608242145623', 'GASOSA BLUE COCO ANANAX', '43', '0.0000', '250.00', 'no_image.png', '14', '233.94', '0', '700.00', 'code39', 'standard', '', '6.00', NULL, '1', 'IVA', NULL, 'Uni', 'No', '2030-01-01', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('31', '5608242112403', 'GASOSA BLUE LIMÃO GENGIBRE', '43', '0.0000', '250.00', 'no_image.png', '14', '228.00', '0', '21.00', 'code39', 'standard', '', '6.00', NULL, '1', 'IVA', NULL, 'Uni', 'No', '2030-01-01', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('32', '56082421456685', 'AGUA PURA PQ', '43', '0.0000', '100.00', 'no_image.png', '14', '80.00', '0', '21.00', 'code39', 'standard', '', '12.00', NULL, '1', 'IVA', NULL, 'Uni', 'No', '2030-01-01', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('33', '629700034434', 'AGUA BELA PQ 500ml', '43', '0.0000', '100.00', 'no_image.png', '14', '80.00', '0', '700.00', 'code39', 'standard', '', '6.00', NULL, '1', 'IVA', NULL, 'Uni', 'No', '2030-01-01', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('34', '5600751220167', 'GIN GORDON TONIC MIX', '43', '0.0000', '600.00', 'no_image.png', '14', '450.00', '0', '22.00', 'code39', 'standard', '', '6.00', NULL, '1', 'IVA', NULL, 'Uni', 'No', '2030-01-01', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('35', '5601151975602', 'SUMO COMPAL EM LATA', '43', '0.0000', '400.00', 'no_image.png', '14', '290.00', '0', '16.00', 'code39', 'standard', '', '12.00', NULL, '1', 'IVA', NULL, 'Uni', 'No', '2030-01-01', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('36', '5287000314008', 'SUMO GARDENIA PQ', '43', '0.0000', '130.00', 'no_image.png', '14', '90.00', '0', '24.00', 'code39', 'standard', '', '20.00', NULL, '1', 'IVA', NULL, 'Uni', 'No', '2030-01-01', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('37', '5608242267806', 'SPEED EM LATA', '43', '0.0000', '500.00', 'no_image.png', '14', '354.17', '0', '30.00', 'code39', 'standard', '', '10.00', NULL, '1', 'IVA', NULL, 'Uni', 'No', '2024-12-31', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('38', '5608242156810', 'SUMO NUTRY EM LATA', '43', '0.0000', '370.00', 'no_image.png', '14', '370.00', '0', '22.00', 'code39', 'standard', '', '6.00', NULL, '1', 'IVA', NULL, 'Uni', 'No', '2030-01-01', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('39', '560091200713', 'MASSA GLORIA', '43', '0.0000', '250.00', 'no_image.png', '14', '270.00', '0', '13.00', 'code39', 'standard', '', '5.00', NULL, '1', 'IVA ', NULL, 'Uni', 'No', '2025-02-15', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('40', '6009639655548', 'LEITE CONDENSADO BIBA LATA', '43', '0.0000', '700.00', 'no_image.png', '14', '516.67', '0', '698.00', 'code39', 'standard', '', '3.00', NULL, '1', 'IVA', NULL, 'Uni', 'No', '0000-00-00', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('41', '5607530050014', 'LEITE LATIANGOL MEIO GORDO', '43', '0.0000', '900.00', 'no_image.png', '14', '491.67', '0', '700.00', 'code39', 'standard', '', '3.00', NULL, '1', 'IVA ', NULL, 'Uni', 'No', '2030-01-01', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('42', '5600336081107', 'OLEO TIO LUCAS', '43', '0.0000', '1100.00', 'no_image.png', '14', '866.66', '0', '23.00', 'code39', 'standard', '', '6.00', NULL, '1', 'IVA ', NULL, 'Uni', 'No', '2024-02-27', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('43', '6297000234175', 'VINAGRE BELA', '43', '0.0000', '200.00', 'no_image.png', '14', '168.00', '0', '18.00', 'code39', 'standard', '', '12.00', NULL, '1', 'IVA ', NULL, 'Uni', 'No', '2033-01-16', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('44', '6064000004042', 'CERVEJA EKA 250ml', '43', '0.0000', '166.67', 'no_image.png', '14', '143.75', '0', '62.00', 'code39', 'standard', '', '24.00', NULL, '1', 'IVA', NULL, 'Uni', 'No', '2030-01-01', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('45', '6009639655180', 'VINAGRE PRIMAVERA 500ml', '43', '0.0000', '230.00', 'no_image.png', '14', '180.00', '0', '698.00', 'code39', 'standard', '', '0.00', NULL, '1', 'IVA ', NULL, 'Uni', 'No', '2030-01-01', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('46', '608155013092', 'LEITE MIXEWELL', '43', '0.0000', '50.00', 'no_image.png', '0', '37.00', '0', '89.00', 'code39', 'standard', '', '50.00', NULL, '3', 'IVA', NULL, 'Uni', 'No', '2030-01-01', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('47', '6064000002031', 'CERVEJA CUCA 500ml', '43', '0.0000', '166.67', 'no_image.png', '0', '143.75', '0', '71.00', 'code39', 'standard', '', '24.00', NULL, '8', 'IVA', NULL, 'Uni', 'No', '2030-01-01', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('48', '5287001476392', 'MAIONESE MEBON 450ml', '43', '0.0000', '1400.00', 'no_image.png', '0', '0.00', '0', '699.00', 'code39', 'standard', '', '2.00', NULL, '3', 'IVA', NULL, 'Uni', 'No', '2024-01-04', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('49', '9555246323150', 'OLEO DE PALMA MADINA', '43', '0.0000', '2000.00', 'no_image.png', '0', '1869.63', '0', '700.00', 'code39', 'standard', '', '1.00', NULL, '3', 'IVA ', NULL, 'Uni', 'No', '2024-08-30', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('50', '5600336082821', 'OLEO TIO LUCAS PQ', '43', '0.0000', '350.00', 'no_image.png', '0', '245.00', '0', '24.00', 'code39', 'standard', '', '10.00', NULL, '8', 'IVA ', NULL, 'Uni', 'No', '2024-01-24', '0');
INSERT INTO `tec_products` (`id`, `code`, `name`, `category_id`, `percent`, `price`, `image`, `tax`, `cost`, `tax_method`, `quantity`, `barcode_symbology`, `type`, `details`, `alert_quantity`, `price_2`, `tax_id`, `tax_type`, `grand_total`, `UnitOfMeasure`, `validity`, `validity_date`, `qty_na_caixa`) VALUES ('51', '8032754233900', 'ERVILHA MISTA MERI', '43', '0.0000', '550.00', 'no_image.png', '0', '422.00', '0', '6999.00', 'code39', 'standard', '', '1.00', NULL, '8', 'IVA ', NULL, 'Uni', 'No', '2024-06-01', '0');


#
# TABLE STRUCTURE FOR: tec_purchase_items
#

DROP TABLE IF EXISTS `tec_purchase_items`;

CREATE TABLE `tec_purchase_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `purchase_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `quantity` decimal(15,2) NOT NULL,
  `cost` decimal(25,2) NOT NULL,
  `subtotal` decimal(25,2) NOT NULL,
  `discount` varchar(20) DEFAULT NULL,
  `item_discount` decimal(25,4) DEFAULT NULL,
  `tax_id` int(11) DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `item_tax` decimal(25,4) DEFAULT NULL,
  `real_unit_price` decimal(25,4) DEFAULT NULL,
  `create_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

INSERT INTO `tec_purchase_items` (`id`, `purchase_id`, `product_id`, `quantity`, `cost`, `subtotal`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `real_unit_price`, `create_by`) VALUES ('9', '5', '10', '1.00', '2000.00', '1824.00', '20%', '400.0000', '1', NULL, '224.0000', NULL, NULL);


#
# TABLE STRUCTURE FOR: tec_purchases
#

DROP TABLE IF EXISTS `tec_purchases`;

CREATE TABLE `tec_purchases` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` varchar(55) NOT NULL,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `note` varchar(1000) NOT NULL,
  `total` decimal(25,2) NOT NULL,
  `attachment` varchar(255) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `received` tinyint(1) DEFAULT NULL,
  `TotalDebit` decimal(25,0) DEFAULT NULL,
  `WorkStatusDate` varchar(100) DEFAULT NULL,
  `Reason` varchar(255) DEFAULT NULL,
  `SourceBilling` varchar(255) DEFAULT NULL,
  `Hash` varchar(2555) DEFAULT NULL,
  `HashControl` varchar(2555) DEFAULT NULL,
  `Pediod` varchar(255) DEFAULT NULL,
  `WorkDate` date DEFAULT NULL,
  `WorkType` varchar(255) DEFAULT NULL,
  `SourceID` int(11) DEFAULT NULL,
  `EACCode` varchar(255) DEFAULT NULL,
  `CustomerID` int(11) DEFAULT NULL,
  `LineNumber` int(11) DEFAULT NULL,
  `OriginatingON` varchar(255) DEFAULT NULL,
  `OrderDate` date DEFAULT NULL,
  `ProductCode` varchar(255) DEFAULT NULL,
  `ProductDescription` varchar(255) DEFAULT NULL,
  `Quantity` decimal(25,2) DEFAULT NULL,
  `UnitOfMeasure` varchar(255) DEFAULT NULL,
  `UnitPrice` decimal(10,2) DEFAULT NULL,
  `TaxPointDate` date DEFAULT NULL,
  `Description` varchar(255) DEFAULT NULL,
  `SerialNumber` int(11) DEFAULT NULL,
  `DebitAmount` decimal(10,2) DEFAULT NULL,
  `TaxType` varchar(4) DEFAULT NULL,
  `TaxCountryRegion` varchar(255) DEFAULT NULL,
  `TaxCode` varchar(255) DEFAULT NULL,
  `TaxPercentage` varchar(255) DEFAULT NULL,
  `SettlementAmount` varchar(255) DEFAULT NULL,
  `TaxPayable` decimal(10,2) DEFAULT NULL,
  `NetTotal` decimal(10,2) DEFAULT NULL,
  `GrossTotal` decimal(10,2) DEFAULT NULL,
  `paid` decimal(25,4) DEFAULT NULL,
  `status` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

INSERT INTO `tec_purchases` (`id`, `reference`, `date`, `note`, `total`, `attachment`, `supplier_id`, `received`, `TotalDebit`, `WorkStatusDate`, `Reason`, `SourceBilling`, `Hash`, `HashControl`, `Pediod`, `WorkDate`, `WorkType`, `SourceID`, `EACCode`, `CustomerID`, `LineNumber`, `OriginatingON`, `OrderDate`, `ProductCode`, `ProductDescription`, `Quantity`, `UnitOfMeasure`, `UnitPrice`, `TaxPointDate`, `Description`, `SerialNumber`, `DebitAmount`, `TaxType`, `TaxCountryRegion`, `TaxCode`, `TaxPercentage`, `SettlementAmount`, `TaxPayable`, `NetTotal`, `GrossTotal`, `paid`, `status`) VALUES ('5', '', '2023-02-01 15:28:00', '', '1824.00', NULL, '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1824.00', '1824.0000', 'paid');


#
# TABLE STRUCTURE FOR: tec_regime
#

DROP TABLE IF EXISTS `tec_regime`;

CREATE TABLE `tec_regime` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(200) NOT NULL,
  `reason` varchar(250) NOT NULL,
  `tax` varchar(20) NOT NULL DEFAULT '0',
  `tax_type` varchar(4) DEFAULT NULL,
  `tax_code` varchar(4) DEFAULT NULL,
  `metodo` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

INSERT INTO `tec_regime` (`id`, `code`, `reason`, `tax`, `tax_type`, `tax_code`, `metodo`) VALUES ('1', 'M04', 'IVA – Regime de Exclusão', '0', 'NS', 'ISE', NULL);
INSERT INTO `tec_regime` (`id`, `code`, `reason`, `tax`, `tax_type`, `tax_code`, `metodo`) VALUES ('3', 'M00', 'Regime Simplificado', '3', 'IVA', 'OUT', NULL);
INSERT INTO `tec_regime` (`id`, `code`, `reason`, `tax`, `tax_type`, `tax_code`, `metodo`) VALUES ('4', 'M01', 'Regime Geral', '14', 'IVA', 'NOR', NULL);


#
# TABLE STRUCTURE FOR: tec_registers
#

DROP TABLE IF EXISTS `tec_registers`;

CREATE TABLE `tec_registers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `user_id` int(11) NOT NULL,
  `cash_in_hand` decimal(25,2) NOT NULL,
  `status` varchar(10) NOT NULL,
  `total_cash` decimal(25,2) DEFAULT NULL,
  `total_cheques` int(11) DEFAULT NULL,
  `total_cc_slips` int(11) DEFAULT NULL,
  `total_cash_submitted` decimal(25,2) DEFAULT NULL,
  `total_cheques_submitted` int(11) DEFAULT NULL,
  `total_cc_slips_submitted` int(11) DEFAULT NULL,
  `note` text,
  `closed_at` timestamp NULL DEFAULT NULL,
  `transfer_opened_bills` varchar(50) DEFAULT NULL,
  `closed_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

INSERT INTO `tec_registers` (`id`, `date`, `user_id`, `cash_in_hand`, `status`, `total_cash`, `total_cheques`, `total_cc_slips`, `total_cash_submitted`, `total_cheques_submitted`, `total_cc_slips_submitted`, `note`, `closed_at`, `transfer_opened_bills`, `closed_by`) VALUES ('7', '2024-01-09 17:13:08', '16', '0.00', 'close', '2400000.00', '0', '1', '2400000.00', '0', '1', '', '2024-01-21 23:23:13', NULL, '16');
INSERT INTO `tec_registers` (`id`, `date`, `user_id`, `cash_in_hand`, `status`, `total_cash`, `total_cheques`, `total_cc_slips`, `total_cash_submitted`, `total_cheques_submitted`, `total_cc_slips_submitted`, `note`, `closed_at`, `transfer_opened_bills`, `closed_by`) VALUES ('8', '2024-01-21 23:23:20', '16', '0.00', 'close', '303900.00', '0', '1', '303900.00', '0', '1', '', '2024-01-22 00:14:27', NULL, '16');
INSERT INTO `tec_registers` (`id`, `date`, `user_id`, `cash_in_hand`, `status`, `total_cash`, `total_cheques`, `total_cc_slips`, `total_cash_submitted`, `total_cheques_submitted`, `total_cc_slips_submitted`, `note`, `closed_at`, `transfer_opened_bills`, `closed_by`) VALUES ('9', '2024-01-22 01:27:31', '16', '0.00', 'close', '450000.00', '0', '3', '450000.00', '0', '3', '', '2024-01-22 14:13:12', NULL, '16');
INSERT INTO `tec_registers` (`id`, `date`, `user_id`, `cash_in_hand`, `status`, `total_cash`, `total_cheques`, `total_cc_slips`, `total_cash_submitted`, `total_cheques_submitted`, `total_cc_slips_submitted`, `note`, `closed_at`, `transfer_opened_bills`, `closed_by`) VALUES ('10', '2024-01-22 14:13:22', '16', '0.00', 'open', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `tec_registers` (`id`, `date`, `user_id`, `cash_in_hand`, `status`, `total_cash`, `total_cheques`, `total_cc_slips`, `total_cash_submitted`, `total_cheques_submitted`, `total_cc_slips_submitted`, `note`, `closed_at`, `transfer_opened_bills`, `closed_by`) VALUES ('11', '2024-01-22 14:14:26', '41', '0.00', 'open', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `tec_registers` (`id`, `date`, `user_id`, `cash_in_hand`, `status`, `total_cash`, `total_cheques`, `total_cc_slips`, `total_cash_submitted`, `total_cheques_submitted`, `total_cc_slips_submitted`, `note`, `closed_at`, `transfer_opened_bills`, `closed_by`) VALUES ('12', '2024-02-07 11:53:33', '42', '0.00', 'open', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `tec_registers` (`id`, `date`, `user_id`, `cash_in_hand`, `status`, `total_cash`, `total_cheques`, `total_cc_slips`, `total_cash_submitted`, `total_cheques_submitted`, `total_cc_slips_submitted`, `note`, `closed_at`, `transfer_opened_bills`, `closed_by`) VALUES ('13', '2024-02-07 11:58:27', '43', '0.00', 'open', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);


#
# TABLE STRUCTURE FOR: tec_saf_setting
#

DROP TABLE IF EXISTS `tec_saf_setting`;

CREATE TABLE `tec_saf_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field` text NOT NULL,
  `value` longtext NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

INSERT INTO `tec_saf_setting` (`id`, `field`, `value`) VALUES ('1', 'xsd_content,xml_pattern,audit_pattern,header_pattern,account_pattern,customer_pattern,supplier_pattern,product_pattern,taxtable_pattern,generalledgerentries_pattern,saleinvoice_pattern,movementofgood_pattern,workingdocuments_pattern,payment_pattern,purchaseinvoice_pattern', '');
INSERT INTO `tec_saf_setting` (`id`, `field`, `value`) VALUES ('2', 'xsd_content', '<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<xs:schema xmlns:doc=\"urn:schemas-basda-org:schema-extensions:documentation\" \r\n  xmlns:ns=\"urn:OECD:StandardAuditFile-Tax:AO_1.01_01\" \r\n  xmlns=\"urn:OECD:StandardAuditFile-Tax:AO_1.01_01\" attributeFormDefault=\"unqualified\" elementFormDefault=\"qualified\" targetNamespace=\"urn:OECD:StandardAuditFile-Tax:AO_1.01_01\" version=\"1.01_01\" id=\"SAF-T_AO\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">\r\n\r\n  <xs:annotation>\r\n    <xs:documentation>\r\n      <doc:Title>Standard Audit File - Angola</doc:Title>\r\n      <doc:Subject>Standard Audit File - Angola</doc:Subject>\r\n      <doc:Copyright>Copyright OECD</doc:Copyright>\r\n      <doc:Version>\r\n        <doc:Number>1.01_01</doc:Number>\r\n        <doc:Status>Developement</doc:Status>\r\n        <doc:Repository>https://github.com/assoft-portugal/SAF-T-AO/</doc:Repository>\r\n      </doc:Version>\r\n      <doc:Author>AGT - Administração Geral Tributária</doc:Author>\r\n      <!-- Contributos para o Projeto -->\r\n      <doc:Contributors>\r\n        <doc:Contributor name=\"ASSOFT - Associação Portuguesa de Software\" url=\"https://www.assoft.org/\" />\r\n        <doc:Contributor name=\"Nelson Lopes\" url=\"https://github.com/cryptolopes/\" />\r\n        <doc:Contributor name=\"PRIMAVERA - Business Software Solutions, S.A.\" url=\"http://www.primaverabss.com/\" />\r\n        <doc:Contributor name=\"Softpack - Software, Lda\" url=\"https://www.softpack.pt/\" />\r\n        <doc:Contributor name=\"Cacimbo Angola\" url=\"https://www.cacimboangola.com/\" />\r\n        <doc:Contributor name=\"Infodelivery S.A.\" url=\"http://www.infodelivery.pt/\" />\r\n        <doc:Contributor name=\"Eticadata Software Lda\" url=\"http://www.eticadata.pt/\" />\r\n        <doc:Contributor name=\"SOFTSTORE, S.A.\" url=\"http://www.softstore.pt/\" />\r\n      </doc:Contributors>\r\n      <doc:ModificationDate>2017-10-25</doc:ModificationDate>\r\n    </xs:documentation>\r\n  </xs:annotation>\r\n  <!-- Estrutura do ficheiro SAFT-AO-->\r\n  <xs:element name=\"AuditFile\">\r\n    <xs:complexType>\r\n      <xs:sequence>\r\n        <xs:element minOccurs=\"1\" ref=\"Header\" />\r\n        <xs:element name=\"MasterFiles\">\r\n          <xs:complexType>\r\n            <xs:sequence>\r\n              <xs:element minOccurs=\"0\" maxOccurs=\"unbounded\" ref=\"GeneralLedgerAccounts\" />\r\n              <xs:element minOccurs=\"0\" maxOccurs=\"unbounded\" ref=\"Customer\" />\r\n              <xs:element minOccurs=\"0\" maxOccurs=\"unbounded\" ref=\"Supplier\" />\r\n              <xs:element minOccurs=\"0\" maxOccurs=\"unbounded\" ref=\"Product\" />\r\n              <xs:element minOccurs=\"0\" ref=\"TaxTable\" />\r\n            </xs:sequence>\r\n          </xs:complexType>\r\n        </xs:element>\r\n        <xs:element minOccurs=\"0\" ref=\"GeneralLedgerEntries\" />\r\n        <xs:element minOccurs=\"0\" ref=\"SourceDocuments\" />\r\n      </xs:sequence>\r\n    </xs:complexType>\r\n    <!-- Constraint-->\r\n    <xs:unique name=\"AccountIDConstraint\">\r\n      <xs:selector xpath=\"ns:MasterFiles/ns:GeneralLedgerAccounts\" />\r\n      <xs:field xpath=\"ns:AccountID\" />\r\n    </xs:unique>\r\n    <xs:keyref name=\"GroupingCodeConstraint\" refer=\"AccountIDConstraint\">\r\n      <xs:selector xpath=\"ns:MasterFiles/ns:GeneralLedgerAccounts/ns:Account\"/>\r\n      <xs:field xpath=\"ns:GroupingCode\"/>\r\n    </xs:keyref>\r\n    <xs:unique name=\"CustomerIDConstraint\">\r\n      <xs:selector xpath=\"ns:MasterFiles/ns:Customer\" />\r\n      <xs:field xpath=\"ns:CustomerID\" />\r\n    </xs:unique>\r\n    <xs:unique name=\"SupplierIDConstraint\">\r\n      <xs:selector xpath=\"ns:MasterFiles/ns:Supplier\" />\r\n      <xs:field xpath=\"ns:SupplierID\" />\r\n    </xs:unique>\r\n    <xs:unique name=\"ProductCodeConstraint\">\r\n      <xs:selector xpath=\"ns:MasterFiles/ns:Product\" />\r\n      <xs:field xpath=\"ns:ProductCode\" />\r\n    </xs:unique>\r\n    <xs:keyref name=\"GeneralLedgerEntriesDebitLineAccountIDConstraint\" refer=\"AccountIDConstraint\">\r\n      <xs:selector xpath=\"ns:GeneralLedgerEntries/ns:Journal/ns:Transaction/ns:Lines/ns:DebitLine\"/>\r\n      <xs:field xpath=\"ns:AccountID\"/>\r\n    </xs:keyref>\r\n    <xs:keyref name=\"GeneralLedgerEntriesCreditLineAccountIDConstraint\" refer=\"AccountIDConstraint\">\r\n      <xs:selector xpath=\"ns:GeneralLedgerEntries/ns:Journal/ns:Transaction/ns:Lines/ns:CreditLine\"/>\r\n      <xs:field xpath=\"ns:AccountID\"/>\r\n    </xs:keyref>\r\n    <xs:keyref name=\"GeneralLedgerEntriesCustomerIDConstraint\" refer=\"CustomerIDConstraint\">\r\n      <xs:selector xpath=\"ns:GeneralLedgerEntries/ns:Journal/ns:Transaction\"/>\r\n      <xs:field xpath=\"ns:CustomerID\"/>\r\n    </xs:keyref>\r\n    <xs:unique name=\"GeneralLedgerEntriesJournalIdConstraint\">\r\n      <xs:selector xpath=\"ns:GeneralLedgerEntries/ns:Journal\"/>\r\n      <xs:field xpath=\"ns:JournalID\"/>\r\n    </xs:unique>\r\n    <xs:keyref name=\"GeneralLedgerEntriesSupplierIDConstraint\" refer=\"SupplierIDConstraint\">\r\n      <xs:selector xpath=\"ns:GeneralLedgerEntries/ns:Journal/ns:Transaction\"/>\r\n      <xs:field xpath=\"ns:SupplierID\"/>\r\n    </xs:keyref>\r\n    <xs:unique name=\"GeneralLedgerEntriesTransactionIdConstraint\">\r\n      <xs:selector xpath=\"ns:GeneralLedgerEntries/ns:Journal/ns:Transaction\"/>\r\n      <xs:field xpath=\"ns:TransactionID\"/>\r\n    </xs:unique>\r\n    <xs:keyref name=\"GeneralLedgerEntriesAccountIDConstraint\" refer=\"AccountIDConstraint\">\r\n      <xs:selector xpath=\"ns:GeneralLedgerEntries/ns:Journal/ns:Transaction/ns:Line\" />\r\n      <xs:field xpath=\"ns:AccountID\" />\r\n    </xs:keyref>\r\n    <xs:unique name=\"InvoiceNoConstraint\">\r\n      <xs:selector xpath=\"ns:SourceDocuments/ns:SalesInvoices/ns:Invoice\" />\r\n      <xs:field xpath=\"ns:InvoiceNo\" />\r\n    </xs:unique>\r\n    <xs:keyref name=\"InvoiceCustomerIDConstraint\" refer=\"CustomerIDConstraint\">\r\n      <xs:selector xpath=\"ns:SourceDocuments/ns:SalesInvoices/ns:Invoice\" />\r\n      <xs:field xpath=\"ns:CustomerID\" />\r\n    </xs:keyref>\r\n    <xs:keyref name=\"InvoiceProductCodeConstraint\" refer=\"ProductCodeConstraint\">\r\n      <xs:selector xpath=\"ns:SourceDocuments/ns:SalesInvoices/ns:Invoice/ns:Line\" />\r\n      <xs:field xpath=\"ns:ProductCode\" />\r\n    </xs:keyref>\r\n    <xs:unique name=\"DocumentNumberConstraint\">\r\n      <xs:selector xpath=\"ns:SourceDocuments/ns:MovementOfGoods/ns:StockMovement\" />\r\n      <xs:field xpath=\"ns:DocumentNumber\" />\r\n    </xs:unique>\r\n    <xs:keyref name=\"StockMovementCustomerIDConstraint\" refer=\"CustomerIDConstraint\">\r\n      <xs:selector xpath=\"ns:SourceDocuments/ns:MovementOfGoods/ns:StockMovement\" />\r\n      <xs:field xpath=\"ns:CustomerID\" />\r\n    </xs:keyref>\r\n    <xs:keyref name=\"StockMovementSupplierIDConstraint\" refer=\"SupplierIDConstraint\">\r\n      <xs:selector xpath=\"ns:SourceDocuments/ns:MovementOfGoods/ns:StockMovement\" />\r\n      <xs:field xpath=\"ns:SupplierID\" />\r\n    </xs:keyref>\r\n    <xs:keyref name=\"StockMovementProductCodeConstraint\" refer=\"ProductCodeConstraint\">\r\n      <xs:selector xpath=\"ns:SourceDocuments/ns:MovementOfGoods/ns:StockMovement/ns:Line\" />\r\n      <xs:field xpath=\"ns:ProductCode\" />\r\n    </xs:keyref>\r\n    <xs:unique name=\"WorkDocumentDocumentNumberConstraint\">\r\n      <xs:selector xpath=\"ns:SourceDocuments/ns:WorkingDocuments/ns:WorkDocument\" />\r\n      <xs:field xpath=\"ns:DocumentNumber\" />\r\n    </xs:unique>\r\n    <xs:keyref name=\"WorkDocumentDocumentCustomerIDConstraint\" refer=\"CustomerIDConstraint\">\r\n      <xs:selector xpath=\"ns:SourceDocuments/ns:WorkingDocuments/ns:WorkDocument\" />\r\n      <xs:field xpath=\"ns:CustomerID\" />\r\n    </xs:keyref>\r\n    <xs:keyref name=\"WorkDocumentDocumentProductCodeConstraint\" refer=\"ProductCodeConstraint\">\r\n      <xs:selector xpath=\"ns:SourceDocuments/ns:WorkingDocuments/ns:WorkDocument/ns:Line\" />\r\n      <xs:field xpath=\"ns:ProductCode\" />\r\n    </xs:keyref>\r\n    <xs:unique name=\"PaymentPaymentRefNoConstraint\">\r\n      <xs:selector xpath=\"ns:SourceDocuments/ns:Payments/ns:Payment\" />\r\n      <xs:field xpath=\"ns:PaymentRefNo\" />\r\n    </xs:unique>\r\n    <xs:keyref name=\"PaymentPaymentRefNoCustomerIDConstraint\" refer=\"CustomerIDConstraint\">\r\n      <xs:selector xpath=\"ns:SourceDocuments/ns:Payments/ns:Payment\" />\r\n      <xs:field xpath=\"ns:CustomerID\" />\r\n    </xs:keyref>\r\n    <!-- Constraints de Documentos Comerciais de Fornecedores -->\r\n    <xs:unique name=\"InvoicesNoConstraint\">\r\n      <xs:selector xpath=\"ns:SourceDocuments/ns:PurchaseInvoices/ns:Invoices\" />\r\n      <xs:field xpath=\"ns:InvoiceNo\" />\r\n    </xs:unique>\r\n    <xs:keyref name=\"InvoiceSupplierIDConstraint\" refer=\"SupplierIDConstraint\">\r\n      <xs:selector xpath=\"ns:SourceDocuments/ns:PurchaseInvoices/ns:Invoices\" />\r\n      <xs:field xpath=\"ns:SupplierID\" />\r\n    </xs:keyref>\r\n  </xs:element>\r\n  <!-- Estrutura de cabecalho (AuditFile.Header) -->\r\n  <xs:element name=\"Header\">\r\n    <xs:complexType>\r\n      <xs:sequence>\r\n        <xs:element ref=\"AuditFileVersion\" />\r\n        <xs:element ref=\"CompanyID\" />\r\n        <xs:element name=\"TaxRegistrationNumber\" type=\"SAFAOAngolaVatNumber\" />\r\n        <xs:element ref=\"TaxAccountingBasis\" />\r\n        <xs:element ref=\"CompanyName\" />\r\n        <xs:element minOccurs=\"0\" ref=\"BusinessName\" />\r\n        <xs:element ref=\"CompanyAddress\" />\r\n        <xs:element ref=\"FiscalYear\" />\r\n        <xs:element ref=\"StartDate\" />\r\n        <xs:element ref=\"EndDate\" />\r\n        <xs:element name=\"CurrencyCode\" minOccurs=\"1\" maxOccurs=\"1\">\r\n          <xs:simpleType>\r\n            <xs:restriction base=\"xs:string\">\r\n              <xs:enumeration value=\"AOA\" />\r\n              <xs:enumeration value=\"USD\" />\r\n            </xs:restriction>\r\n          </xs:simpleType>\r\n        </xs:element>\r\n        <xs:element ref=\"DateCreated\" />\r\n        <xs:element ref=\"TaxEntity\" />\r\n        <xs:element ref=\"ProductCompanyTaxID\" />\r\n        <xs:element ref=\"SoftwareValidationNumber\" />\r\n        <xs:element ref=\"ProductID\" />\r\n        <xs:element ref=\"ProductVersion\" />\r\n        <xs:element minOccurs=\"0\" ref=\"HeaderComment\" />\r\n        <xs:element minOccurs=\"0\" ref=\"Telephone\" />\r\n        <xs:element minOccurs=\"0\" ref=\"Fax\" />\r\n        <xs:element minOccurs=\"0\" ref=\"Email\" />\r\n        <xs:element minOccurs=\"0\" ref=\"Website\" />\r\n      </xs:sequence>\r\n    </xs:complexType>\r\n  </xs:element>\r\n  <!-- Ficheiros Mestre (AuditFile.MasterFiles) -->\r\n  <!--    Estrutura do Plano de Contas (AuditFile.MasterFiles.GeneralLedger)-->\r\n  <xs:element name=\"GeneralLedgerAccounts\">\r\n    <xs:complexType>\r\n      <xs:sequence>\r\n        <xs:element name=\"Account\" maxOccurs=\"unbounded\">\r\n          <xs:complexType>\r\n            <xs:sequence>\r\n              <xs:element name=\"AccountID\" type=\"SAFAOGLAccountID\" />\r\n              <xs:element ref=\"AccountDescription\" />\r\n              <xs:element ref=\"OpeningDebitBalance\" />\r\n              <xs:element ref=\"OpeningCreditBalance\" />\r\n              <xs:element ref=\"ClosingDebitBalance\" />\r\n              <xs:element ref=\"ClosingCreditBalance\" />\r\n              <xs:element ref=\"GroupingCategory\" />\r\n              <xs:element minOccurs=\"0\" name=\"GroupingCode\" type=\"SAFAOGLAccountID\" />\r\n            </xs:sequence>\r\n          </xs:complexType>\r\n        </xs:element>\r\n      </xs:sequence>\r\n    </xs:complexType>\r\n  </xs:element>\r\n  <!--    Estrutura de Cliente (AuditFile.MasterFiles.Customer) -->\r\n  <xs:element name=\"Customer\">\r\n    <xs:complexType>\r\n      <xs:sequence>\r\n        <xs:element ref=\"CustomerID\" />\r\n        <xs:element ref=\"AccountID\" />\r\n        <xs:element ref=\"CustomerTaxID\" />\r\n        <xs:element ref=\"CompanyName\" />\r\n        <xs:element minOccurs=\"0\" ref=\"Contact\" />\r\n        <xs:element ref=\"BillingAddress\" />\r\n        <xs:element minOccurs=\"0\" maxOccurs=\"unbounded\" ref=\"ShipToAddress\" />\r\n        <xs:element minOccurs=\"0\" ref=\"Telephone\" />\r\n        <xs:element minOccurs=\"0\" ref=\"Fax\" />\r\n        <xs:element minOccurs=\"0\" ref=\"Email\" />\r\n        <xs:element minOccurs=\"0\" ref=\"Website\" />\r\n        <xs:element ref=\"SelfBillingIndicator\" />\r\n      </xs:sequence>\r\n    </xs:complexType>\r\n  </xs:element>\r\n  <!--    Estrutura de Fornecedor (AuditFile.MasterFiles.Supplier) -->\r\n  <xs:element name=\"Supplier\">\r\n    <xs:complexType>\r\n      <xs:sequence>\r\n        <xs:element ref=\"SupplierID\" />\r\n        <xs:element ref=\"AccountID\" />\r\n        <xs:element ref=\"SupplierTaxID\" />\r\n        <xs:element ref=\"CompanyName\" />\r\n        <xs:element minOccurs=\"0\" ref=\"Contact\" />\r\n        <xs:element name=\"BillingAddress\" type=\"SupplierAddressStructure\" />\r\n        <xs:element minOccurs=\"0\" maxOccurs=\"unbounded\" name=\"ShipFromAddress\" type=\"SupplierAddressStructure\" />\r\n        <xs:element minOccurs=\"0\" ref=\"Telephone\" />\r\n        <xs:element minOccurs=\"0\" ref=\"Fax\" />\r\n        <xs:element minOccurs=\"0\" ref=\"Email\" />\r\n        <xs:element minOccurs=\"0\" ref=\"Website\" />\r\n        <xs:element ref=\"SelfBillingIndicator\" />\r\n      </xs:sequence>\r\n    </xs:complexType>\r\n  </xs:element>\r\n  <!--    Estrutura de produto (AuditFile.MasterFiles.Product)-->\r\n  <xs:element name=\"Product\">\r\n    <xs:complexType>\r\n      <xs:sequence>\r\n        <xs:element ref=\"ProductType\" />\r\n        <xs:element ref=\"ProductCode\" />\r\n        <xs:element minOccurs=\"0\" ref=\"ProductGroup\" />\r\n        <xs:element ref=\"ProductDescription\" />\r\n        <xs:element ref=\"ProductNumberCode\" />\r\n        <xs:element name=\"CustomsDetails\" type=\"CustomsDetails\" minOccurs=\"0\" />\r\n      </xs:sequence>\r\n    </xs:complexType>\r\n  </xs:element>\r\n  <!--    Estrutura de Impostos (AuditFile.MasterFiles.TaxTable) -->\r\n  <xs:element name=\"TaxTable\">\r\n    <xs:complexType>\r\n      <xs:sequence>\r\n        <xs:element minOccurs=\"1\" maxOccurs=\"unbounded\" ref=\"TaxTableEntry\" />\r\n      </xs:sequence>\r\n    </xs:complexType>\r\n  </xs:element>\r\n  <!--    Estrutura de Imposto -->\r\n  <xs:element name=\"TaxTableEntry\">\r\n    <xs:complexType>\r\n      <xs:sequence>\r\n        <xs:element ref=\"TaxType\" />\r\n        <xs:element ref=\"TaxCountryRegion\" minOccurs=\"0\" />\r\n        <xs:element name=\"TaxCode\" type=\"TaxTableEntryTaxCode\" />\r\n        <xs:element name=\"Description\" type=\"SAFAOtextTypeMandatoryMax255Car\" />\r\n        <xs:element minOccurs=\"0\" ref=\"TaxExpirationDate\" />\r\n        <xs:choice>\r\n          <xs:element ref=\"TaxPercentage\" />\r\n          <xs:element ref=\"TaxAmount\" />\r\n        </xs:choice>\r\n      </xs:sequence>\r\n    </xs:complexType>\r\n  </xs:element>\r\n  <!-- Estrutura de Movimentos Contabilisticos (AuditFile.GeneralLedgerEntries)-->\r\n  <xs:element name=\"GeneralLedgerEntries\">\r\n    <xs:complexType>\r\n      <xs:annotation>\r\n        <xs:documentation>\r\n          Neste elemento registam-se os movimentos contabilísticos correspondentes ao periodo de exportação\r\n          a que diz respeito o SAF-T (AO), não devendo os movimentos de abertura ser objeto de exportação,\r\n          na medida em que estes são apenas refletidos ao nível do elemento GeneralLedgerAccounts.\r\n        </xs:documentation>\r\n      </xs:annotation>\r\n      <xs:sequence>\r\n        <xs:element ref=\"NumberOfEntries\" />\r\n        <xs:element ref=\"TotalDebit\" />\r\n        <xs:element ref=\"TotalCredit\" />\r\n        <xs:element minOccurs=\"0\" maxOccurs=\"unbounded\" name=\"Journal\">\r\n          <xs:complexType>\r\n            <xs:sequence>\r\n              <xs:element ref=\"JournalID\" />\r\n              <xs:element ref=\"Description\" />\r\n              <xs:element minOccurs=\"0\" maxOccurs=\"unbounded\" name=\"Transaction\">\r\n                <xs:complexType>\r\n                  <xs:sequence>\r\n                    <xs:element ref=\"TransactionID\" />\r\n                    <xs:element name=\"Period\" type=\"SAFAOAccountingPeriod\" />\r\n                    <xs:element ref=\"TransactionDate\" />\r\n                    <xs:element ref=\"SourceID\" />\r\n                    <xs:element ref=\"Description\" />\r\n                    <xs:element ref=\"DocArchivalNumber\" />\r\n                    <xs:element ref=\"TransactionType\" />\r\n                    <xs:element ref=\"GLPostingDate\" />\r\n                    <xs:choice>\r\n                      <xs:element minOccurs=\"0\" ref=\"CustomerID\" />\r\n                      <xs:element minOccurs=\"0\" ref=\"SupplierID\" />\r\n                    </xs:choice>\r\n                    <xs:element name=\"Lines\">\r\n                      <xs:complexType>\r\n                        <xs:annotation>\r\n                          <xs:documentation>\r\n                            Tem de ser tida em consideração a ordem dos elementos:\r\n                            * Primeiro os de DebitLine\r\n                            * Depois os de CreditLine\r\n                          </xs:documentation>\r\n                        </xs:annotation>\r\n                        <xs:sequence>\r\n                          <xs:group ref=\"DebitLineGroup\" minOccurs=\"1\" maxOccurs=\"unbounded\" />\r\n                          <xs:group ref=\"CreditLineGroup\" minOccurs=\"1\" maxOccurs=\"unbounded\" />\r\n                        </xs:sequence>\r\n                      </xs:complexType>\r\n                    </xs:element>\r\n                  </xs:sequence>\r\n                </xs:complexType>\r\n              </xs:element>\r\n            </xs:sequence>\r\n          </xs:complexType>\r\n        </xs:element>\r\n      </xs:sequence>\r\n    </xs:complexType>\r\n  </xs:element>\r\n  <!-- Estrutura de Documentos Comerciais (AuditFile.SourceDocuments)-->\r\n  <xs:element name=\"SourceDocuments\">\r\n    <xs:complexType>\r\n      <xs:sequence>\r\n        <xs:element minOccurs=\"0\" name=\"SalesInvoices\">\r\n          <xs:complexType>\r\n            <xs:sequence>\r\n              <xs:element ref=\"NumberOfEntries\" />\r\n              <xs:element ref=\"TotalDebit\" />\r\n              <xs:element ref=\"TotalCredit\" />\r\n              <xs:element minOccurs=\"0\" maxOccurs=\"unbounded\" name=\"Invoice\">\r\n                <xs:complexType>\r\n                  <xs:sequence>\r\n                    <xs:element ref=\"InvoiceNo\" />\r\n                    <!-- Estrutura da situacao atual do documento -->\r\n                    <xs:element name=\"DocumentStatus\">\r\n                      <xs:complexType>\r\n                        <xs:sequence>\r\n                          <xs:element ref=\"InvoiceStatus\" />\r\n                          <!-- Na exportacao de dados relativos a exercicios anteriores em que esta informacao seja desconhecida, este campo devera ser preenchido com a data do documento e hora como 00:00:00 -->\r\n                          <xs:element ref=\"InvoiceStatusDate\" />\r\n                          <xs:element minOccurs=\"0\" ref=\"Reason\" />\r\n                          <xs:element ref=\"SourceID\" />\r\n                          <xs:element name=\"SourceBilling\" type=\"SAFTAOSourceBilling\" />\r\n                        </xs:sequence>\r\n                      </xs:complexType>\r\n                    </xs:element>\r\n                    <xs:element ref=\"Hash\" />\r\n                    <xs:element ref=\"HashControl\" />\r\n                    <xs:element minOccurs=\"0\" ref=\"Period\" />\r\n                    <xs:element ref=\"InvoiceDate\" />\r\n                    <xs:element ref=\"InvoiceType\" />\r\n                    <xs:element name=\"SpecialRegimes\" type=\"SpecialRegimes\" />\r\n                    <xs:element ref=\"SourceID\" />\r\n                    <xs:element minOccurs=\"0\" ref=\"EACCode\" />\r\n                    <xs:element ref=\"SystemEntryDate\" />\r\n                    <xs:element minOccurs=\"0\" ref=\"TransactionID\" />\r\n                    <xs:element ref=\"CustomerID\" />\r\n                    <xs:element minOccurs=\"0\" maxOccurs=\"1\" ref=\"ShipTo\" />\r\n                    <xs:element minOccurs=\"0\" maxOccurs=\"1\" ref=\"ShipFrom\" />\r\n                    <xs:element minOccurs=\"0\" maxOccurs=\"1\" ref=\"MovementEndTime\" />\r\n                    <xs:element minOccurs=\"0\" maxOccurs=\"1\" ref=\"MovementStartTime\" />\r\n                    <xs:element maxOccurs=\"unbounded\" name=\"Line\">\r\n                      <xs:complexType>\r\n                        <xs:sequence>\r\n                          <xs:element ref=\"LineNumber\" />\r\n                          <xs:element minOccurs=\"0\" maxOccurs=\"unbounded\" name=\"OrderReferences\" type=\"OrderReferences\" />\r\n                          <xs:element ref=\"ProductCode\" />\r\n                          <xs:element ref=\"ProductDescription\" />\r\n                          <xs:element ref=\"Quantity\" />\r\n                          <xs:element ref=\"UnitOfMeasure\" />\r\n                          <xs:element ref=\"UnitPrice\" />\r\n                          <xs:element ref=\"TaxBase\" minOccurs=\"0\" />\r\n                          <xs:element ref=\"TaxPointDate\" />\r\n                          <xs:element minOccurs=\"0\" maxOccurs=\"unbounded\" name=\"References\" type=\"References\" />\r\n                          <xs:element ref=\"Description\" />\r\n                          <xs:element name=\"ProductSerialNumber\" type=\"ProductSerialNumber\" minOccurs=\"0\" />\r\n                          <xs:choice>\r\n                            <xs:element ref=\"DebitAmount\" />\r\n                            <xs:element ref=\"CreditAmount\" />\r\n                          </xs:choice>\r\n                          <xs:element name=\"Tax\" type=\"Tax\" />\r\n                          <xs:group ref=\"TaxExemptions\" minOccurs=\"0\" />\r\n                          <xs:element minOccurs=\"0\" ref=\"SettlementAmount\" />\r\n                          <xs:element name=\"CustomsInformation\" type=\"CustomsInformation\" minOccurs=\"0\" />\r\n                        </xs:sequence>\r\n                      </xs:complexType>\r\n                    </xs:element>\r\n                    <xs:element name=\"DocumentTotals\">\r\n                      <xs:complexType>\r\n                        <xs:sequence>\r\n                          <xs:element ref=\"TaxPayable\" />\r\n                          <xs:element ref=\"NetTotal\" />\r\n                          <xs:element ref=\"GrossTotal\" />\r\n                          <xs:element minOccurs=\"0\" name=\"Currency\" type=\"Currency\" />\r\n                          <!-- A estrutura Settlement representa acordos ou formas de pagamento futuros. Nao constitui em caso algum o somatorio dos descontos concedidos e reflectidos nas linhas dos documentos e a informacao aqui constante nao influi o montante total do documento (GrossTotal) -->\r\n                          <xs:element minOccurs=\"0\" maxOccurs=\"unbounded\" name=\"Settlement\" type=\"Settlement\" />\r\n                          <xs:element minOccurs=\"0\" maxOccurs=\"unbounded\" name=\"Payment\" type=\"PaymentMethod\" />\r\n                        </xs:sequence>\r\n                      </xs:complexType>\r\n                    </xs:element>\r\n                    <xs:element minOccurs=\"0\" maxOccurs=\"unbounded\" name=\"WithholdingTax\" type=\"WithholdingTax\" />\r\n                  </xs:sequence>\r\n                </xs:complexType>\r\n              </xs:element>\r\n            </xs:sequence>\r\n          </xs:complexType>\r\n        </xs:element>\r\n        <xs:element minOccurs=\"0\" name=\"MovementOfGoods\">\r\n          <xs:complexType>\r\n            <xs:sequence>\r\n              <xs:element ref=\"NumberOfMovementLines\" />\r\n              <xs:element ref=\"TotalQuantityIssued\" />\r\n              <xs:element minOccurs=\"0\" maxOccurs=\"unbounded\" name=\"StockMovement\">\r\n                <xs:complexType>\r\n                  <xs:sequence>\r\n                    <xs:element ref=\"DocumentNumber\" />\r\n                    <!-- Estrutura da situacao atual do documento -->\r\n                    <xs:element name=\"DocumentStatus\">\r\n                      <xs:complexType>\r\n                        <xs:sequence>\r\n                          <xs:element ref=\"MovementStatus\" />\r\n                          <!-- Na exportacao de dados relativos a exercicios anteriores em que esta informacao seja desconhecida, este campo devera ser preenchido com a data do documento e hora como 00:00:00 -->\r\n                          <xs:element ref=\"MovementStatusDate\" />\r\n                          <xs:element minOccurs=\"0\" ref=\"Reason\" />\r\n                          <xs:element ref=\"SourceID\" />\r\n                          <xs:element name=\"SourceBilling\" type=\"SAFTAOSourceBilling\" />\r\n                        </xs:sequence>\r\n                      </xs:complexType>\r\n                    </xs:element>\r\n                    <xs:element ref=\"Hash\" />\r\n                    <xs:element ref=\"HashControl\" />\r\n                    <xs:element minOccurs=\"0\" ref=\"Period\" />\r\n                    <xs:element ref=\"MovementDate\" />\r\n                    <xs:element ref=\"MovementType\" />\r\n                    <xs:element ref=\"SystemEntryDate\" />\r\n                    <xs:element minOccurs=\"0\" ref=\"TransactionID\" />\r\n                    <xs:choice>\r\n                      <xs:element ref=\"CustomerID\" />\r\n                      <xs:element ref=\"SupplierID\" />\r\n                    </xs:choice>\r\n                    <xs:element ref=\"SourceID\" />\r\n                    <xs:element minOccurs=\"0\" ref=\"EACCode\" />\r\n                    <xs:element minOccurs=\"0\" ref=\"MovementComments\" />\r\n                    <xs:element minOccurs=\"0\" maxOccurs=\"1\" ref=\"ShipTo\" />\r\n                    <xs:element minOccurs=\"0\" maxOccurs=\"1\" ref=\"ShipFrom\" />\r\n                    <xs:element minOccurs=\"0\" maxOccurs=\"1\" ref=\"MovementEndTime\" />\r\n                    <xs:element maxOccurs=\"1\" ref=\"MovementStartTime\" />\r\n                    <xs:element minOccurs=\"0\" maxOccurs=\"1\" ref=\"AGTDocCodeID\" />\r\n                    <xs:element maxOccurs=\"unbounded\" name=\"Line\">\r\n                      <xs:complexType>\r\n                        <xs:sequence>\r\n                          <xs:element ref=\"LineNumber\" />\r\n                          <xs:element minOccurs=\"0\" maxOccurs=\"unbounded\" name=\"OrderReferences\" type=\"OrderReferences\" />\r\n                          <xs:element ref=\"ProductCode\" />\r\n                          <xs:element ref=\"ProductDescription\" />\r\n                          <xs:element ref=\"Quantity\" />\r\n                          <xs:element ref=\"UnitOfMeasure\" />\r\n                          <xs:element ref=\"UnitPrice\" />\r\n                          <xs:element ref=\"Description\" />\r\n                          <xs:element name=\"ProductSerialNumber\" type=\"ProductSerialNumber\" minOccurs=\"0\" />\r\n                          <xs:choice>\r\n                            <xs:element ref=\"DebitAmount\" />\r\n                            <xs:element ref=\"CreditAmount\" />\r\n                          </xs:choice>\r\n                          <xs:element minOccurs=\"0\" name=\"Tax\" type=\"MovementTax\" />\r\n                          <xs:group minOccurs=\"0\" ref=\"TaxExemptions\" />\r\n                          <xs:element minOccurs=\"0\" ref=\"SettlementAmount\" />\r\n                          <xs:element name=\"CustomsInformation\" type=\"CustomsInformation\" minOccurs=\"0\" />\r\n                        </xs:sequence>\r\n                      </xs:complexType>\r\n                    </xs:element>\r\n                    <xs:element name=\"DocumentTotals\">\r\n                      <xs:complexType>\r\n                        <xs:sequence>\r\n                          <xs:element ref=\"TaxPayable\" />\r\n                          <xs:element ref=\"NetTotal\" />\r\n                          <xs:element ref=\"GrossTotal\" />\r\n                          <xs:element minOccurs=\"0\" name=\"Currency\" type=\"Currency\" />\r\n                        </xs:sequence>\r\n                      </xs:complexType>\r\n                    </xs:element>\r\n                  </xs:sequence>\r\n                </xs:complexType>\r\n              </xs:element>\r\n            </xs:sequence>\r\n          </xs:complexType>\r\n        </xs:element>\r\n        <xs:element minOccurs=\"0\" name=\"WorkingDocuments\">\r\n          <xs:complexType>\r\n            <xs:sequence>\r\n              <xs:element ref=\"NumberOfEntries\" />\r\n              <xs:element ref=\"TotalDebit\" />\r\n              <xs:element ref=\"TotalCredit\" />\r\n              <xs:element minOccurs=\"0\" maxOccurs=\"unbounded\" name=\"WorkDocument\">\r\n                <xs:complexType>\r\n                  <xs:sequence>\r\n                    <xs:element ref=\"DocumentNumber\" />\r\n                    <xs:element name=\"DocumentStatus\">\r\n                      <xs:complexType>\r\n                        <xs:sequence>\r\n                          <xs:element ref=\"WorkStatus\" />\r\n                          <!-- Na exportacao de dados relativos a exercicios anteriores em que esta informacao seja desconhecida, este campo devera ser preenchido com a data do documento e hora como 00:00:00 -->\r\n                          <xs:element ref=\"WorkStatusDate\" />\r\n                          <xs:element minOccurs=\"0\" ref=\"Reason\" />\r\n                          <xs:element ref=\"SourceID\" />\r\n                          <xs:element name=\"SourceBilling\" type=\"SAFTAOSourceBilling\" />\r\n                        </xs:sequence>\r\n                      </xs:complexType>\r\n                    </xs:element>\r\n                    <xs:element ref=\"Hash\" />\r\n                    <xs:element ref=\"HashControl\" />\r\n                    <xs:element minOccurs=\"0\" ref=\"Period\" />\r\n                    <xs:element ref=\"WorkDate\" />\r\n                    <xs:element ref=\"WorkType\" />\r\n                    <xs:element ref=\"SourceID\" />\r\n                    <xs:element minOccurs=\"0\" ref=\"EACCode\" />\r\n                    <xs:element ref=\"SystemEntryDate\" />\r\n                    <xs:element ref=\"CustomerID\" />\r\n                    <xs:element maxOccurs=\"unbounded\" name=\"Line\">\r\n                      <xs:complexType>\r\n                        <xs:sequence>\r\n                          <xs:element ref=\"LineNumber\" />\r\n                          <xs:element minOccurs=\"0\" maxOccurs=\"unbounded\" name=\"OrderReferences\" type=\"OrderReferences\" />\r\n                          <xs:element ref=\"ProductCode\" />\r\n                          <xs:element ref=\"ProductDescription\" />\r\n                          <xs:element ref=\"Quantity\" />\r\n                          <xs:element ref=\"UnitOfMeasure\" />\r\n                          <xs:element ref=\"UnitPrice\" />\r\n                          <xs:element ref=\"TaxPointDate\" />\r\n                          <xs:element ref=\"Description\" />\r\n                          <xs:element name=\"ProductSerialNumber\" type=\"ProductSerialNumber\" minOccurs=\"0\" />\r\n                          <xs:choice>\r\n                            <xs:element ref=\"DebitAmount\" />\r\n                            <xs:element ref=\"CreditAmount\" />\r\n                          </xs:choice>\r\n                          <xs:element minOccurs=\"0\" name=\"Tax\" type=\"Tax\" />\r\n                          <xs:group ref=\"TaxExemptions\" minOccurs=\"0\" />\r\n                          <xs:element minOccurs=\"0\" ref=\"SettlementAmount\" />\r\n                        </xs:sequence>\r\n                      </xs:complexType>\r\n                    </xs:element>\r\n                    <xs:element name=\"DocumentTotals\">\r\n                      <xs:complexType>\r\n                        <xs:sequence>\r\n                          <xs:element ref=\"TaxPayable\" />\r\n                          <xs:element ref=\"NetTotal\" />\r\n                          <xs:element ref=\"GrossTotal\" />\r\n                          <xs:element minOccurs=\"0\" name=\"Currency\" type=\"Currency\" />\r\n                        </xs:sequence>\r\n                      </xs:complexType>\r\n                    </xs:element>\r\n                  </xs:sequence>\r\n                </xs:complexType>\r\n              </xs:element>\r\n            </xs:sequence>\r\n          </xs:complexType>\r\n        </xs:element>\r\n        <xs:element minOccurs=\"0\" name=\"Payments\">\r\n          <xs:complexType>\r\n            <xs:sequence>\r\n              <xs:element ref=\"NumberOfEntries\" />\r\n              <xs:element ref=\"TotalDebit\" />\r\n              <xs:element ref=\"TotalCredit\" />\r\n              <xs:element minOccurs=\"0\" maxOccurs=\"unbounded\" name=\"Payment\">\r\n                <xs:complexType>\r\n                  <xs:sequence>\r\n                    <xs:element ref=\"PaymentRefNo\" />\r\n                    <xs:element minOccurs=\"0\" ref=\"Period\" />\r\n                    <xs:element minOccurs=\"0\" ref=\"TransactionID\" />\r\n                    <xs:element ref=\"TransactionDate\" />\r\n                    <xs:element name=\"PaymentType\" type=\"SAFTAOPaymentType\" />\r\n                    <xs:element minOccurs=\"0\" ref=\"Description\" />\r\n                    <xs:element minOccurs=\"0\" ref=\"SystemID\" />\r\n                    <xs:element name=\"DocumentStatus\">\r\n                      <xs:complexType>\r\n                        <xs:sequence>\r\n                          <xs:element ref=\"PaymentStatus\" />\r\n                          <!-- Na exportacao de dados relativos a exercicios anteriores em que esta informacao seja desconhecida, este campo devera ser preenchido com a data do documento e hora como 00:00:00 -->\r\n                          <xs:element ref=\"PaymentStatusDate\" />\r\n                          <xs:element minOccurs=\"0\" ref=\"Reason\" />\r\n                          <xs:element ref=\"SourceID\" />\r\n                          <xs:element name=\"SourcePayment\" type=\"SAFTAOSourcePayment\" />\r\n                        </xs:sequence>\r\n                      </xs:complexType>\r\n                    </xs:element>\r\n                    <xs:element minOccurs=\"0\" maxOccurs=\"unbounded\" name=\"PaymentMethod\" type=\"PaymentMethod\" />\r\n                    <xs:element ref=\"SourceID\" />\r\n                    <xs:element ref=\"SystemEntryDate\" />\r\n                    <xs:element ref=\"CustomerID\" />\r\n                    <xs:element maxOccurs=\"unbounded\" name=\"Line\">\r\n                      <xs:complexType>\r\n                        <xs:sequence>\r\n                          <xs:element ref=\"LineNumber\" />\r\n                          <xs:element maxOccurs=\"unbounded\" name=\"SourceDocumentID\">\r\n                            <xs:complexType>\r\n                              <xs:sequence>\r\n                                <xs:element ref=\"OriginatingON\" />\r\n                                <xs:element ref=\"InvoiceDate\" />\r\n                                <xs:element minOccurs=\"0\" ref=\"Description\" />\r\n                              </xs:sequence>\r\n                            </xs:complexType>\r\n                          </xs:element>\r\n                          <xs:element minOccurs=\"0\" ref=\"SettlementAmount\" />\r\n                          <xs:choice>\r\n                            <xs:element ref=\"DebitAmount\" />\r\n                            <xs:element ref=\"CreditAmount\" />\r\n                          </xs:choice>\r\n                          <xs:element minOccurs=\"0\" name=\"Tax\" type=\"PaymentTax\" />\r\n                          <xs:group ref=\"TaxExemptions\" minOccurs=\"0\" />\r\n                        </xs:sequence>\r\n                      </xs:complexType>\r\n                    </xs:element>\r\n                    <xs:element name=\"DocumentTotals\">\r\n                      <xs:complexType>\r\n                        <xs:sequence>\r\n                          <xs:element ref=\"TaxPayable\" />\r\n                          <xs:element ref=\"NetTotal\" />\r\n                          <xs:element ref=\"GrossTotal\" />\r\n                          <!-- O conteudo desta estrutura Settlement representa o somatorio dos descontos reflectidos no elemento SettlementAmount das linhas do recibo. Trata-se de um raciocinio diverso da tabela 4.1 SalesInvoices -->\r\n                          <xs:element minOccurs=\"0\" name=\"Settlement\">\r\n                            <xs:complexType>\r\n                              <xs:sequence>\r\n                                <xs:element ref=\"SettlementAmount\" />\r\n                              </xs:sequence>\r\n                            </xs:complexType>\r\n                          </xs:element>\r\n                          <xs:element minOccurs=\"0\" name=\"Currency\" type=\"Currency\" />\r\n                        </xs:sequence>\r\n                      </xs:complexType>\r\n                    </xs:element>\r\n                    <xs:element minOccurs=\"0\" maxOccurs=\"unbounded\" name=\"WithholdingTax\" type=\"WithholdingTax\" />\r\n                  </xs:sequence>\r\n                </xs:complexType>\r\n              </xs:element>\r\n            </xs:sequence>\r\n          </xs:complexType>\r\n        </xs:element>\r\n        <xs:element minOccurs=\"0\" name=\"PurchaseInvoices\">\r\n          <xs:complexType>\r\n            <xs:annotation>\r\n              <xs:documentation>\r\n                Documentos comerciais de Fornecedores\r\n              </xs:documentation>\r\n            </xs:annotation>\r\n            <xs:sequence>\r\n              <xs:element ref=\"NumberOfEntries\" />\r\n              <xs:element minOccurs=\"0\" maxOccurs=\"unbounded\" name=\"Invoice\">\r\n                <xs:complexType>\r\n                  <xs:sequence>\r\n                    <xs:element ref=\"InvoiceNo\" />\r\n                    <xs:element minOccurs=\"0\" ref=\"Period\" />\r\n                    <xs:element ref=\"InvoiceDate\" />\r\n                    <xs:element ref=\"InvoiceType\" />\r\n                    <xs:element ref=\"SourceID\" />\r\n                    <xs:element ref=\"SupplierID\" />\r\n                    <xs:element name=\"DocumentTotals\">\r\n                      <xs:complexType>\r\n                        <xs:sequence>\r\n                          <xs:element ref=\"InputTax\"/>\r\n                          <xs:element ref=\"TaxPayable\" />\r\n                          <xs:element ref=\"NetTotal\" />\r\n                          <xs:element ref=\"GrossTotal\" />\r\n                          <xs:group ref=\"DeductibleTaxes\" minOccurs=\"0\" />\r\n                          <xs:element minOccurs=\"0\" name=\"Currency\" type=\"Currency\" />\r\n                        </xs:sequence>\r\n                      </xs:complexType>\r\n                    </xs:element>\r\n                  </xs:sequence>\r\n                </xs:complexType>\r\n              </xs:element>\r\n            </xs:sequence>\r\n          </xs:complexType>\r\n        </xs:element>\r\n      </xs:sequence>\r\n    </xs:complexType>\r\n  </xs:element>\r\n  <!-- ESTRUTURAS DE SUPORTE -->\r\n  <!-- Estrutura de Moradas -->\r\n  <xs:complexType name=\"AddressStructure\">\r\n    <xs:sequence>\r\n      <xs:element minOccurs=\"0\" ref=\"BuildingNumber\" />\r\n      <xs:element minOccurs=\"0\" ref=\"StreetName\" />\r\n      <xs:element ref=\"AddressDetail\" />\r\n      <xs:element ref=\"City\" />\r\n      <xs:element ref=\"PostalCode\" minOccurs=\"0\" />\r\n      <xs:element minOccurs=\"0\" ref=\"Province\" />\r\n      <xs:element ref=\"Country\" />\r\n    </xs:sequence>\r\n  </xs:complexType>\r\n  <!-- Estrutura de Moradas para Angola-->\r\n  <xs:complexType name=\"AddressStructureAO\">\r\n    <xs:sequence>\r\n      <xs:element minOccurs=\"0\" ref=\"BuildingNumber\" />\r\n      <xs:element minOccurs=\"0\" ref=\"StreetName\" />\r\n      <xs:element ref=\"AddressDetail\" />\r\n      <xs:element ref=\"City\" />\r\n      <xs:element minOccurs=\"0\" name=\"PostalCode\" type=\"PostalCodeAO\" />\r\n      <xs:element minOccurs=\"0\" ref=\"Province\" />\r\n      <xs:element name=\"Country\" fixed=\"AO\" />\r\n    </xs:sequence>\r\n  </xs:complexType>\r\n  <!-- Estrutura de valor monetario -->\r\n  <!-- Este elemento apenas deve ser gerado quando a moeda original do documento for diferente de euro -->\r\n  <xs:complexType name=\"Currency\">\r\n    <xs:sequence>\r\n      <xs:element ref=\"CurrencyCode\" />\r\n      <xs:element ref=\"CurrencyAmount\" />\r\n      <xs:element minOccurs=\"0\" ref=\"ExchangeRate\" />\r\n    </xs:sequence>\r\n  </xs:complexType>\r\n  <!-- Estrutura de caracterização aduaneira de produtos-->\r\n  <xs:complexType name=\"CustomsDetails\">\r\n    <xs:annotation>\r\n      <xs:documentation>Preencher com o nº ONU para produtos perigosos </xs:documentation>\r\n    </xs:annotation>\r\n    <xs:sequence>\r\n      <xs:element ref=\"UNNumber\" minOccurs=\"0\" maxOccurs=\"unbounded\" />\r\n    </xs:sequence>\r\n  </xs:complexType>\r\n  <!-- Estrutura de informacao aduaneira-->\r\n  <xs:complexType name=\"CustomsInformation\">\r\n    <xs:sequence>\r\n      <xs:element ref=\"ARCNo\" minOccurs=\"0\" maxOccurs=\"unbounded\" />\r\n      <xs:element ref=\"IECAmount\" minOccurs=\"0\" />\r\n    </xs:sequence>\r\n  </xs:complexType>\r\n  <!-- Estrutura de numero de serie do produto-->\r\n  <xs:complexType name=\"ProductSerialNumber\">\r\n    <xs:sequence>\r\n      <xs:element ref=\"SerialNumber\" maxOccurs=\"unbounded\" />\r\n    </xs:sequence>\r\n  </xs:complexType>\r\n  <!-- Estrutura de Taxa de documentos de movimentacao de mercadorias-->\r\n  <xs:complexType name=\"MovementTax\">\r\n    <xs:sequence>\r\n      <xs:element name=\"TaxType\" type=\"SAFTAOMovementTaxType\" />\r\n      <xs:element ref=\"TaxCountryRegion\" minOccurs=\"0\" />\r\n      <xs:element name=\"TaxCode\" type=\"SAFTAOMovementTaxCode\" />\r\n      <xs:element ref=\"TaxPercentage\" />\r\n    </xs:sequence>\r\n  </xs:complexType>\r\n  <!-- Estrutura de Referencias ao documento de origem-->\r\n  <xs:complexType name=\"OrderReferences\">\r\n    <xs:sequence>\r\n      <xs:element minOccurs=\"0\" ref=\"OriginatingON\" />\r\n      <xs:element minOccurs=\"0\" ref=\"OrderDate\" />\r\n    </xs:sequence>\r\n  </xs:complexType>\r\n  <!-- Estrutura de pagamentos-->\r\n  <xs:complexType name=\"PaymentMethod\">\r\n    <xs:sequence>\r\n      <xs:element ref=\"PaymentMechanism\" />\r\n      <xs:element name=\"PaymentAmount\" type=\"SAFmonetaryType\" />\r\n      <xs:element name=\"PaymentDate\" type=\"SAFdateType\" />\r\n    </xs:sequence>\r\n  </xs:complexType>\r\n  <!-- Estrutura de Taxa dos recibos-->\r\n  <xs:complexType name=\"PaymentTax\">\r\n    <xs:sequence>\r\n      <xs:element ref=\"TaxType\" />\r\n      <xs:element ref=\"TaxCountryRegion\" minOccurs=\"0\" />\r\n      <xs:element name=\"TaxCode\" type=\"PaymentTaxCode\" />\r\n      <xs:choice>\r\n        <xs:element ref=\"TaxPercentage\" />\r\n        <xs:element ref=\"TaxAmount\" />\r\n      </xs:choice>\r\n    </xs:sequence>\r\n  </xs:complexType>\r\n  <!-- Estrutura de referencias a outros documentos em documentos retificativos de faturas-->\r\n  <xs:complexType name=\"References\">\r\n    <xs:sequence>\r\n      <xs:element minOccurs=\"0\" ref=\"Reference\" />\r\n      <xs:element minOccurs=\"0\" ref=\"Reason\" />\r\n    </xs:sequence>\r\n  </xs:complexType>\r\n  <!-- Estrutura de Acordos entre cliente e fornecedor-->\r\n  <xs:complexType name=\"Settlement\">\r\n    <xs:sequence>\r\n      <xs:element minOccurs=\"0\" name=\"SettlementDiscount\" type=\"SAFAOtextTypeMandatoryMax30Car\" />\r\n      <xs:element minOccurs=\"0\" name=\"SettlementAmount\" type=\"SAFmonetaryType\" />\r\n      <xs:element minOccurs=\"0\" name=\"SettlementDate\" type=\"SAFdateType\" />\r\n      <xs:element minOccurs=\"0\" name=\"PaymentTerms\" type=\"SAFAOtextTypeMandatoryMax100Car\" />\r\n    </xs:sequence>\r\n  </xs:complexType>\r\n  <!-- Estrutura de entregas de produtos -->\r\n  <xs:complexType name=\"ShippingPointStructure\">\r\n    <xs:sequence>\r\n      <xs:element minOccurs=\"0\" maxOccurs=\"unbounded\" ref=\"DeliveryID\" />\r\n      <xs:element minOccurs=\"0\" ref=\"DeliveryDate\" />\r\n      <xs:sequence minOccurs=\"0\" maxOccurs=\"unbounded\">\r\n        <xs:element minOccurs=\"0\" ref=\"WarehouseID\" />\r\n        <xs:element minOccurs=\"0\" ref=\"LocationID\" />\r\n      </xs:sequence>\r\n      <xs:element minOccurs=\"0\" ref=\"Address\" />\r\n    </xs:sequence>\r\n  </xs:complexType>\r\n  <!-- Estrutura de Regimes especiais de faturacao-->\r\n  <xs:complexType name=\"SpecialRegimes\">\r\n    <xs:sequence>\r\n      <xs:element ref=\"SelfBillingIndicator\" />\r\n      <xs:element ref=\"CashVATSchemeIndicator\" />\r\n      <xs:element ref=\"ThirdPartiesBillingIndicator\" />\r\n    </xs:sequence>\r\n  </xs:complexType>\r\n  <!-- Estrutura de Moradas para Fornecedores-->\r\n  <xs:complexType name=\"SupplierAddressStructure\">\r\n    <xs:sequence>\r\n      <xs:element minOccurs=\"0\" ref=\"BuildingNumber\" />\r\n      <xs:element minOccurs=\"0\" ref=\"StreetName\" />\r\n      <xs:element ref=\"AddressDetail\" />\r\n      <xs:element ref=\"City\" />\r\n      <xs:element ref=\"PostalCode\" minOccurs=\"0\" />\r\n      <xs:element minOccurs=\"0\" ref=\"Province\" />\r\n      <xs:element name=\"Country\" type=\"SupplierCountry\" />\r\n    </xs:sequence>\r\n  </xs:complexType>\r\n  <!-- Estrutura de Taxa -->\r\n  <xs:complexType name=\"Tax\">\r\n    <xs:sequence>\r\n      <xs:element ref=\"TaxType\" />\r\n      <xs:element ref=\"TaxCountryRegion\" minOccurs=\"0\" />\r\n      <xs:element ref=\"TaxCode\" />\r\n      <xs:choice>\r\n        <xs:element ref=\"TaxPercentage\" />\r\n        <xs:element ref=\"TaxAmount\" />\r\n      </xs:choice>\r\n    </xs:sequence>\r\n  </xs:complexType>\r\n  <!-- Estrutura de Retencao na fonte-->\r\n  <xs:complexType name=\"WithholdingTax\">\r\n    <xs:sequence>\r\n      <xs:element minOccurs=\"0\" ref=\"WithholdingTaxType\" />\r\n      <xs:element minOccurs=\"0\" name=\"WithholdingTaxDescription\" type=\"SAFAOtextTypeMandatoryMax60Car\" />\r\n      <xs:element name=\"WithholdingTaxAmount\" type=\"SAFmonetaryType\" />\r\n    </xs:sequence>\r\n  </xs:complexType>\r\n  <!-- ELEMENTOS SIMPLES -->\r\n  <xs:element name=\"AccountDescription\" type=\"SAFAOtextTypeMandatoryMax100Car\" />\r\n  <xs:element name=\"Address\" type=\"AddressStructure\" />\r\n  <xs:element name=\"AddressDetail\" type=\"SAFAOtextTypeMandatoryMax250Car\" />\r\n  <xs:element name=\"ARCNo\" type=\"SAFAOtextTypeMandatoryMax21Car\" />\r\n  <xs:element name=\"AGTDocCodeID\" type=\"SAFAOtextTypeMandatoryMax200Car\" />\r\n  <xs:element name=\"BillingAddress\" type=\"AddressStructure\" />\r\n  <xs:element name=\"BuildingNumber\" type=\"SAFAOtextTypeMandatoryMax15Car\" />\r\n  <xs:element name=\"BusinessName\" type=\"SAFAOtextTypeMandatoryMax60Car\" />\r\n  <xs:element name=\"City\" type=\"SAFAOtextTypeMandatoryMax50Car\" />\r\n  <xs:element name=\"ClosingCreditBalance\" type=\"SAFmonetaryType\" />\r\n  <xs:element name=\"ClosingDebitBalance\" type=\"SAFmonetaryType\" />\r\n  <xs:element name=\"CompanyAddress\" type=\"AddressStructureAO\" />\r\n  <xs:element name=\"CompanyName\" type=\"SAFAOtextTypeMandatoryMax200Car\" />\r\n  <xs:element name=\"Contact\" type=\"SAFAOtextTypeMandatoryMax50Car\" />\r\n  <xs:element name=\"CreditAmount\" type=\"SAFmonetaryType\" />\r\n  <xs:element name=\"CurrencyAmount\" type=\"SAFmonetaryType\" />\r\n  <xs:element name=\"CustomerID\" type=\"SAFAOtextTypeMandatoryMax30Car\" />\r\n  <xs:element name=\"CustomerTaxID\" type=\"SAFAOtextTypeMandatoryMax30Car\" />\r\n  <xs:element name=\"DateCreated\" type=\"SAFAODateSpan\" />\r\n  <xs:element name=\"DebitAmount\" type=\"SAFmonetaryType\" />\r\n  <xs:element name=\"DeductibleTax\" type=\"SAFMonetaryType2DecimalPlaces\"/>\r\n  <xs:element name=\"DeductiblePercentage\" type=\"SAFdecimalType\"/>\r\n  <xs:element name=\"DeliveryDate\" type=\"SAFdateType\" />\r\n  <xs:element name=\"DeliveryID\" type=\"SAFAOtextTypeMandatoryMax255Car\" />\r\n  <xs:element name=\"Description\" type=\"SAFAOtextTypeMandatoryMax200Car\" />\r\n  <xs:element name=\"DocArchivalNumber\" type=\"SAFTAODocArchivalNumber\" />\r\n  <xs:element name=\"Email\" type=\"SAFAOtextTypeMandatoryMax255Car\" />\r\n  <xs:element name=\"EndDate\" type=\"SAFAODateSpan\" />\r\n  <xs:element name=\"ExchangeRate\" type=\"SAFdecimalType\" />\r\n  <xs:element name=\"Fax\" type=\"SAFAOtextTypeMandatoryMax20Car\" />\r\n  <xs:element name=\"GLPostingDate\" type=\"SAFdateType\" />\r\n  <xs:element name=\"GrossTotal\" type=\"SAFMonetaryType2DecimalPlaces\" />\r\n  <xs:element name=\"Hash\" type=\"SAFAOtextTypeMandatoryMax172Car\" />\r\n  <xs:element name=\"HashControl\" type=\"SAFAOtextTypeMandatoryMax70Car\" />\r\n  <xs:element name=\"HeaderComment\" type=\"SAFAOtextTypeMandatoryMax255Car\" />\r\n  <xs:element name=\"IECAmount\" type=\"SAFmonetaryType\" />\r\n  <xs:element name=\"InputTax\" type=\"SAFMonetaryType2DecimalPlaces\"/>\r\n  <xs:element name=\"InvoiceDate\" type=\"SAFdateType\" />\r\n  <xs:element name=\"InvoiceStatusDate\" type=\"SAFdateTimeType\" />\r\n  <xs:element name=\"JournalID\" type=\"SAFAOJournalID\" />\r\n  <xs:element name=\"LineNumber\" type=\"xs:nonNegativeInteger\" />\r\n  <xs:element name=\"LocationID\" type=\"SAFAOtextTypeMandatoryMax30Car\" />\r\n  <xs:element name=\"MovementComments\" type=\"SAFAOtextTypeMandatoryMax60Car\" />\r\n  <xs:element name=\"MovementDate\" type=\"SAFdateType\" />\r\n  <xs:element name=\"MovementEndTime\" type=\"SAFdateTimeType\" />\r\n  <xs:element name=\"MovementStartTime\" type=\"SAFdateTimeType\" />\r\n  <xs:element name=\"MovementStatusDate\" type=\"SAFdateTimeType\" />\r\n  <xs:element name=\"NetTotal\" type=\"SAFMonetaryType2DecimalPlaces\" />\r\n  <xs:element name=\"NumberOfEntries\" type=\"xs:nonNegativeInteger\" />\r\n  <xs:element name=\"NumberOfMovementLines\" type=\"xs:nonNegativeInteger\" />\r\n  <xs:element name=\"OpeningCreditBalance\" type=\"SAFmonetaryType\" />\r\n  <xs:element name=\"OpeningDebitBalance\" type=\"SAFmonetaryType\" />\r\n  <xs:element name=\"OrderDate\" type=\"SAFdateType\" />\r\n  <xs:element name=\"OriginatingON\" type=\"SAFAOtextTypeMandatoryMax60Car\" />\r\n  <xs:element name=\"PaymentStatusDate\" type=\"SAFdateTimeType\" />\r\n  <xs:element name=\"PostalCode\" type=\"SAFAOtextTypeMandatoryMax20Car\" />\r\n  <xs:element name=\"ProductCode\" type=\"SAFAOtextTypeMandatoryMax60Car\" />\r\n  <xs:element name=\"ProductCompanyTaxID\" type=\"SAFAOtextTypeMandatoryMax20Car\" />\r\n  <xs:element name=\"ProductDescription\" type=\"SAFAOtextTypeMandatoryMax200Car\" />\r\n  <xs:element name=\"ProductGroup\" type=\"SAFAOtextTypeMandatoryMax50Car\" />\r\n  <xs:element name=\"ProductID\" type=\"SAFAOProductID\" />\r\n  <xs:element name=\"ProductNumberCode\" type=\"SAFAOtextTypeMandatoryMax60Car\" />\r\n  <xs:element name=\"ProductVersion\" type=\"SAFAOtextTypeMandatoryMax30Car\" />\r\n  <xs:element name=\"Quantity\" type=\"SAFdecimalType\" />\r\n  <xs:element name=\"Reason\" type=\"SAFAOtextTypeMandatoryMax50Car\" />\r\n  <xs:element name=\"RecordID\" type=\"SAFAOtextTypeMandatoryMax30Car\" />\r\n  <xs:element name=\"Reference\" type=\"SAFAOtextTypeMandatoryMax60Car\" />\r\n  <xs:element name=\"Region\" type=\"SAFAOtextTypeMandatoryMax50Car\" />\r\n  <xs:element name=\"Province\" type=\"SAFAOtextTypeMandatoryMax50Car\" />\r\n  <xs:element name=\"SerialNumber\" type=\"SAFAOtextTypeMandatoryMax100Car\" />\r\n  <xs:element name=\"SettlementAmount\" type=\"SAFmonetaryType\">\r\n    <xs:annotation>\r\n      <xs:documentation>\r\n        Para os elementos presentes em:\r\n        (1) /AuditFile/SourceDocuments/SalesInvoices/Invoice/Line/SettlementAmount\r\n        (2) /AuditFile/SourceDocuments/MovementOfGoods/StockMovement/Line/SettlementAmount\r\n        (3) /AuditFile/SourceDocuments/WorkingDocuments/WorkDocument/Line/SettlementAmount\r\n        (4) /AuditFile/SourceDocuments/Payments/Payment/Line/SettlementAmount\r\n        Deve refletir todos os descontos concedidos que afetem o total do documento - GrossTotal (descontos de linha e descontos glogais).\r\n\r\n        Para os elementos presentes em:\r\n        (5) /AuditFile/SourceDocuments/SalesInvoices/Invoice/DocumentTotals/Settlement/SettlementAmount\r\n        (6) /AuditFile/SourceDocuments/Payments/Payment/DocumentTotals/Settlement/SettlementAmount\r\n        Representa o valor acordado para desconto futuro, que afeta o total do documento - GrossTotal\r\n      </xs:documentation>\r\n    </xs:annotation>\r\n  </xs:element>\r\n  <xs:element name=\"ShipFrom\" type=\"ShippingPointStructure\" />\r\n  <xs:element name=\"ShipFromAddress\" type=\"AddressStructure\" />\r\n  <xs:element name=\"ShipTo\" type=\"ShippingPointStructure\" />\r\n  <xs:element name=\"ShipToAddress\" type=\"AddressStructure\" />\r\n  <xs:element name=\"SoftwareValidationNumber\" type=\"ns:SAFAOtextValidationNumber\" />\r\n  <xs:element name=\"SourceDocumentID\" type=\"SAFAOtextTypeMandatoryMax30Car\" />\r\n  <xs:element name=\"SourceID\" type=\"SAFAOtextTypeMandatoryMax30Car\" />\r\n  <xs:element name=\"StartDate\" type=\"SAFAODateSpan\" />\r\n  <xs:element name=\"StreetName\" type=\"SAFAOtextTypeMandatoryMax200Car\" />\r\n  <xs:element name=\"SupplierID\" type=\"SAFAOtextTypeMandatoryMax30Car\" />\r\n  <xs:element name=\"SupplierTaxID\" type=\"SAFAOtextTypeMandatoryMax20Car\" />\r\n  <xs:element name=\"SystemEntryDate\" type=\"SAFdateTimeType\" />\r\n  <xs:element name=\"SystemID\" type=\"SAFAOtextTypeMandatoryMax35Car\" />\r\n  <xs:element name=\"TaxAmount\" type=\"SAFmonetaryType\" />\r\n  <xs:element name=\"TaxBase\" type=\"SAFmonetaryType\" />\r\n  <xs:element name=\"TaxEntity\" type=\"SAFAOtextTypeMandatoryMax20Car\" />\r\n  <xs:element name=\"TaxExemptionReason\" type=\"SAFAOTaxExemption\" />\r\n  <xs:element name=\"TaxExemptionCode\" type=\"SAFAOTaxExemptionCode\" />\r\n  <xs:element name=\"TaxExpirationDate\" type=\"SAFdateType\" />\r\n  <xs:element name=\"TaxPayable\" type=\"SAFMonetaryType2DecimalPlaces\" />\r\n  <xs:element name=\"TaxPercentage\" type=\"SAFdecimalType\" />\r\n  <xs:element name=\"TaxPointDate\" type=\"SAFdateType\" />\r\n  <xs:element name=\"TaxVerificationDate\" type=\"SAFdateType\" />\r\n  <xs:element name=\"Telephone\" type=\"SAFAOtextTypeMandatoryMax20Car\" />\r\n  <xs:element name=\"TotalCredit\" type=\"SAFmonetaryType\" />\r\n  <xs:element name=\"TotalDebit\" type=\"SAFmonetaryType\" />\r\n  <xs:element name=\"TotalQuantityIssued\" type=\"SAFdecimalType\" />\r\n  <xs:element name=\"TransactionDate\" type=\"SAFdateType\" />\r\n  <xs:element name=\"TransactionID\" type=\"SAFAOTransactionID\" />\r\n  <xs:element name=\"UnitOfMeasure\" type=\"SAFAOtextTypeMandatoryMax20Car\" />\r\n  <xs:element name=\"UnitPrice\" type=\"SAFmonetaryType\" />\r\n  <xs:element name=\"UNNumber\" type=\"SAFAOUNNumber\" />\r\n  <xs:element name=\"WarehouseID\" type=\"SAFAOtextTypeMandatoryMax50Car\" />\r\n  <xs:element name=\"Website\" type=\"SAFAOtextTypeMandatoryMax60Car\" />\r\n  <xs:element name=\"WorkDate\" type=\"SAFdateType\" />\r\n  <xs:element name=\"WorkStatusDate\" type=\"SAFdateTimeType\" />\r\n  <!-- ELEMENTOS SIMPLES COM RESTRICOES ADICIONAIS-->\r\n  <!-- Codigo da Conta -->\r\n  <xs:element name=\"AccountID\">\r\n    <xs:simpleType>\r\n      <xs:restriction base=\"xs:string\">\r\n        <xs:pattern value=\"(([0-9a-zA-Z\\\\-/._+*]*)|Desconhecido)\" />\r\n        <xs:minLength value=\"1\" />\r\n        <xs:maxLength value=\"30\" />\r\n      </xs:restriction>\r\n    </xs:simpleType>\r\n  </xs:element>\r\n  <xs:element name=\"AuditFileVersion\">\r\n    <xs:simpleType>\r\n      <xs:restriction base=\"xs:string\">\r\n        <xs:pattern value=\"1.01_01\" />\r\n      </xs:restriction>\r\n    </xs:simpleType>\r\n  </xs:element>\r\n  <!-- Indicador de regime de IVA de Caixa -->\r\n  <xs:element name=\"CashVATSchemeIndicator\">\r\n    <xs:simpleType>\r\n      <xs:restriction base=\"xs:integer\">\r\n        <xs:minInclusive value=\"0\" />\r\n        <xs:maxInclusive value=\"1\" />\r\n      </xs:restriction>\r\n    </xs:simpleType>\r\n  </xs:element>\r\n  <!-- Identificacao da entidade a que respeitam os dados constantes no SAF-T-->\r\n  <xs:element name=\"CompanyID\">\r\n    <xs:annotation>\r\n      <xs:documentation>Registo comercial.</xs:documentation>\r\n    </xs:annotation>\r\n    <xs:simpleType>\r\n      <xs:restriction base=\"xs:string\">\r\n        <xs:minLength value=\"1\" />\r\n        <xs:maxLength value=\"50\" />\r\n      </xs:restriction>\r\n    </xs:simpleType>\r\n  </xs:element>\r\n  <!-- Codigo do pais (ISO 3166 1-alpha-2) -->\r\n  <xs:element name=\"Country\">\r\n    <xs:simpleType>\r\n      <xs:restriction base=\"xs:string\">\r\n        <xs:pattern value=\"AD|AE|AF|AG|AI|AL|AM|AO|AQ|AR|AS|AT|AU|AW|AX|AZ|BA|BB|BD|BE|BF|BG|BH|BI|BJ|BL|BM|BN|BO|BQ|BR|BS|BT|BV|BW|BY|BZ|CA|CC|CD|CF|CG|CH|CI|CK|CL|CM|CN|CO|CR|CU|CV|CW|CX|CY|CZ|DE|DJ|DK|DM|DO|DZ|EC|EE|EG|EH|ER|ES|ET|FI|FJ|FK|FM|FO|FR|GA|GB|GD|GE|GF|GG|GH|GI|GL|GM|GN|GP|GQ|GR|GS|GT|GU|GW|GY|HK|HM|HN|HR|HT|HU|ID|IE|IL|IM|IN|IO|IQ|IR|IS|IT|JE|JM|JO|JP|KE|KG|KH|KI|KM|KN|KP|KR|KW|KY|KZ|LA|LB|LC|LI|LK|LR|LS|LT|LU|LV|LY|MA|MC|MD|ME|MF|MG|MH|MK|ML|MM|MN|MO|MP|MQ|MR|MS|MT|MU|MV|MW|MX|MY|MZ|NA|NC|NE|NF|NG|NI|NL|NO|NP|NR|NU|NZ|OM|PA|PE|PF|PG|PH|PK|PL|PM|PN|PR|PS|PT|PW|PY|QA|RE|RO|RS|RU|RW|SA|SB|SC|SD|SE|SG|SH|SI|SJ|SK|SL|SM|SN|SO|SR|SS|ST|SV|SX|SY|SZ|TC|TD|TF|TG|TH|TJ|TK|TL|TM|TN|TO|TR|TT|TV|TW|TZ|UA|UG|UM|US|UY|UZ|VA|VC|VE|VG|VI|VN|VU|WF|WS|XK|YE|YT|ZA|ZM|ZW|Desconhecido\" />\r\n        <xs:minLength value=\"2\" />\r\n      </xs:restriction>\r\n    </xs:simpleType>\r\n  </xs:element>\r\n  <!-- Codigo da moeda (ISO 4217) -->\r\n  <xs:element name=\"CurrencyCode\">\r\n    <!-- Nao consta o AOA por nao existirem situacoes que requeiram este codigo de moeda -->\r\n    <xs:simpleType>\r\n      <xs:restriction base=\"xs:string\">\r\n        <xs:pattern value=\"AED|AFN|ALL|AMD|ANG|ARS|AUD|AWG|AZN|BAM|BBD|BDT|BGN|BHD|BIF|BMD|BND|BOB|BOV|BRL|BSD|BTN|BWP|BYR|BZD|CAD|CDF|CHE|CHF|CHW|CLF|CLP|CNY|COP|COU|CRC|CUC|CUP|CVE|CZK|DJF|DKK|DOP|DZD|EGP|ERN|ETB|EUR|FJD|FKP|GBP|GEL|GHS|GIP|GMD|GNF|GTQ|GYD|HKD|HNL|HRK|HTG|HUF|IDR|ILS|INR|IQD|IRR|ISK|JMD|JOD|JPY|KES|KGS|KHR|KMF|KPW|KRW|KWD|KYD|KZT|LAK|LBP|LKR|LRD|LSL|LTL|LVL|LYD|MAD|MDL|MGA|MKD|MMK|MNT|MOP|MRO|MUR|MVR|MWK|MXN|MXV|MYR|MZN|NAD|NGN|NIO|NOK|NPR|NZD|OMR|PAB|PEN|PGK|PHP|PKR|PLN|PYG|QAR|RON|RSD|RUB|RWF|SAR|SBD|SCR|SDG|SEK|SGD|SHP|SLL|SOS|SRD|SSP|STD|SVC|SYP|SZL|THB|TJS|TMT|TND|TOP|TRY|TTD|TWD|TZS|UAH|UGX|USD|USN|USS|UYI|UYU|UZS|VEF|VND|VUV|WST|XAF|XAG|XAU|XBA|XBB|XBC|XBD|XCD|XDR|XFU|XOF|XPD|XPF|XPT|XSU|XUA|YER|ZAR|ZMW|ZWL|EEK|SKK|TMM|ZMK|ZWD|ZWR\" />\r\n        <xs:length value=\"3\" />\r\n      </xs:restriction>\r\n    </xs:simpleType>\r\n  </xs:element>\r\n  <!-- Identificacao unica do documento de movimentacao de mercadorias e de conferencia-->\r\n  <xs:element name=\"DocumentNumber\">\r\n    <xs:simpleType>\r\n      <xs:restriction base=\"xs:string\">\r\n        <xs:pattern value=\"[^ ]+ [^/^ ]+/[0-9]+\" />\r\n        <xs:minLength value=\"1\" />\r\n        <xs:maxLength value=\"60\" />\r\n      </xs:restriction>\r\n    </xs:simpleType>\r\n  </xs:element>\r\n  <!-- Codigo CAE -->\r\n  <xs:element name=\"EACCode\">\r\n    <xs:simpleType>\r\n      <xs:restriction base=\"xs:string\">\r\n        <xs:pattern value=\"(([0-9]*))\" />\r\n        <xs:length value=\"5\" />\r\n      </xs:restriction>\r\n    </xs:simpleType>\r\n  </xs:element>\r\n  <!-- Ano Fiscal -->\r\n  <xs:element name=\"FiscalYear\">\r\n    <xs:simpleType>\r\n      <xs:restriction base=\"xs:integer\">\r\n        <xs:minInclusive value=\"2000\" />\r\n        <xs:maxInclusive value=\"9999\" />\r\n      </xs:restriction>\r\n    </xs:simpleType>\r\n  </xs:element>\r\n  <!-- Categoria da conta -->\r\n  <xs:element name=\"GroupingCategory\">\r\n    <xs:annotation>\r\n      <xs:documentation>\r\n          Deve ser indicado o tipo e a categoria da conta: \r\n          “GR” – Conta de 1.º grau da contabilidade geral;\r\n          “GA” – Conta agregadora ou integradora da contabilidade geral;\r\n          “GM” – Conta de movimento da contabilidade geral;\r\n          “AR” – Conta de 1.º grau da contabilidade analítica;\r\n          “AA” – Conta agregadora ou integradora da contabilidade analítica; e\r\n          “AM” – Conta de movimento da contabilidade analítica. \r\n      </xs:documentation>\r\n    </xs:annotation>\r\n    <xs:simpleType>\r\n      <xs:restriction base=\"xs:string\">\r\n        <xs:enumeration value=\"GR\"/>\r\n        <xs:enumeration value=\"GA\" />\r\n        <xs:enumeration value=\"GM\" />\r\n        <xs:enumeration value=\"AR\" />\r\n        <xs:enumeration value=\"AA\" />\r\n        <xs:enumeration value=\"AM\" />\r\n      </xs:restriction>\r\n    </xs:simpleType>\r\n  </xs:element>\r\n  <!-- Codigo unico do documento de venda -->\r\n  <xs:element name=\"InvoiceNo\">\r\n    <xs:annotation>\r\n      <xs:documentation>\r\n\r\n        Recomenda-se a utlização do seguinte formato:\r\n\r\n        InvoiceType + ESPAÇO + / + Número Sequencial\r\n        \r\n        Exemplos: \r\n        InvoiceType: FT\r\n        InvoiceNo: FT S001/1\r\n\r\n        InvoiceType: NC\r\n        InvoiceNo: NC S001/1\r\n\r\n      </xs:documentation>\r\n    </xs:annotation>\r\n    <xs:simpleType>\r\n      <xs:restriction base=\"xs:string\">\r\n        <xs:pattern value=\"[^ ]+ [^/^ ]+/[0-9]+\" />\r\n        <xs:minLength value=\"1\" />\r\n        <xs:maxLength value=\"60\" />\r\n      </xs:restriction>\r\n    </xs:simpleType>\r\n  </xs:element>\r\n  <!-- Estado do documento SalesInvoices -->\r\n  <xs:element name=\"InvoiceStatus\">\r\n    <xs:annotation>\r\n      <xs:documentation>\r\n          Deve ser preenchido com:\r\n          “N” – Normal;\r\n          “S” – Autofacturação;\r\n          “A” – Documento anulado;\r\n          “R” – Documento de resumo doutros documentos criados noutras aplicações e gerado nesta aplicação;\r\n      </xs:documentation>\r\n    </xs:annotation>\r\n    <xs:simpleType>\r\n      <xs:restriction base=\"xs:string\">\r\n        <xs:enumeration value=\"N\" />\r\n        <xs:enumeration value=\"S\" />\r\n        <xs:enumeration value=\"A\" />\r\n        <xs:enumeration value=\"R\" />\r\n      </xs:restriction>\r\n    </xs:simpleType>\r\n  </xs:element>\r\n  <!-- Tipo de documento de venda-->\r\n  <xs:element name=\"InvoiceType\">\r\n    <xs:annotation>\r\n      <xs:documentation>\r\n        Deve ser preenchido com: \r\n          “FT” – Factura; \r\n          “FR” – Factura/recibo; \r\n          “VD” – Venda a dinheiro; \r\n          “GF” – Factura genérica; \r\n          “FG” -Factura global \r\n          “AC” – Aviso de cobrança \r\n          “AR” – Aviso de cobrança/recibo \r\n          “RE” – Recibo \r\n          “ND” – Nota de débito \r\n          “NC” – Nota de crédito \r\n          “GR” – Guia de remessa \r\n          “AF” – Factura/recibo (autofacturação) \r\n          “TV” – Talão de venda; (a) \r\n          “TS” – Talão de serviços prestados; \r\n          \r\n          (a) “TD” – Talão de devolução; \r\n          (a) “AA” – Alienação de activos; \r\n          (a) “DA” – Devolução de activos. \r\n          (a) Para o sector Segurador quando não deva constar da tabela 4.3. - \r\n        Documentos de conferência de mercadorias ou de prestação de serviços (WorkingDocuments), \r\n        pode ainda ser preenchido com: \r\n          “RP” – Prémio ou recibo de prémio; \r\n          “RE” – Estorno ou recibo de estorno; \r\n          “CS” – Imputação a co-seguradoras; \r\n          “LD” – Imputação a co-seguradora líder; \r\n          “RA” – Resseguro aceite.\r\n      </xs:documentation>\r\n    </xs:annotation>\r\n    <xs:simpleType>\r\n      <xs:restriction base=\"xs:string\">\r\n        <xs:enumeration value=\"FT\" />\r\n        <xs:enumeration value=\"FR\" />\r\n        <xs:enumeration value=\"VD\" />\r\n        <xs:enumeration value=\"GF\" />\r\n        <xs:enumeration value=\"FG\" />\r\n        <xs:enumeration value=\"AC\" />\r\n        <xs:enumeration value=\"AR\" />\r\n        <xs:enumeration value=\"ND\" />\r\n        <xs:enumeration value=\"NC\" />\r\n        <xs:enumeration value=\"GR\" />\r\n        <xs:enumeration value=\"AF\" />\r\n        <xs:enumeration value=\"TV\" />\r\n        <xs:enumeration value=\"TS\" />\r\n        <xs:enumeration value=\"TD\" />\r\n        <xs:enumeration value=\"AA\" />\r\n        <xs:enumeration value=\"DA\" />\r\n        <!-- Para o sector segurador-->\r\n        <xs:enumeration value=\"RP\" />\r\n        <xs:enumeration value=\"RE\" />\r\n        <xs:enumeration value=\"CS\" />\r\n        <xs:enumeration value=\"LD\" />\r\n        <xs:enumeration value=\"RA\" />\r\n      </xs:restriction>\r\n    </xs:simpleType>\r\n  </xs:element>\r\n  <!-- Estado do documento MovementOfGoods -->\r\n  <xs:element name=\"MovementStatus\">\r\n    <xs:annotation>\r\n      <xs:documentation>\r\n          Deve ser preenchido com: “N” – Normal;\r\n          “T” – Por conta de terceiros;\r\n          “A” – Documento anulado;\r\n          “F” – Documento facturado, ainda que parcialmente, quando\r\n          para este documento também existe na tabela 4.1. – Documentos comerciais a clientes (SalesInvoices) o correspondente do tipo factura.\r\n          “R” – Documento de resumo doutros documentos criados noutras aplicações e gerado nesta aplicação. \r\n      </xs:documentation>\r\n    </xs:annotation>\r\n    <xs:simpleType>\r\n      <xs:restriction base=\"xs:string\">\r\n        <xs:enumeration value=\"N\" />\r\n        <xs:enumeration value=\"T\" />\r\n        <xs:enumeration value=\"A\" />\r\n        <xs:enumeration value=\"F\" />\r\n        <xs:enumeration value=\"R\" />\r\n      </xs:restriction>\r\n    </xs:simpleType>\r\n  </xs:element>\r\n  <!-- Tipo de documento de movimentacao de mercadorias-->\r\n  <xs:element name=\"MovementType\">\r\n    <xs:annotation>\r\n      <xs:documentation>\r\n          Deve ser preenchido com:\r\n          “GR” – Guia de remessa;\r\n          “GT” – Guia de transporte (incluir aqui as guias globais);\r\n          “GA” – Guia de movimentação de activos fixos próprios; \r\n          “GC” – Guia de consignação;\r\n          “GD” – Guia ou nota de devolução. \r\n      </xs:documentation>\r\n    </xs:annotation>\r\n    <xs:simpleType>\r\n      <xs:restriction base=\"xs:string\">\r\n        <xs:enumeration value=\"GR\" />\r\n        <xs:enumeration value=\"GT\" />\r\n        <xs:enumeration value=\"GA\" />\r\n        <xs:enumeration value=\"GD\" />\r\n        <xs:enumeration value=\"GC\" />\r\n      </xs:restriction>\r\n    </xs:simpleType>\r\n  </xs:element>\r\n  <!-- Meio de pagamento-->\r\n  <xs:element name=\"PaymentMechanism\">\r\n    <xs:annotation>\r\n      <xs:documentation>\r\n          Deve ser preenchido com:\r\n          “CC” – Cartão crédito;\r\n          “CD” – Cartão débito;\r\n          “CH” – Cheque bancário;\r\n          “CI” – Crédito documentário internacional;\r\n          “CO” – Cheque ou cartão oferta;\r\n          “CS” – Compensação de saldos em conta corrente;\r\n          “DE” – Dinheiro electrónico, por exemplo residente em cartões de fidelidade ou de pontos;\r\n          “MB” – Referências de pagamento para Multicaixa; \r\n          “NU” – Numerário;\r\n\r\n\r\n          “OU” – Outros meios aqui não assinalados;\r\n          “PR” – Permuta de bens;\r\n          “TB“ – Transferência bancária ou débito directo autorizado; etc. \r\n      </xs:documentation>\r\n    </xs:annotation>\r\n    <xs:simpleType>\r\n      <xs:restriction base=\"xs:string\">\r\n        <xs:enumeration value=\"CC\" />\r\n        <xs:enumeration value=\"CD\" />\r\n        <xs:enumeration value=\"CH\" />\r\n        <xs:enumeration value=\"CI\" />\r\n        <xs:enumeration value=\"CO\" />\r\n        <xs:enumeration value=\"CS\" />\r\n        <xs:enumeration value=\"DE\" />\r\n        <xs:enumeration value=\"MB\" />\r\n        <xs:enumeration value=\"NU\" />\r\n        <xs:enumeration value=\"OU\" />\r\n        <xs:enumeration value=\"PR\" />\r\n        <xs:enumeration value=\"TB\" />\r\n      </xs:restriction>\r\n    </xs:simpleType>\r\n  </xs:element>\r\n  <!-- Codigo unico do documento de venda -->\r\n  <xs:element name=\"PaymentRefNo\">\r\n    <xs:simpleType>\r\n      <xs:restriction base=\"xs:string\">\r\n        <xs:pattern value=\"[^ ]+ [^/^ ]+/[0-9]+\" />\r\n        <xs:minLength value=\"1\" />\r\n        <xs:maxLength value=\"60\" />\r\n      </xs:restriction>\r\n    </xs:simpleType>\r\n  </xs:element>\r\n  <!-- Estado do documento Payments -->\r\n  <xs:element name=\"PaymentStatus\">\r\n    <xs:annotation>\r\n      <xs:documentation>N para normal, A para Anulado </xs:documentation>\r\n    </xs:annotation>\r\n    <xs:simpleType>\r\n      <xs:restriction base=\"xs:string\">\r\n        <xs:enumeration value=\"N\" />\r\n        <xs:enumeration value=\"A\" />\r\n      </xs:restriction>\r\n    </xs:simpleType>\r\n  </xs:element>\r\n  <!-- Codigo de de Imposto de pagamento-->\r\n  <xs:simpleType name=\"PaymentTaxCode\">\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:pattern value=\"NOR|ISE|OUT|([0-9.])*|NA|NS\" />\r\n      <xs:minLength value=\"1\" />\r\n      <xs:maxLength value=\"10\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <!-- Periodo contabilistico do documento -->\r\n  <xs:element name=\"Period\">\r\n    <xs:simpleType>\r\n      <xs:restriction base=\"xs:integer\">\r\n        <xs:minInclusive value=\"1\" />\r\n        <xs:maxInclusive value=\"12\" />\r\n      </xs:restriction>\r\n    </xs:simpleType>\r\n  </xs:element>\r\n  <!-- Tipos de produto -->\r\n  <xs:element name=\"ProductType\">\r\n    <xs:annotation>\r\n      <xs:documentation>\r\n          Deve ser preenchido com:\r\n          “P” – Produtos;\r\n          “S” – Serviços;\r\n          “O” – Outros (Ex: portes debitados, adiantamentos recebidos ou alienação de activos);\r\n          “E” – Impostos Especiais de Consumo – (ex.:IEC);\r\n          “I” – Impostos, taxas e encargos parafiscais – excepto IVA e IS que deverão ser reflectidos na tabela 2.5\r\n          – Tabela de impostos (Tax Table) e Impostos Especiais de Consumo, que deverão ser preenchidos com o código “E”.\r\n      </xs:documentation>\r\n    </xs:annotation>\r\n    <xs:simpleType>\r\n      <xs:restriction base=\"xs:string\">\r\n        <xs:enumeration value=\"P\" />\r\n        <xs:enumeration value=\"S\" />\r\n        <xs:enumeration value=\"O\" />\r\n        <xs:enumeration value=\"E\" />\r\n        <xs:enumeration value=\"I\" />\r\n      </xs:restriction>\r\n    </xs:simpleType>\r\n  </xs:element>\r\n  <!-- Indicador de Autofaturacao -->\r\n  <xs:element name=\"SelfBillingIndicator\">\r\n    <xs:annotation>\r\n      <xs:documentation>\r\n        PROPOSTA:\r\n        Deve ser preenchido: \r\n        com “1” se respeitar a autofacturação,\r\n        Com “2” se é obrigado a cativar o IVA,\r\n        Com ”3” se tiver IVA cativo e autofacturação,\r\n        com “0” (zero) no caso de não cumprir com nenhuma condição .\r\n      </xs:documentation>\r\n    </xs:annotation>\r\n    <xs:simpleType>\r\n      <xs:restriction base=\"xs:integer\">\r\n        <xs:minInclusive value=\"0\" />\r\n        <xs:maxInclusive value=\"3\" />\r\n      </xs:restriction>\r\n    </xs:simpleType>\r\n  </xs:element>\r\n  <!-- Tipo de sistema que exportou o SAFT -->\r\n  <xs:element name=\"TaxAccountingBasis\">\r\n    <xs:annotation>\r\n      <xs:documentation>\r\n          Deve ser preenchido com o tipo de programa fornecendo os dados aplicáveis\r\n          (incluindo os documentos de conferência e os recibos emitidos, quando existam):\r\n            \"A\" -Aquisição de bens e serviços;\r\n            “I” -Contabilidade integrada com a facturação;\r\n            “C” -Contabilidade;\r\n            “F” -Facturação;\r\n            “P” -Facturação parcial;\r\n            \"Q  -Aquisição de bens e serviços integrada com a facturação;\r\n            “R” -Recibos;\r\n            “S” -Autofacturação.\r\n            (a) Deve ser indicado este tipo de programa se este emitir só este tipo de documento. \r\n            Caso contrário, deverá ser utilizado o tipo “C”, “F” \r\n      </xs:documentation>\r\n    </xs:annotation>\r\n    <xs:simpleType>\r\n      <xs:restriction base=\"xs:string\">\r\n        <xs:enumeration value=\"A\" />\r\n        <xs:enumeration value=\"C\" />\r\n        <xs:enumeration value=\"F\" />\r\n        <xs:enumeration value=\"I\" />\r\n        <xs:enumeration value=\"P\" />\r\n        <xs:enumeration value=\"Q\" />\r\n        <xs:enumeration value=\"R\" />\r\n        <xs:enumeration value=\"S\" />\r\n      </xs:restriction>\r\n    </xs:simpleType>\r\n  </xs:element>\r\n  <!-- Codigo de de Imposto -->\r\n  <xs:element name=\"TaxCode\">\r\n    <xs:annotation>\r\n      <xs:documentation>\r\n            Código da taxa na tabela de impostos.\r\n            No caso do campo 4.4.4.14.6.1. - Código do tipo de imposto (TaxType) = IVA, deve ser preenchido com:\r\n            “NOR” – Taxa normal; \r\n            “ISE” – Isenta;\r\n            “OUT” – Outros, aplicável para os regimes especiais de IVA.\r\n            No caso do campo 4.4.4.14.6.1.\r\n            Código do tipo de imposto (TaxType) = IS, deve ser preenchido com:\r\n            O código da verba respectiva; “ISE” – Isenta.\r\n            No caso de não aplicabilidade de imposto deve ser preenchido com “NA”.\r\n      </xs:documentation>\r\n    </xs:annotation>\r\n    <xs:simpleType>\r\n      <xs:restriction base=\"xs:string\">\r\n        <xs:pattern value=\"NOR|ISE|OUT|([0-9.])*|NS|NA\" />\r\n        <xs:minLength value=\"1\" />\r\n        <xs:maxLength value=\"10\" />\r\n      </xs:restriction>\r\n    </xs:simpleType>\r\n  </xs:element>\r\n  <!-- Pais ou regiao de Imposto -->\r\n  <xs:element name=\"TaxCountryRegion\">\r\n    <xs:simpleType>\r\n      <xs:restriction base=\"xs:string\">\r\n        <xs:pattern value=\"AD|AE|AF|AG|AI|AL|AM|AO|AQ|AR|AS|AT|AU|AW|AX|AZ|BA|BB|BD|BE|BF|BG|BH|BI|BJ|BL|BM|BN|BO|BQ|BR|BS|BT|BV|BW|BY|BZ|CA|CC|CD|CF|CG|CH|CI|CK|CL|CM|CN|CO|CR|CU|CV|CW|CX|CY|CZ|DE|DJ|DK|DM|DO|DZ|EC|EE|EG|EH|ER|ES|ET|FI|FJ|FK|FM|FO|FR|GA|GB|GD|GE|GF|GG|GH|GI|GL|GM|GN|GP|GQ|GR|GS|GT|GU|GW|GY|HK|HM|HN|HR|HT|HU|ID|IE|IL|IM|IN|IO|IQ|IR|IS|IT|JE|JM|JO|JP|KE|KG|KH|KI|KM|KN|KP|KR|KW|KY|KZ|LA|LB|LC|LI|LK|LR|LS|LT|LU|LV|LY|MA|MC|MD|ME|MF|MG|MH|MK|ML|MM|MN|MO|MP|MQ|MR|MS|MT|MU|MV|MW|MX|MY|MZ|NA|NC|NE|NF|NG|NI|NL|NO|NP|NR|NU|NZ|OM|PA|PE|PF|PG|PH|PK|PL|PM|PN|PR|PS|PT|PW|PY|QA|RE|RO|RS|RU|RW|SA|SB|SC|SD|SE|SG|SH|SI|SJ|SK|SL|SM|SN|SO|SR|SS|ST|SV|SX|SY|SZ|TC|TD|TF|TG|TH|TJ|TK|TL|TM|TN|TO|TR|TT|TV|TW|TZ|UA|UG|UM|US|UY|UZ|VA|VC|VE|VG|VI|VN|VU|WF|WS|XK|YE|YT|ZA|ZM|ZW|PT-AC|PT-MA\" />\r\n        <xs:minLength value=\"2\" />\r\n        <xs:maxLength value=\"5\" />\r\n      </xs:restriction>\r\n    </xs:simpleType>\r\n  </xs:element>\r\n  <!-- Tipo de Imposto da tabela de impostos-->\r\n  <xs:simpleType name=\"TaxTableEntryTaxCode\">\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:pattern value=\"NOR|ISE|OUT|([0-9.])*|NS|NA\" />\r\n      <xs:minLength value=\"1\" />\r\n      <xs:maxLength value=\"10\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <!-- Tipo de Imposto -->\r\n  <xs:element name=\"TaxType\">\r\n    <xs:simpleType>\r\n      <xs:restriction base=\"xs:string\">\r\n        <xs:enumeration value=\"IVA\" />\r\n        <xs:enumeration value=\"IS\" />\r\n        <xs:enumeration value=\"NS\" />\r\n      </xs:restriction>\r\n    </xs:simpleType>\r\n  </xs:element>\r\n  <!-- Indicador de faturacao emitida em nome e por conta de terceiros -->\r\n  <xs:element name=\"ThirdPartiesBillingIndicator\">\r\n    <xs:simpleType>\r\n      <xs:restriction base=\"xs:integer\">\r\n        <xs:minInclusive value=\"0\" />\r\n        <xs:maxInclusive value=\"3\" />\r\n      </xs:restriction>\r\n    </xs:simpleType>\r\n  </xs:element>\r\n  <!-- Tipos de Movimento Contabilistico -->\r\n  <xs:element name=\"TransactionType\">\r\n    <xs:annotation>\r\n      <xs:documentation>\r\n          Deve ser preenchido com:\r\n          “N” – Normal;\r\n          “R” – Regularizações do período de tributação; \r\n          “A” – Apuramento de resultados;\r\n          “J” – Movimentos de ajustamento.  \r\n      </xs:documentation>\r\n    </xs:annotation>\r\n    <xs:simpleType>\r\n      <xs:restriction base=\"xs:string\">\r\n        <xs:enumeration value=\"N\" />\r\n        <xs:enumeration value=\"R\" />\r\n        <xs:enumeration value=\"A\" />\r\n        <xs:enumeration value=\"J\" />\r\n      </xs:restriction>\r\n    </xs:simpleType>\r\n  </xs:element>\r\n  <!-- Codigo do tipo de imposto retido -->\r\n  <xs:element name=\"WithholdingTaxType\">\r\n    <xs:annotation>\r\n      <xs:documentation>\r\n          Neste campo deve ser indicado o tipo de imposto retido, preenchendo-o com:\r\n          “IRT” – Imposto sobre o rendimento de trabalho; “II” – Imposto sobre o industrial; “IS” – Imposto do selo. \r\n      </xs:documentation>\r\n    </xs:annotation>\r\n    <xs:simpleType>\r\n      <xs:restriction base=\"xs:string\">\r\n        <xs:enumeration value=\"IRT\" />\r\n        <xs:enumeration value=\"II\" />\r\n        <xs:enumeration value=\"IS\" />\r\n      </xs:restriction>\r\n    </xs:simpleType>\r\n  </xs:element>\r\n  <!-- Estado do documento WorkingDocuments -->\r\n  <xs:element name=\"WorkStatus\">\r\n    <xs:annotation>\r\n      <xs:documentation>\r\n          Deve ser preenchido com:\r\n          “N” – Normal;\r\n          “A” – Documento anulado;\r\n          “F” – Documento facturado, ainda que parcialmente, quando para este documento também existe na tabela\r\n          4.1.  –  Documentos Comerciais a clientes (SalesInvoices) o correspondente do tipo factura.\r\n      </xs:documentation>\r\n    </xs:annotation>\r\n    <xs:simpleType>\r\n      <xs:restriction base=\"xs:string\">\r\n        <xs:enumeration value=\"N\" />\r\n        <xs:enumeration value=\"A\" />\r\n        <xs:enumeration value=\"F\" />\r\n      </xs:restriction>\r\n    </xs:simpleType>\r\n  </xs:element>\r\n  <!-- Tipo de documento suscetivel de apresentacao ao cliente para conferencia de entrega de mercadorias ou da prestacao de servicos e Fatura de consignacao nos termos do art. 38. do codigo do IVA -->\r\n  <xs:element name=\"WorkType\">\r\n    <xs:annotation>\r\n      <xs:documentation>\r\n          Deve ser preenchido com:\r\n          “CM” – Consultas de mesa;\r\n          “CC” – Credito de consignação;\r\n          “GR” – Guia de remessa;\r\n          “NR” – Nota de remessa;\r\n          “FO” – Folhas de obra;\r\n          “NE” – Nota de Encomenda;\r\n          “OU” – Outros;\r\n          “OR” – Orçamentos;\r\n          “PF” – Pró-forma;\r\n          “DC” – Documentos emitidos que sejam susceptíveis de apresentação ao cliente para conferência de mercadorias ou de prestação de serviços. Para o sector Segurador quando para os tipos de documentos a seguir identificados também deva existir na tabela 4.1 - Documentos comerciais a clientes (SalesInvoices) a correspondente factura ou documento rectificativo de factura, ainda pode ser preenchido com:\r\n          “RP” – Prémio ou recibo de prémio;\r\n          “RE” – Estorno ou recibo de estorno;\r\n          “CS” – Imputação a co-seguradoras; “LD” – Imputação a co-seguradora líder; “RA” – Resseguro aceite.\r\n      </xs:documentation>\r\n    </xs:annotation>\r\n    <xs:simpleType>\r\n      <xs:restriction base=\"xs:string\">\r\n        <xs:enumeration value=\"CM\" />\r\n        <xs:enumeration value=\"CC\" />\r\n        <xs:enumeration value=\"GR\" />\r\n        <xs:enumeration value=\"NR\" />\r\n        <xs:enumeration value=\"FO\" />\r\n        <xs:enumeration value=\"NE\" />\r\n        <xs:enumeration value=\"OU\" />\r\n        <xs:enumeration value=\"OR\" />\r\n        <xs:enumeration value=\"PF\" />\r\n        <xs:enumeration value=\"DC\" />\r\n        <xs:enumeration value=\"RP\" />\r\n        <xs:enumeration value=\"RE\" />\r\n        <xs:enumeration value=\"CS\" />\r\n        <xs:enumeration value=\"LD\" />\r\n        <xs:enumeration value=\"RA\" />\r\n        <xs:enumeration value=\"PP\" />\r\n      </xs:restriction>\r\n    </xs:simpleType>\r\n  </xs:element>\r\n  <!-- TIPOS DE DADOS BASE SAFT OCDE-->\r\n  <xs:simpleType name=\"SAFdateTimeType\">\r\n    <xs:restriction base=\"xs:dateTime\" />\r\n  </xs:simpleType>\r\n  <xs:simpleType name=\"SAFdateType\">\r\n    <xs:restriction base=\"xs:date\" />\r\n  </xs:simpleType>\r\n  <xs:simpleType name=\"SAFdecimalType\">\r\n    <xs:restriction base=\"xs:decimal\">\r\n      <xs:minInclusive value=\"0.00\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <xs:simpleType name=\"SAFmonetaryType\">\r\n    <xs:restriction base=\"xs:decimal\">\r\n      <xs:minInclusive value=\"0.00\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <!-- TIPOS DE DADOS BASE SAFT Angola -->\r\n  <!-- Codigo Postal de Portugal -->\r\n  <xs:simpleType name=\"PostalCodePT\">\r\n    <xs:restriction base=\"xs:string\">\r\n      <!--  \r\n    <xs:pattern value=\"([0-9]{4}-[0-9]{3})\" /> -->\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <!-- Codigo Postal de Angola -->\r\n  <xs:simpleType name=\"PostalCodeAO\">\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:minLength value=\"0\" />\r\n      <xs:maxLength value=\"10\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <!-- Campos Monetários com Duas Casas Decimais -->\r\n  <xs:simpleType name=\"SAFMonetaryType2DecimalPlaces\">\r\n    <xs:restriction base=\"xs:decimal\">\r\n      <xs:pattern value=\"\\\\d+(\\\\.\\\\d{2})\" />\r\n      <xs:minInclusive value=\"0.00\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <!-- Periodo do movimento contabilistico -->\r\n  <xs:simpleType name=\"SAFAOAccountingPeriod\">\r\n    <xs:restriction base=\"xs:integer\">\r\n      <xs:minInclusive value=\"1\" />\r\n      <xs:maxInclusive value=\"16\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <xs:simpleType name=\"SAFAODateSpan\">\r\n    <xs:restriction base=\"xs:date\">\r\n      <xs:minInclusive value=\"2000-01-01\" />\r\n      <xs:maxInclusive value=\"9999-12-31\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <xs:simpleType name=\"SAFTAODocArchivalNumber\">\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:pattern value=\"[^ ]{1,20}\" />\r\n      <xs:minLength value=\"1\" />\r\n      <xs:maxLength value=\"20\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <xs:simpleType name=\"SAFAOGLAccountID\">\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:pattern value=\"(([0-9a-zA-Z\\\\-/._+*]*))\" />\r\n      <xs:minLength value=\"1\" />\r\n      <xs:maxLength value=\"30\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <xs:simpleType name=\"SAFAOJournalID\">\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:pattern value=\"[^ ]{1,30}\" />\r\n      <xs:minLength value=\"1\" />\r\n      <xs:maxLength value=\"30\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <xs:simpleType name=\"SAFTAOMovementTaxCode\">\r\n    <xs:annotation>\r\n      <xs:documentation>\r\n          Código da taxa na tabela de impostos.\r\n          No caso do campo 4.4.4.14.6.1. - Código do tipo de imposto (TaxType) = IVA, deve ser preenchido com:\r\n\r\n          “NOR” – Taxa normal; “ISE” – Isenta;\r\n          “OUT” – Outros, aplicável para os regimes especiais de IVA.\r\n          No caso do campo 4.4.4.14.6.1.\r\n          Código do tipo de imposto (TaxType) = IS, deve ser preenchido com:\r\n          O código da verba respectiva; “ISE” – Isenta.\r\n\r\n          No caso de não aplicabilidade de imposto deve ser preenchido com “NA”.\r\n      </xs:documentation>\r\n    </xs:annotation>\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:pattern value=\"NOR|ISE|OUT|NS|NA\" />\r\n      <xs:minLength value=\"1\" />\r\n      <xs:maxLength value=\"3\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <!-- Tipo de Imposto da Tabela MovementOfGoods-->\r\n  <xs:simpleType name=\"SAFTAOMovementTaxType\">\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:enumeration value=\"IVA\" />\r\n      <xs:enumeration value=\"NS\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <!-- Codigo do motivo de isencao de imposto -->\r\n  <xs:simpleType name=\"SAFAOTaxExemptionCode\">\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:pattern value=\"(M[0-9]{2})+\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <!-- Aplicação dos motivos de isenção de imposto -->\r\n  <xs:group name=\"TaxExemptions\">\r\n    <xs:annotation>\r\n      <xs:documentation>\r\n        Quando aplicável, obriga ao preenchimento de ambos os campos.\r\n      </xs:documentation>\r\n    </xs:annotation>\r\n    <xs:sequence>\r\n      <xs:element ref=\"TaxExemptionReason\" />\r\n      <xs:element ref=\"TaxExemptionCode\" />\r\n    </xs:sequence>\r\n  </xs:group>\r\n  <!-- Estrutura de DebitLine em GeneralLedgerEntries -->\r\n  <xs:group name=\"DebitLineGroup\">\r\n    <xs:sequence>\r\n      <xs:element name=\"DebitLine\">\r\n        <xs:complexType>\r\n          <xs:sequence>\r\n            <xs:element ref=\"RecordID\" />\r\n            <xs:element name=\"AccountID\" type=\"SAFAOGLAccountID\" />\r\n            <xs:element ref=\"SourceDocumentID\" minOccurs=\"0\" />\r\n            <xs:element ref=\"SystemEntryDate\" />\r\n            <xs:element ref=\"Description\" />\r\n            <xs:element name=\"DebitAmount\" type=\"SAFmonetaryType\" />\r\n          </xs:sequence>\r\n        </xs:complexType>\r\n      </xs:element>\r\n    </xs:sequence>\r\n  </xs:group>\r\n  <!-- Estrutura de CreditLine em GeneralLedgerEntries -->\r\n  <xs:group name=\"CreditLineGroup\">\r\n    <xs:sequence>\r\n      <xs:element name=\"CreditLine\">\r\n        <xs:complexType>\r\n          <xs:sequence>\r\n            <xs:element ref=\"RecordID\" />\r\n            <xs:element name=\"AccountID\" type=\"SAFAOGLAccountID\" />\r\n            <xs:element ref=\"SourceDocumentID\" minOccurs=\"0\" />\r\n            <xs:element ref=\"SystemEntryDate\" />\r\n            <xs:element ref=\"Description\" />\r\n            <xs:element name=\"CreditAmount\" type=\"SAFmonetaryType\" />\r\n          </xs:sequence>\r\n        </xs:complexType>\r\n      </xs:element>\r\n    </xs:sequence>\r\n  </xs:group>\r\n  <!-- Estrutura de DeductibleTaxes -->\r\n  <xs:group name=\"DeductibleTaxes\">\r\n    <xs:sequence>\r\n      <xs:element ref=\"DeductibleTax\" minOccurs=\"1\"/>\r\n      <xs:element ref=\"DeductiblePercentage\" minOccurs=\"1\"></xs:element>\r\n    </xs:sequence>\r\n  </xs:group>\r\n  <xs:simpleType name=\"SAFTAOPaymentType\">\r\n    <xs:annotation>\r\n      <xs:documentation>\r\n        Deve ser preenchido com:\r\n          “RC” – Recibo emitido\r\n          “AR” – Aviso de cobrança/recibo \r\n          “RG” – Outros recibos emitidos.\r\n      </xs:documentation>\r\n    </xs:annotation>\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:enumeration value=\"RC\" />\r\n      <xs:enumeration value=\"RG\" />\r\n      <xs:enumeration value=\"AR\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <xs:simpleType name=\"SAFAOTaxExemption\">\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:minLength value=\"6\" />\r\n      <xs:maxLength value=\"60\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <xs:simpleType name=\"SAFAOAngolaVatNumber\">\r\n    <xs:annotation>\r\n      <xs:documentation>Preencher com o NIF Angolano sem espaços e sem qualquer prefixo do país.</xs:documentation>\r\n    </xs:annotation>\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:minLength value=\"10\" />\r\n      <xs:maxLength value=\"15\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <xs:simpleType name=\"SAFAOProductID\">\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:pattern value=\"[^/]+/[^/]+\" />\r\n      <xs:minLength value=\"3\" />\r\n      <xs:maxLength value=\"255\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <!-- Origem do documento -->\r\n  <xs:simpleType name=\"SAFTAOSourceBilling\">\r\n    <xs:annotation>\r\n      <xs:documentation>\r\n        P para documento produzido na aplicacao, \r\n        I para documento integrado e produzido noutra aplicacao, \r\n        M para documento proveniente de recuperacao ou de emissao manual \r\n      </xs:documentation>\r\n    </xs:annotation>\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:enumeration value=\"P\" />\r\n      <xs:enumeration value=\"I\" />\r\n      <xs:enumeration value=\"M\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <!-- Origem do documento -->\r\n  <xs:simpleType name=\"SAFTAOSourcePayment\">\r\n    <xs:annotation>\r\n      <xs:documentation>P para documento produzido na aplicacao, I para documento integrado e produzido noutra aplicacao, M para documento proveniente de recuperacao ou de emissao manual </xs:documentation>\r\n    </xs:annotation>\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:enumeration value=\"P\" />\r\n      <xs:enumeration value=\"I\" />\r\n      <xs:enumeration value=\"M\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <xs:simpleType name=\"SAFAOtextTypeMandatoryMax3Car\">\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:minLength value=\"1\" />\r\n      <xs:maxLength value=\"3\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <xs:simpleType name=\"SAFAOtextTypeMandatoryMax10Car\">\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:minLength value=\"1\" />\r\n      <xs:maxLength value=\"10\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <xs:simpleType name=\"SAFAOtextTypeMandatoryMax15Car\">\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:minLength value=\"1\" />\r\n      <xs:maxLength value=\"15\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <xs:simpleType name=\"SAFAOtextTypeMandatoryMax20Car\">\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:minLength value=\"1\" />\r\n      <xs:maxLength value=\"20\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <xs:simpleType name=\"SAFAOtextTypeMandatoryMax21Car\">\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:minLength value=\"1\" />\r\n      <xs:maxLength value=\"20\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <xs:simpleType name=\"SAFAOtextTypeMandatoryMax30Car\">\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:minLength value=\"1\" />\r\n      <xs:maxLength value=\"30\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <xs:simpleType name=\"SAFAOtextTypeMandatoryMax35Car\">\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:minLength value=\"1\" />\r\n      <xs:maxLength value=\"35\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <xs:simpleType name=\"SAFAOtextTypeMandatoryMax40Car\">\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:minLength value=\"1\" />\r\n      <xs:maxLength value=\"40\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <xs:simpleType name=\"SAFAOtextTypeMandatoryMax50Car\">\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:minLength value=\"1\" />\r\n      <xs:maxLength value=\"50\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <xs:simpleType name=\"SAFAOtextTypeMandatoryMax60Car\">\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:minLength value=\"1\" />\r\n      <xs:maxLength value=\"60\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <xs:simpleType name=\"SAFAOtextTypeMandatoryMax70Car\">\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:minLength value=\"1\" />\r\n      <xs:maxLength value=\"70\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <xs:simpleType name=\"SAFAOtextTypeMandatoryMax90Car\">\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:minLength value=\"1\" />\r\n      <xs:maxLength value=\"90\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <xs:simpleType name=\"SAFAOtextTypeMandatoryMax100Car\">\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:minLength value=\"1\" />\r\n      <xs:maxLength value=\"100\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <xs:simpleType name=\"SAFAOtextTypeMandatoryMax172Car\">\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:minLength value=\"1\" />\r\n      <xs:maxLength value=\"172\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <xs:simpleType name=\"SAFAOtextTypeMandatoryMax200Car\">\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:minLength value=\"1\" />\r\n      <xs:maxLength value=\"200\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <xs:simpleType name=\"SAFAOtextTypeMandatoryMax250Car\">\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:minLength value=\"1\" />\r\n      <xs:maxLength value=\"250\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <xs:simpleType name=\"SAFAOtextTypeMandatoryMax255Car\">\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:minLength value=\"1\" />\r\n      <xs:maxLength value=\"255\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <xs:simpleType name=\"SAFAOtextTypeMax40Car\">\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:minLength value=\"0\" />\r\n      <xs:maxLength value=\"40\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <xs:simpleType name=\"SAFAOtextValidationNumber\">\r\n    <xs:annotation>\r\n      <xs:documentation>\r\n        Número da validação, atribuído à entidade produtora do software.\r\n        Se não aplicável, deve ser preenchido com «0» (zero).\r\n      </xs:documentation>\r\n    </xs:annotation>\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:minLength value=\"1\" />\r\n      <xs:maxLength value=\"70\" />\r\n      <xs:pattern value=\"[1-9]+\\\\d?/AGT/\\\\d{4}|[0]\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <xs:simpleType name=\"SAFAOTransactionID\">\r\n    <xs:annotation>\r\n      <xs:documentation>\r\n          O preenchimento é obrigatório, no caso de se tratar de um sistema integrado de contabilidade e facturação, \r\n          ainda que o tipo de ficheiro (TaxAccountingBasis) não deva conter as tabelas relativas à contabilidade.\r\n          \r\n          Deve ser indicada a chave única da tabela 3.\r\n          Movimentos contabilísticos (GeneralLedgerEntries) da transacção onde foi lançado este documento, \r\n          respeitando a regra aí definida para o campo 3.4.3.1 - Chave única do movimento contabilístico (TransactionID).\r\n      </xs:documentation>\r\n    </xs:annotation>\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:pattern value=\"[1-9][0-9]{3}-[01][0-9]-[0-3][0-9] [^ ]{1,30} [^ ]{1,20}\" />\r\n      <xs:minLength value=\"1\" />\r\n      <xs:maxLength value=\"70\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <!-- Numero ONU para substancias perigosas -->\r\n  <xs:simpleType name=\"SAFAOUNNumber\">\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:pattern value=\"[0-9]{4}\" />\r\n      <xs:length value=\"4\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n  <!-- Codigo do pais (ISO 3166 1-alpha-2) -->\r\n  <xs:simpleType name=\"SupplierCountry\">\r\n    <xs:restriction base=\"xs:string\">\r\n      <xs:pattern value=\"AD|AE|AF|AG|AI|AL|AM|AO|AQ|AR|AS|AT|AU|AW|AX|AZ|BA|BB|BD|BE|BF|BG|BH|BI|BJ|BL|BM|BN|BO|BQ|BR|BS|BT|BV|BW|BY|BZ|CA|CC|CD|CF|CG|CH|CI|CK|CL|CM|CN|CO|CR|CU|CV|CW|CX|CY|CZ|DE|DJ|DK|DM|DO|DZ|EC|EE|EG|EH|ER|ES|ET|FI|FJ|FK|FM|FO|FR|GA|GB|GD|GE|GF|GG|GH|GI|GL|GM|GN|GP|GQ|GR|GS|GT|GU|GW|GY|HK|HM|HN|HR|HT|HU|ID|IE|IL|IM|IN|IO|IQ|IR|IS|IT|JE|JM|JO|JP|KE|KG|KH|KI|KM|KN|KP|KR|KW|KY|KZ|LA|LB|LC|LI|LK|LR|LS|LT|LU|LV|LY|MA|MC|MD|ME|MF|MG|MH|MK|ML|MM|MN|MO|MP|MQ|MR|MS|MT|MU|MV|MW|MX|MY|MZ|NA|NC|NE|NF|NG|NI|NL|NO|NP|NR|NU|NZ|OM|PA|PE|PF|PG|PH|PK|PL|PM|PN|PR|PS|PT|PW|PY|QA|RE|RO|RS|RU|RW|SA|SB|SC|SD|SE|SG|SH|SI|SJ|SK|SL|SM|SN|SO|SR|SS|ST|SV|SX|SY|SZ|TC|TD|TF|TG|TH|TJ|TK|TL|TM|TN|TO|TR|TT|TV|TW|TZ|UA|UG|UM|US|UY|UZ|VA|VC|VE|VG|VI|VN|VU|WF|WS|XK|YE|YT|ZA|ZM|ZW\" />\r\n      <xs:length value=\"2\" />\r\n    </xs:restriction>\r\n  </xs:simpleType>\r\n</xs:schema>');
INSERT INTO `tec_saf_setting` (`id`, `field`, `value`) VALUES ('3', 'xml_pattern', '<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<AuditFile>\r\n  <Header>\r\n    <AuditFileVersion>XML Correct Value</AuditFileVersion>\r\n    <CompanyID>XML Correct Value</CompanyID>\r\n    <TaxRegistrationNumber>XML Correct Value000</TaxRegistrationNumber>\r\n    <TaxAccountingBasis>A</TaxAccountingBasis>\r\n    <CompanyName>XML Correct Value</CompanyName>\r\n    <BusinessName>XML Correct Value</BusinessName>\r\n    <CompanyAddress>\r\n      <BuildingNumber>XML Correct Value</BuildingNumber>\r\n      <StreetName>XML Correct Value</StreetName>\r\n      <AddressDetail>XML Correct Value</AddressDetail>\r\n      <City>XML Correct Value</City>\r\n      <PostalCode>XML Correct Value</PostalCode>\r\n      <Province>XML Correct Value</Province>\r\n      <Country />\r\n    </CompanyAddress>\r\n    <FiscalYear>1234</FiscalYear>\r\n    <StartDate>YYYY-MM-DD</StartDate>\r\n    <EndDate>YYYY-MM-DD</EndDate>\r\n    <CurrencyCode>AOA</CurrencyCode>\r\n    <DateCreated>YYYY-MM-DD</DateCreated>\r\n    <TaxEntity>XML Correct Value</TaxEntity>\r\n    <ProductCompanyTaxID>XML Correct Value</ProductCompanyTaxID>\r\n    <SoftwareValidationNumber>XML Correct Value</SoftwareValidationNumber>\r\n    <ProductID>XML Correct Value</ProductID>\r\n    <ProductVersion>XML Correct Value</ProductVersion>\r\n    <HeaderComment>XML Correct Value</HeaderComment>\r\n    <Telephone>XML Correct Value</Telephone>\r\n    <Fax>XML Correct Value</Fax>\r\n    <Email>XML Correct Value</Email>\r\n    <Website>XML Correct Value</Website>\r\n  </Header>\r\n  <MasterFiles>\r\n    <GeneralLedgerAccounts>\r\n      <Account>\r\n        <AccountID>XML Correct Value</AccountID>\r\n        <AccountDescription>XML Correct Value</AccountDescription>\r\n        <OpeningDebitBalance>123.45</OpeningDebitBalance>\r\n        <OpeningCreditBalance>123.45</OpeningCreditBalance>\r\n        <ClosingDebitBalance>123.45</ClosingDebitBalance>\r\n        <ClosingCreditBalance>123.45</ClosingCreditBalance>\r\n        <GroupingCategory>GR</GroupingCategory>\r\n        <GroupingCode>XML Correct Value</GroupingCode>\r\n      </Account>\r\n    </GeneralLedgerAccounts>\r\n    <Customer>\r\n      <CustomerID>XML Correct Value</CustomerID>\r\n      <AccountID>XML Correct Value</AccountID>\r\n      <CustomerTaxID>XML Correct Value</CustomerTaxID>\r\n      <CompanyName>XML Correct Value</CompanyName>\r\n      <Contact>XML Correct Value</Contact>\r\n      <BillingAddress>\r\n        <BuildingNumber>XML Correct Value</BuildingNumber>\r\n        <StreetName>XML Correct Value</StreetName>\r\n        <AddressDetail>XML Correct Value</AddressDetail>\r\n        <City>XML Correct Value</City>\r\n        <PostalCode>XML Correct Value</PostalCode>\r\n        <Province>XML Correct Value</Province>\r\n        <Country>XML Correct Value</Country>\r\n      </BillingAddress>\r\n      <ShipToAddress>\r\n        <BuildingNumber>XML Correct Value</BuildingNumber>\r\n        <StreetName>XML Correct Value</StreetName>\r\n        <AddressDetail>XML Correct Value</AddressDetail>\r\n        <City>XML Correct Value</City>\r\n        <PostalCode>XML Correct Value</PostalCode>\r\n        <Province>XML Correct Value</Province>\r\n        <Country>XML Correct Value</Country>\r\n      </ShipToAddress>\r\n      <Telephone>XML Correct Value</Telephone>\r\n      <Fax>XML Correct Value</Fax>\r\n      <Email>XML Correct Value</Email>\r\n      <Website>XML Correct Value</Website>\r\n      <SelfBillingIndicator>1234</SelfBillingIndicator>\r\n    </Customer>\r\n    <Supplier>\r\n      <SupplierID>XML Correct Value</SupplierID>\r\n      <AccountID>XML Correct Value</AccountID>\r\n      <SupplierTaxID>XML Correct Value</SupplierTaxID>\r\n      <CompanyName>XML Correct Value</CompanyName>\r\n      <Contact>XML Correct Value</Contact>\r\n      <BillingAddress>\r\n        <BuildingNumber>XML Correct Value</BuildingNumber>\r\n        <StreetName>XML Correct Value</StreetName>\r\n        <AddressDetail>XML Correct Value</AddressDetail>\r\n        <City>XML Correct Value</City>\r\n        <PostalCode>XML Correct Value</PostalCode>\r\n        <Province>XML Correct Value</Province>\r\n        <Country>st</Country>\r\n      </BillingAddress>\r\n      <ShipFromAddress>\r\n        <BuildingNumber>XML Correct Value</BuildingNumber>\r\n        <StreetName>XML Correct Value</StreetName>\r\n        <AddressDetail>XML Correct Value</AddressDetail>\r\n        <City>XML Correct Value</City>\r\n        <PostalCode>XML Correct Value</PostalCode>\r\n        <Province>XML Correct Value</Province>\r\n        <Country>st</Country>\r\n      </ShipFromAddress>\r\n      <Telephone>XML Correct Value</Telephone>\r\n      <Fax>XML Correct Value</Fax>\r\n      <Email>XML Correct Value</Email>\r\n      <Website>XML Correct Value</Website>\r\n      <SelfBillingIndicator>1234</SelfBillingIndicator>\r\n    </Supplier>\r\n    <Product>\r\n      <ProductType>P</ProductType>\r\n      <ProductCode>XML Correct Value</ProductCode>\r\n      <ProductGroup>XML Correct Value</ProductGroup>\r\n      <ProductDescription>XML Correct Value</ProductDescription>\r\n      <ProductNumberCode>XML Correct Value</ProductNumberCode>\r\n      <CustomsDetails>\r\n        <UNNumber>str1</UNNumber>\r\n      </CustomsDetails>\r\n    </Product>\r\n    <TaxTable>\r\n      <TaxTableEntry>\r\n        <TaxType>IVA</TaxType>\r\n        <TaxCountryRegion>str12</TaxCountryRegion>\r\n        <TaxCode>XML Correct Value</TaxCode>\r\n        <Description>XML Correct Value</Description>\r\n        <TaxExpirationDate>YYYY-MM-DD</TaxExpirationDate>\r\n        <TaxPercentage>123.45</TaxPercentage>\r\n      </TaxTableEntry>\r\n    </TaxTable>\r\n  </MasterFiles>\r\n  <GeneralLedgerEntries>\r\n    <NumberOfEntries>33</NumberOfEntries>\r\n    <TotalDebit>123.45</TotalDebit>\r\n    <TotalCredit>123.45</TotalCredit>\r\n    <Journal>\r\n      <JournalID>XML Correct Value</JournalID>\r\n      <Description>XML Correct Value</Description>\r\n      <Transaction>\r\n        <TransactionID>XML Correct Value</TransactionID>\r\n        <Period>1234</Period>\r\n        <TransactionDate>YYYY-MM-DD</TransactionDate>\r\n        <SourceID>XML Correct Value</SourceID>\r\n        <Description>XML Correct Value</Description>\r\n        <DocArchivalNumber>XML Correct Value</DocArchivalNumber>\r\n        <TransactionType>N</TransactionType>\r\n        <GLPostingDate>YYYY-MM-DD</GLPostingDate>\r\n        <CustomerID>XML Correct Value</CustomerID>\r\n        <Lines />\r\n      </Transaction>\r\n    </Journal>\r\n  </GeneralLedgerEntries>\r\n  <SourceDocuments>\r\n    <SalesInvoices>\r\n      <NumberOfEntries>33</NumberOfEntries>\r\n      <TotalDebit>123.45</TotalDebit>\r\n      <TotalCredit>123.45</TotalCredit>\r\n      <Invoice>\r\n        <InvoiceNo>XML Correct Value</InvoiceNo>\r\n        <DocumentStatus>\r\n          <InvoiceStatus>N</InvoiceStatus>\r\n          <InvoiceStatusDate>YYYY-MM-DDT12:12:12</InvoiceStatusDate>\r\n          <Reason>XML Correct Value</Reason>\r\n          <SourceID>XML Correct Value</SourceID>\r\n          <SourceBilling>P</SourceBilling>\r\n        </DocumentStatus>\r\n        <Hash>XML Correct Value</Hash>\r\n        <HashControl>XML Correct Value</HashControl>\r\n        <Period>1234</Period>\r\n        <InvoiceDate>YYYY-MM-DD</InvoiceDate>\r\n        <InvoiceType>FT</InvoiceType>\r\n        <SpecialRegimes>\r\n          <SelfBillingIndicator>1234</SelfBillingIndicator>\r\n          <CashVATSchemeIndicator>1234</CashVATSchemeIndicator>\r\n          <ThirdPartiesBillingIndicator>1234</ThirdPartiesBillingIndicator>\r\n        </SpecialRegimes>\r\n        <SourceID>XML Correct Value</SourceID>\r\n        <EACCode>str12</EACCode>\r\n        <SystemEntryDate>YYYY-MM-DDT12:12:12</SystemEntryDate>\r\n        <TransactionID>XML Correct Value</TransactionID>\r\n        <CustomerID>XML Correct Value</CustomerID>\r\n        <ShipTo>\r\n          <DeliveryID>XML Correct Value</DeliveryID>\r\n          <DeliveryDate>YYYY-MM-DD</DeliveryDate>\r\n          <Address>\r\n            <BuildingNumber>XML Correct Value</BuildingNumber>\r\n            <StreetName>XML Correct Value</StreetName>\r\n            <AddressDetail>XML Correct Value</AddressDetail>\r\n            <City>XML Correct Value</City>\r\n            <PostalCode>XML Correct Value</PostalCode>\r\n            <Province>XML Correct Value</Province>\r\n            <Country>XML Correct Value</Country>\r\n          </Address>\r\n        </ShipTo>\r\n        <ShipFrom>\r\n          <DeliveryID>XML Correct Value</DeliveryID>\r\n          <DeliveryDate>YYYY-MM-DD</DeliveryDate>\r\n          <Address>\r\n            <BuildingNumber>XML Correct Value</BuildingNumber>\r\n            <StreetName>XML Correct Value</StreetName>\r\n            <AddressDetail>XML Correct Value</AddressDetail>\r\n            <City>XML Correct Value</City>\r\n            <PostalCode>XML Correct Value</PostalCode>\r\n            <Province>XML Correct Value</Province>\r\n            <Country>XML Correct Value</Country>\r\n          </Address>\r\n        </ShipFrom>\r\n        <MovementEndTime>YYYY-MM-DDT12:12:12</MovementEndTime>\r\n        <MovementStartTime>YYYY-MM-DDT12:12:12</MovementStartTime>\r\n        <Line>\r\n          <LineNumber>33</LineNumber>\r\n          <OrderReferences>\r\n            <OriginatingON>XML Correct Value</OriginatingON>\r\n            <OrderDate>YYYY-MM-DD</OrderDate>\r\n          </OrderReferences>\r\n          <ProductCode>XML Correct Value</ProductCode>\r\n          <ProductDescription>XML Correct Value</ProductDescription>\r\n          <Quantity>123.45</Quantity>\r\n          <UnitOfMeasure>XML Correct Value</UnitOfMeasure>\r\n          <UnitPrice>123.45</UnitPrice>\r\n          <TaxBase>123.45</TaxBase>\r\n          <TaxPointDate>YYYY-MM-DD</TaxPointDate>\r\n          <References>\r\n            <Reference>XML Correct Value</Reference>\r\n            <Reason>XML Correct Value</Reason>\r\n          </References>\r\n          <Description>XML Correct Value</Description>\r\n          <ProductSerialNumber>\r\n            <SerialNumber>XML Correct Value</SerialNumber>\r\n          </ProductSerialNumber>\r\n          <DebitAmount>123.45</DebitAmount>\r\n          <Tax>\r\n            <TaxType>IVA</TaxType>\r\n            <TaxCountryRegion>str12</TaxCountryRegion>\r\n            <TaxCode>XML Correct Value</TaxCode>\r\n            <TaxPercentage>123.45</TaxPercentage>\r\n          </Tax>\r\n          <SettlementAmount>123.45</SettlementAmount>\r\n          <CustomsInformation>\r\n            <ARCNo>XML Correct Value</ARCNo>\r\n            <IECAmount>123.45</IECAmount>\r\n          </CustomsInformation>\r\n        </Line>\r\n        <DocumentTotals>\r\n          <TaxPayable>123.45</TaxPayable>\r\n          <NetTotal>123.45</NetTotal>\r\n          <GrossTotal>123.45</GrossTotal>\r\n          <Currency>\r\n            <CurrencyCode>str</CurrencyCode>\r\n            <CurrencyAmount>123.45</CurrencyAmount>\r\n            <ExchangeRate>123.45</ExchangeRate>\r\n          </Currency>\r\n          <Settlement>\r\n            <SettlementDiscount>XML Correct Value</SettlementDiscount>\r\n            <SettlementAmount>123.45</SettlementAmount>\r\n            <SettlementDate>YYYY-MM-DD</SettlementDate>\r\n            <PaymentTerms>XML Correct Value</PaymentTerms>\r\n          </Settlement>\r\n          <Payment>\r\n            <PaymentMechanism>CC</PaymentMechanism>\r\n            <PaymentAmount>123.45</PaymentAmount>\r\n            <PaymentDate>YYYY-MM-DD</PaymentDate>\r\n          </Payment>\r\n        </DocumentTotals>\r\n        <WithholdingTax>\r\n          <WithholdingTaxType>IRT</WithholdingTaxType>\r\n          <WithholdingTaxDescription>XML Correct Value</WithholdingTaxDescription>\r\n          <WithholdingTaxAmount>123.45</WithholdingTaxAmount>\r\n        </WithholdingTax>\r\n      </Invoice>\r\n    </SalesInvoices>\r\n    <MovementOfGoods>\r\n      <NumberOfMovementLines>33</NumberOfMovementLines>\r\n      <TotalQuantityIssued>123.45</TotalQuantityIssued>\r\n      <StockMovement>\r\n        <DocumentNumber>XML Correct Value</DocumentNumber>\r\n        <DocumentStatus>\r\n          <MovementStatus>N</MovementStatus>\r\n          <MovementStatusDate>YYYY-MM-DDT12:12:12</MovementStatusDate>\r\n          <Reason>XML Correct Value</Reason>\r\n          <SourceID>XML Correct Value</SourceID>\r\n          <SourceBilling>P</SourceBilling>\r\n        </DocumentStatus>\r\n        <Hash>XML Correct Value</Hash>\r\n        <HashControl>XML Correct Value</HashControl>\r\n        <Period>1234</Period>\r\n        <MovementDate>YYYY-MM-DD</MovementDate>\r\n        <MovementType>GR</MovementType>\r\n        <SystemEntryDate>YYYY-MM-DDT12:12:12</SystemEntryDate>\r\n        <TransactionID>XML Correct Value</TransactionID>\r\n        <CustomerID>XML Correct Value</CustomerID>\r\n        <SourceID>XML Correct Value</SourceID>\r\n        <EACCode>str12</EACCode>\r\n        <MovementComments>XML Correct Value</MovementComments>\r\n        <ShipTo>\r\n          <DeliveryID>XML Correct Value</DeliveryID>\r\n          <DeliveryDate>YYYY-MM-DD</DeliveryDate>\r\n          <Address>\r\n            <BuildingNumber>XML Correct Value</BuildingNumber>\r\n            <StreetName>XML Correct Value</StreetName>\r\n            <AddressDetail>XML Correct Value</AddressDetail>\r\n            <City>XML Correct Value</City>\r\n            <PostalCode>XML Correct Value</PostalCode>\r\n            <Province>XML Correct Value</Province>\r\n            <Country>XML Correct Value</Country>\r\n          </Address>\r\n        </ShipTo>\r\n        <ShipFrom>\r\n          <DeliveryID>XML Correct Value</DeliveryID>\r\n          <DeliveryDate>YYYY-MM-DD</DeliveryDate>\r\n          <Address>\r\n            <BuildingNumber>XML Correct Value</BuildingNumber>\r\n            <StreetName>XML Correct Value</StreetName>\r\n            <AddressDetail>XML Correct Value</AddressDetail>\r\n            <City>XML Correct Value</City>\r\n            <PostalCode>XML Correct Value</PostalCode>\r\n            <Province>XML Correct Value</Province>\r\n            <Country>XML Correct Value</Country>\r\n          </Address>\r\n        </ShipFrom>\r\n        <MovementEndTime>YYYY-MM-DDT12:12:12</MovementEndTime>\r\n        <MovementStartTime>YYYY-MM-DDT12:12:12</MovementStartTime>\r\n        <AGTDocCodeID>XML Correct Value</AGTDocCodeID>\r\n        <Line>\r\n          <LineNumber>33</LineNumber>\r\n          <OrderReferences>\r\n            <OriginatingON>XML Correct Value</OriginatingON>\r\n            <OrderDate>YYYY-MM-DD</OrderDate>\r\n          </OrderReferences>\r\n          <ProductCode>XML Correct Value</ProductCode>\r\n          <ProductDescription>XML Correct Value</ProductDescription>\r\n          <Quantity>123.45</Quantity>\r\n          <UnitOfMeasure>XML Correct Value</UnitOfMeasure>\r\n          <UnitPrice>123.45</UnitPrice>\r\n          <Description>XML Correct Value</Description>\r\n          <ProductSerialNumber>\r\n            <SerialNumber>XML Correct Value</SerialNumber>\r\n          </ProductSerialNumber>\r\n          <DebitAmount>123.45</DebitAmount>\r\n          <Tax>\r\n            <TaxType>IVA</TaxType>\r\n            <TaxCountryRegion>str12</TaxCountryRegion>\r\n            <TaxCode>str</TaxCode>\r\n            <TaxPercentage>123.45</TaxPercentage>\r\n          </Tax>\r\n          <SettlementAmount>123.45</SettlementAmount>\r\n          <CustomsInformation>\r\n            <ARCNo>XML Correct Value</ARCNo>\r\n            <IECAmount>123.45</IECAmount>\r\n          </CustomsInformation>\r\n        </Line>\r\n        <DocumentTotals>\r\n          <TaxPayable>123.45</TaxPayable>\r\n          <NetTotal>123.45</NetTotal>\r\n          <GrossTotal>123.45</GrossTotal>\r\n          <Currency>\r\n            <CurrencyCode>str</CurrencyCode>\r\n            <CurrencyAmount>123.45</CurrencyAmount>\r\n            <ExchangeRate>123.45</ExchangeRate>\r\n          </Currency>\r\n        </DocumentTotals>\r\n      </StockMovement>\r\n    </MovementOfGoods>\r\n    <WorkingDocuments>\r\n      <NumberOfEntries>33</NumberOfEntries>\r\n      <TotalDebit>123.45</TotalDebit>\r\n      <TotalCredit>123.45</TotalCredit>\r\n      <WorkDocument>\r\n        <DocumentNumber>XML Correct Value</DocumentNumber>\r\n        <DocumentStatus>\r\n          <WorkStatus>N</WorkStatus>\r\n          <WorkStatusDate>YYYY-MM-DDT12:12:12</WorkStatusDate>\r\n          <Reason>XML Correct Value</Reason>\r\n          <SourceID>XML Correct Value</SourceID>\r\n          <SourceBilling>P</SourceBilling>\r\n        </DocumentStatus>\r\n        <Hash>XML Correct Value</Hash>\r\n        <HashControl>XML Correct Value</HashControl>\r\n        <Period>1234</Period>\r\n        <WorkDate>YYYY-MM-DD</WorkDate>\r\n        <WorkType>CM</WorkType>\r\n        <SourceID>XML Correct Value</SourceID>\r\n        <EACCode>str12</EACCode>\r\n        <SystemEntryDate>YYYY-MM-DDT12:12:12</SystemEntryDate>\r\n        <CustomerID>XML Correct Value</CustomerID>\r\n        <Line>\r\n          <LineNumber>33</LineNumber>\r\n          <OrderReferences>\r\n            <OriginatingON>XML Correct Value</OriginatingON>\r\n            <OrderDate>YYYY-MM-DD</OrderDate>\r\n          </OrderReferences>\r\n          <ProductCode>XML Correct Value</ProductCode>\r\n          <ProductDescription>XML Correct Value</ProductDescription>\r\n          <Quantity>123.45</Quantity>\r\n          <UnitOfMeasure>XML Correct Value</UnitOfMeasure>\r\n          <UnitPrice>123.45</UnitPrice>\r\n          <TaxPointDate>YYYY-MM-DD</TaxPointDate>\r\n          <Description>XML Correct Value</Description>\r\n          <ProductSerialNumber>\r\n            <SerialNumber>XML Correct Value</SerialNumber>\r\n          </ProductSerialNumber>\r\n          <DebitAmount>123.45</DebitAmount>\r\n          <Tax>\r\n            <TaxType>IVA</TaxType>\r\n            <TaxCountryRegion>str12</TaxCountryRegion>\r\n            <TaxCode>XML Correct Value</TaxCode>\r\n            <TaxPercentage>123.45</TaxPercentage>\r\n          </Tax>\r\n          <SettlementAmount>123.45</SettlementAmount>\r\n        </Line>\r\n        <DocumentTotals>\r\n          <TaxPayable>123.45</TaxPayable>\r\n          <NetTotal>123.45</NetTotal>\r\n          <GrossTotal>123.45</GrossTotal>\r\n          <Currency>\r\n            <CurrencyCode>str</CurrencyCode>\r\n            <CurrencyAmount>123.45</CurrencyAmount>\r\n            <ExchangeRate>123.45</ExchangeRate>\r\n          </Currency>\r\n        </DocumentTotals>\r\n      </WorkDocument>\r\n    </WorkingDocuments>\r\n    <Payments>\r\n      <NumberOfEntries>33</NumberOfEntries>\r\n      <TotalDebit>123.45</TotalDebit>\r\n      <TotalCredit>123.45</TotalCredit>\r\n      <Payment>\r\n        <PaymentRefNo>XML Correct Value</PaymentRefNo>\r\n        <Period>1234</Period>\r\n        <TransactionID>XML Correct Value</TransactionID>\r\n        <TransactionDate>YYYY-MM-DD</TransactionDate>\r\n        <PaymentType>RC</PaymentType>\r\n        <Description>XML Correct Value</Description>\r\n        <SystemID>XML Correct Value</SystemID>\r\n        <DocumentStatus>\r\n          <PaymentStatus>N</PaymentStatus>\r\n          <PaymentStatusDate>YYYY-MM-DDT12:12:12</PaymentStatusDate>\r\n          <Reason>XML Correct Value</Reason>\r\n          <SourceID>XML Correct Value</SourceID>\r\n          <SourcePayment>P</SourcePayment>\r\n        </DocumentStatus>\r\n        <PaymentMethod>\r\n          <PaymentMechanism>CC</PaymentMechanism>\r\n          <PaymentAmount>123.45</PaymentAmount>\r\n          <PaymentDate>YYYY-MM-DD</PaymentDate>\r\n        </PaymentMethod>\r\n        <SourceID>XML Correct Value</SourceID>\r\n        <SystemEntryDate>YYYY-MM-DDT12:12:12</SystemEntryDate>\r\n        <CustomerID>XML Correct Value</CustomerID>\r\n        <Line>\r\n          <LineNumber>33</LineNumber>\r\n          <SourceDocumentID>\r\n            <OriginatingON>XML Correct Value</OriginatingON>\r\n            <InvoiceDate>YYYY-MM-DD</InvoiceDate>\r\n            <Description>XML Correct Value</Description>\r\n          </SourceDocumentID>\r\n          <SettlementAmount>123.45</SettlementAmount>\r\n          <DebitAmount>123.45</DebitAmount>\r\n          <Tax>\r\n            <TaxType>IVA</TaxType>\r\n            <TaxCountryRegion>str12</TaxCountryRegion>\r\n            <TaxCode>XML Correct Value</TaxCode>\r\n            <TaxPercentage>123.45</TaxPercentage>\r\n          </Tax>\r\n        </Line>\r\n        <DocumentTotals>\r\n          <TaxPayable>123.45</TaxPayable>\r\n          <NetTotal>123.45</NetTotal>\r\n          <GrossTotal>123.45</GrossTotal>\r\n          <Settlement>\r\n            <SettlementAmount>123.45</SettlementAmount>\r\n          </Settlement>\r\n          <Currency>\r\n            <CurrencyCode>str</CurrencyCode>\r\n            <CurrencyAmount>123.45</CurrencyAmount>\r\n            <ExchangeRate>123.45</ExchangeRate>\r\n          </Currency>\r\n        </DocumentTotals>\r\n        <WithholdingTax>\r\n          <WithholdingTaxType>IRT</WithholdingTaxType>\r\n          <WithholdingTaxDescription>XML Correct Value</WithholdingTaxDescription>\r\n          <WithholdingTaxAmount>123.45</WithholdingTaxAmount>\r\n        </WithholdingTax>\r\n      </Payment>\r\n    </Payments>\r\n    <PurchaseInvoices>\r\n      <NumberOfEntries>33</NumberOfEntries>\r\n      <Invoice>\r\n        <InvoiceNo>XML Correct Value</InvoiceNo>\r\n        <Period>1234</Period>\r\n        <InvoiceDate>YYYY-MM-DD</InvoiceDate>\r\n        <InvoiceType>FT</InvoiceType>\r\n        <SourceID>XML Correct Value</SourceID>\r\n        <SupplierID>XML Correct Value</SupplierID>\r\n        <DocumentTotals>\r\n          <InputTax>123.45</InputTax>\r\n          <TaxPayable>123.45</TaxPayable>\r\n          <NetTotal>123.45</NetTotal>\r\n          <GrossTotal>123.45</GrossTotal>\r\n          <Currency>\r\n            <CurrencyCode>str</CurrencyCode>\r\n            <CurrencyAmount>123.45</CurrencyAmount>\r\n            <ExchangeRate>123.45</ExchangeRate>\r\n          </Currency>\r\n        </DocumentTotals>\r\n      </Invoice>\r\n    </PurchaseInvoices>\r\n  </SourceDocuments>\r\n</AuditFile>');
INSERT INTO `tec_saf_setting` (`id`, `field`, `value`) VALUES ('4', 'audit_pattern', '<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<AuditFile>\r\n  <Header>Header_pattern</Header>\r\n  <MasterFiles>\r\n    <GeneralLedgerAccounts>\r\n      Account_pattern\r\n    </GeneralLedgerAccounts>\r\n    <Customer>Customer_pattern</Customer>\r\n    <Supplier>Supplier_pattern</Supplier>\r\n    <Product>Product_pattern</Product>\r\n    <TaxTable>TaxTable_pattern</TaxTable>\r\n  </MasterFiles>\r\n  <GeneralLedgerEntries>generalledgerentries_pattern</GeneralLedgerEntries>\r\n  <SourceDocuments>\r\n    <SalesInvoices>\r\n      <NumberOfEntries>33</NumberOfEntries>\r\n      <TotalDebit>123.45</TotalDebit>\r\n      <TotalCredit>123.45</TotalCredit>\r\n      <Invoice>SalesInvoices_pattern</Invoice>\r\n    </SalesInvoices>\r\n    <MovementOfGoods>\r\n      <NumberOfMovementLines>33</NumberOfMovementLines>\r\n      <TotalQuantityIssued>123.45</TotalQuantityIssued>\r\n      <StockMovement>MovementOfGoods_pattern</StockMovement>\r\n    </MovementOfGoods>\r\n    <WorkingDocuments>\r\n      <NumberOfEntries>33</NumberOfEntries>\r\n      <TotalDebit>123.45</TotalDebit>\r\n      <TotalCredit>123.45</TotalCredit>\r\n      <WorkDocument>WorkingDocuments_pattern</WorkDocument>\r\n    </WorkingDocuments>\r\n    <Payments>\r\n      <NumberOfEntries>33</NumberOfEntries>\r\n      <TotalDebit>123.45</TotalDebit>\r\n      <TotalCredit>123.45</TotalCredit>\r\n      <Payment>Payments_pattern</Payment>\r\n    </Payments>\r\n    <PurchaseInvoices>PurchaseInvoices_pattern</PurchaseInvoices>\r\n  </SourceDocuments>\r\n</AuditFile>');
INSERT INTO `tec_saf_setting` (`id`, `field`, `value`) VALUES ('5', 'header_pattern', '\r\n    <AuditFileVersion>XML Correct Value</AuditFileVersion>\r\n    <CompanyID>XML Correct Value</CompanyID>\r\n    <TaxRegistrationNumber>XML Correct Value000</TaxRegistrationNumber>\r\n    <TaxAccountingBasis>A</TaxAccountingBasis>\r\n    <CompanyName>XML Correct Value</CompanyName>\r\n    <BusinessName>XML Correct Value</BusinessName>\r\n    <CompanyAddress>\r\n      <BuildingNumber>XML Correct Value</BuildingNumber>\r\n      <StreetName>XML Correct Value</StreetName>\r\n      <AddressDetail>XML Correct Value</AddressDetail>\r\n      <City>XML Correct Value</City>\r\n      <PostalCode>XML Correct Value</PostalCode>\r\n      <Province>XML Correct Value</Province>\r\n      <Country />\r\n    </CompanyAddress>\r\n    <FiscalYear>1234</FiscalYear>\r\n    <StartDate>YYYY-MM-DD</StartDate>\r\n    <EndDate>YYYY-MM-DD</EndDate>\r\n    <CurrencyCode>AOA</CurrencyCode>\r\n    <DateCreated>YYYY-MM-DD</DateCreated>\r\n    <TaxEntity>XML Correct Value</TaxEntity>\r\n    <ProductCompanyTaxID>XML Correct Value</ProductCompanyTaxID>\r\n    <SoftwareValidationNumber>XML Correct Value</SoftwareValidationNumber>\r\n    <ProductID>XML Correct Value</ProductID>\r\n    <ProductVersion>XML Correct Value</ProductVersion>\r\n    <HeaderComment>XML Correct Value</HeaderComment>\r\n    <Telephone>XML Correct Value</Telephone>\r\n    <Fax>XML Correct Value</Fax>\r\n    <Email>XML Correct Value</Email>\r\n    <Website>XML Correct Value</Website>\r\n  ');
INSERT INTO `tec_saf_setting` (`id`, `field`, `value`) VALUES ('6', 'account_pattern', '<Account>\r\n        <AccountID>XML Correct Value</AccountID>\r\n        <AccountDescription>XML Correct Value</AccountDescription>\r\n        <OpeningDebitBalance>123.45</OpeningDebitBalance>\r\n        <OpeningCreditBalance>123.45</OpeningCreditBalance>\r\n        <ClosingDebitBalance>123.45</ClosingDebitBalance>\r\n        <ClosingCreditBalance>123.45</ClosingCreditBalance>\r\n        <GroupingCategory>GR</GroupingCategory>\r\n        <GroupingCode>XML Correct Value</GroupingCode>\r\n      </Account>');
INSERT INTO `tec_saf_setting` (`id`, `field`, `value`) VALUES ('7', 'customer_pattern', '<Customer>\r\n      <CustomerID>XML Correct Value</CustomerID>\r\n      <AccountID>XML Correct Value</AccountID>\r\n      <CustomerTaxID>XML Correct Value</CustomerTaxID>\r\n      <CompanyName>XML Correct Value</CompanyName>\r\n      <Contact>XML Correct Value</Contact>\r\n      <BillingAddress>\r\n        <BuildingNumber>XML Correct Value</BuildingNumber>\r\n        <StreetName>XML Correct Value</StreetName>\r\n        <AddressDetail>XML Correct Value</AddressDetail>\r\n        <City>XML Correct Value</City>\r\n        <PostalCode>XML Correct Value</PostalCode>\r\n        <Province>XML Correct Value</Province>\r\n        <Country>XML Correct Value</Country>\r\n      </BillingAddress>\r\n      <ShipToAddress>\r\n        <BuildingNumber>XML Correct Value</BuildingNumber>\r\n        <StreetName>XML Correct Value</StreetName>\r\n        <AddressDetail>XML Correct Value</AddressDetail>\r\n        <City>XML Correct Value</City>\r\n        <PostalCode>XML Correct Value</PostalCode>\r\n        <Province>XML Correct Value</Province>\r\n        <Country>XML Correct Value</Country>\r\n      </ShipToAddress>\r\n      <Telephone>XML Correct Value</Telephone>\r\n      <Fax>XML Correct Value</Fax>\r\n      <Email>XML Correct Value</Email>\r\n      <Website>XML Correct Value</Website>\r\n      <SelfBillingIndicator>1234</SelfBillingIndicator>\r\n    </Customer>');
INSERT INTO `tec_saf_setting` (`id`, `field`, `value`) VALUES ('8', 'supplier_pattern', '<Supplier>\r\n      <SupplierID>XML Correct Value</SupplierID>\r\n      <AccountID>XML Correct Value</AccountID>\r\n      <SupplierTaxID>XML Correct Value</SupplierTaxID>\r\n      <CompanyName>XML Correct Value</CompanyName>\r\n      <Contact>XML Correct Value</Contact>\r\n      <BillingAddress>\r\n        <BuildingNumber>XML Correct Value</BuildingNumber>\r\n        <StreetName>XML Correct Value</StreetName>\r\n        <AddressDetail>XML Correct Value</AddressDetail>\r\n        <City>XML Correct Value</City>\r\n        <PostalCode>XML Correct Value</PostalCode>\r\n        <Province>XML Correct Value</Province>\r\n        <Country>st</Country>\r\n      </BillingAddress>\r\n      <ShipFromAddress>\r\n        <BuildingNumber>XML Correct Value</BuildingNumber>\r\n        <StreetName>XML Correct Value</StreetName>\r\n        <AddressDetail>XML Correct Value</AddressDetail>\r\n        <City>XML Correct Value</City>\r\n        <PostalCode>XML Correct Value</PostalCode>\r\n        <Province>XML Correct Value</Province>\r\n        <Country>st</Country>\r\n      </ShipFromAddress>\r\n      <Telephone>XML Correct Value</Telephone>\r\n      <Fax>XML Correct Value</Fax>\r\n      <Email>XML Correct Value</Email>\r\n      <Website>XML Correct Value</Website>\r\n      <SelfBillingIndicator>1234</SelfBillingIndicator>\r\n    </Supplier>');
INSERT INTO `tec_saf_setting` (`id`, `field`, `value`) VALUES ('9', 'product_pattern', '<Product>\r\n      <ProductType>P</ProductType>\r\n      <ProductCode>XML Correct Value</ProductCode>\r\n      <ProductGroup>XML Correct Value</ProductGroup>\r\n      <ProductDescription>XML Correct Value</ProductDescription>\r\n      <ProductNumberCode>XML Correct Value</ProductNumberCode>\r\n      <CustomsDetails>\r\n        <UNNumber>str1</UNNumber>\r\n      </CustomsDetails>\r\n    </Product>');
INSERT INTO `tec_saf_setting` (`id`, `field`, `value`) VALUES ('10', 'taxtable_pattern', '\r\n      <TaxTableEntry>\r\n        <TaxType>IVA</TaxType>\r\n        <TaxCountryRegion>str12</TaxCountryRegion>\r\n        <TaxCode>XML Correct Value</TaxCode>\r\n        <Description>XML Correct Value</Description>\r\n        <TaxExpirationDate>YYYY-MM-DD</TaxExpirationDate>\r\n        <TaxPercentage>123.45</TaxPercentage>\r\n      </TaxTableEntry>\r\n    ');
INSERT INTO `tec_saf_setting` (`id`, `field`, `value`) VALUES ('11', 'generalledgerentries_pattern', '\r\n    <NumberOfEntries>33</NumberOfEntries>\r\n    <TotalDebit>123.45</TotalDebit>\r\n    <TotalCredit>123.45</TotalCredit>\r\n    <Journal>\r\n      <JournalID>XML Correct Value</JournalID>\r\n      <Description>XML Correct Value</Description>\r\n      <Transaction>\r\n        <TransactionID>XML Correct Value</TransactionID>\r\n        <Period>1234</Period>\r\n        <TransactionDate>YYYY-MM-DD</TransactionDate>\r\n        <SourceID>XML Correct Value</SourceID>\r\n        <Description>XML Correct Value</Description>\r\n        <DocArchivalNumber>XML Correct Value</DocArchivalNumber>\r\n        <TransactionType>N</TransactionType>\r\n        <GLPostingDate>YYYY-MM-DD</GLPostingDate>\r\n        <CustomerID>XML Correct Value</CustomerID>\r\n        <Lines />\r\n      </Transaction>\r\n    </Journal>\r\n  ');
INSERT INTO `tec_saf_setting` (`id`, `field`, `value`) VALUES ('12', 'saleinvoice_pattern', '\r\n        <InvoiceNo>XML Correct Value</InvoiceNo>\r\n        <DocumentStatus>\r\n          <InvoiceStatus>N</InvoiceStatus>\r\n          <InvoiceStatusDate>YYYY-MM-DDT12:12:12</InvoiceStatusDate>\r\n          <Reason>XML Correct Value</Reason>\r\n          <SourceID>XML Correct Value</SourceID>\r\n          <SourceBilling>P</SourceBilling>\r\n        </DocumentStatus>\r\n        <Hash>XML Correct Value</Hash>\r\n        <HashControl>XML Correct Value</HashControl>\r\n        <Period>1234</Period>\r\n        <InvoiceDate>YYYY-MM-DD</InvoiceDate>\r\n        <InvoiceType>FT</InvoiceType>\r\n        <SpecialRegimes>\r\n          <SelfBillingIndicator>1234</SelfBillingIndicator>\r\n          <CashVATSchemeIndicator>1234</CashVATSchemeIndicator>\r\n          <ThirdPartiesBillingIndicator>1234</ThirdPartiesBillingIndicator>\r\n        </SpecialRegimes>\r\n        <SourceID>XML Correct Value</SourceID>\r\n        <EACCode>str12</EACCode>\r\n        <SystemEntryDate>YYYY-MM-DDT12:12:12</SystemEntryDate>\r\n        <TransactionID>XML Correct Value</TransactionID>\r\n        <CustomerID>XML Correct Value</CustomerID>\r\n        <ShipTo>\r\n          <DeliveryID>XML Correct Value</DeliveryID>\r\n          <DeliveryDate>YYYY-MM-DD</DeliveryDate>\r\n          <Address>\r\n            <BuildingNumber>XML Correct Value</BuildingNumber>\r\n            <StreetName>XML Correct Value</StreetName>\r\n            <AddressDetail>XML Correct Value</AddressDetail>\r\n            <City>XML Correct Value</City>\r\n            <PostalCode>XML Correct Value</PostalCode>\r\n            <Province>XML Correct Value</Province>\r\n            <Country>XML Correct Value</Country>\r\n          </Address>\r\n        </ShipTo>\r\n        <ShipFrom>\r\n          <DeliveryID>XML Correct Value</DeliveryID>\r\n          <DeliveryDate>YYYY-MM-DD</DeliveryDate>\r\n          <Address>\r\n            <BuildingNumber>XML Correct Value</BuildingNumber>\r\n            <StreetName>XML Correct Value</StreetName>\r\n            <AddressDetail>XML Correct Value</AddressDetail>\r\n            <City>XML Correct Value</City>\r\n            <PostalCode>XML Correct Value</PostalCode>\r\n            <Province>XML Correct Value</Province>\r\n            <Country>XML Correct Value</Country>\r\n          </Address>\r\n        </ShipFrom>\r\n        <MovementEndTime>YYYY-MM-DDT12:12:12</MovementEndTime>\r\n        <MovementStartTime>YYYY-MM-DDT12:12:12</MovementStartTime>\r\n        <Line>\r\n          <LineNumber>33</LineNumber>\r\n          <OrderReferences>\r\n            <OriginatingON>XML Correct Value</OriginatingON>\r\n            <OrderDate>YYYY-MM-DD</OrderDate>\r\n          </OrderReferences>\r\n          <ProductCode>XML Correct Value</ProductCode>\r\n          <ProductDescription>XML Correct Value</ProductDescription>\r\n          <Quantity>123.45</Quantity>\r\n          <UnitOfMeasure>XML Correct Value</UnitOfMeasure>\r\n          <UnitPrice>123.45</UnitPrice>\r\n          <TaxBase>123.45</TaxBase>\r\n          <TaxPointDate>YYYY-MM-DD</TaxPointDate>\r\n          <References>\r\n            <Reference>XML Correct Value</Reference>\r\n            <Reason>XML Correct Value</Reason>\r\n          </References>\r\n          <Description>XML Correct Value</Description>\r\n          <ProductSerialNumber>\r\n            <SerialNumber>XML Correct Value</SerialNumber>\r\n          </ProductSerialNumber>\r\n          <DebitAmount>123.45</DebitAmount>\r\n          <Tax>\r\n            <TaxType>IVA</TaxType>\r\n            <TaxCountryRegion>str12</TaxCountryRegion>\r\n            <TaxCode>XML Correct Value</TaxCode>\r\n            <TaxPercentage>123.45</TaxPercentage>\r\n          </Tax>\r\n          <SettlementAmount>123.45</SettlementAmount>\r\n          <CustomsInformation>\r\n            <ARCNo>XML Correct Value</ARCNo>\r\n            <IECAmount>123.45</IECAmount>\r\n          </CustomsInformation>\r\n        </Line>\r\n        <DocumentTotals>\r\n          <TaxPayable>123.45</TaxPayable>\r\n          <NetTotal>123.45</NetTotal>\r\n          <GrossTotal>123.45</GrossTotal>\r\n          <Currency>\r\n            <CurrencyCode>str</CurrencyCode>\r\n            <CurrencyAmount>123.45</CurrencyAmount>\r\n            <ExchangeRate>123.45</ExchangeRate>\r\n          </Currency>\r\n          <Settlement>\r\n            <SettlementDiscount>XML Correct Value</SettlementDiscount>\r\n            <SettlementAmount>123.45</SettlementAmount>\r\n            <SettlementDate>YYYY-MM-DD</SettlementDate>\r\n            <PaymentTerms>XML Correct Value</PaymentTerms>\r\n          </Settlement>\r\n          <Payment>\r\n            <PaymentMechanism>CC</PaymentMechanism>\r\n            <PaymentAmount>123.45</PaymentAmount>\r\n            <PaymentDate>YYYY-MM-DD</PaymentDate>\r\n          </Payment>\r\n        </DocumentTotals>\r\n        <WithholdingTax>\r\n          <WithholdingTaxType>IRT</WithholdingTaxType>\r\n          <WithholdingTaxDescription>XML Correct Value</WithholdingTaxDescription>\r\n          <WithholdingTaxAmount>123.45</WithholdingTaxAmount>\r\n        </WithholdingTax>\r\n      ');
INSERT INTO `tec_saf_setting` (`id`, `field`, `value`) VALUES ('13', 'movementofgood_pattern', '\r\n        <DocumentNumber>XML Correct Value</DocumentNumber>\r\n        <DocumentStatus>\r\n          <MovementStatus>N</MovementStatus>\r\n          <MovementStatusDate>YYYY-MM-DDT12:12:12</MovementStatusDate>\r\n          <Reason>XML Correct Value</Reason>\r\n          <SourceID>XML Correct Value</SourceID>\r\n          <SourceBilling>P</SourceBilling>\r\n        </DocumentStatus>\r\n        <Hash>XML Correct Value</Hash>\r\n        <HashControl>XML Correct Value</HashControl>\r\n        <Period>1234</Period>\r\n        <MovementDate>YYYY-MM-DD</MovementDate>\r\n        <MovementType>GR</MovementType>\r\n        <SystemEntryDate>YYYY-MM-DDT12:12:12</SystemEntryDate>\r\n        <TransactionID>XML Correct Value</TransactionID>\r\n        <CustomerID>XML Correct Value</CustomerID>\r\n        <SourceID>XML Correct Value</SourceID>\r\n        <EACCode>str12</EACCode>\r\n        <MovementComments>XML Correct Value</MovementComments>\r\n        <ShipTo>\r\n          <DeliveryID>XML Correct Value</DeliveryID>\r\n          <DeliveryDate>YYYY-MM-DD</DeliveryDate>\r\n          <Address>\r\n            <BuildingNumber>XML Correct Value</BuildingNumber>\r\n            <StreetName>XML Correct Value</StreetName>\r\n            <AddressDetail>XML Correct Value</AddressDetail>\r\n            <City>XML Correct Value</City>\r\n            <PostalCode>XML Correct Value</PostalCode>\r\n            <Province>XML Correct Value</Province>\r\n            <Country>XML Correct Value</Country>\r\n          </Address>\r\n        </ShipTo>\r\n        <ShipFrom>\r\n          <DeliveryID>XML Correct Value</DeliveryID>\r\n          <DeliveryDate>YYYY-MM-DD</DeliveryDate>\r\n          <Address>\r\n            <BuildingNumber>XML Correct Value</BuildingNumber>\r\n            <StreetName>XML Correct Value</StreetName>\r\n            <AddressDetail>XML Correct Value</AddressDetail>\r\n            <City>XML Correct Value</City>\r\n            <PostalCode>XML Correct Value</PostalCode>\r\n            <Province>XML Correct Value</Province>\r\n            <Country>XML Correct Value</Country>\r\n          </Address>\r\n        </ShipFrom>\r\n        <MovementEndTime>YYYY-MM-DDT12:12:12</MovementEndTime>\r\n        <MovementStartTime>YYYY-MM-DDT12:12:12</MovementStartTime>\r\n        <AGTDocCodeID>XML Correct Value</AGTDocCodeID>\r\n        <Line>\r\n          <LineNumber>33</LineNumber>\r\n          <OrderReferences>\r\n            <OriginatingON>XML Correct Value</OriginatingON>\r\n            <OrderDate>YYYY-MM-DD</OrderDate>\r\n          </OrderReferences>\r\n          <ProductCode>XML Correct Value</ProductCode>\r\n          <ProductDescription>XML Correct Value</ProductDescription>\r\n          <Quantity>123.45</Quantity>\r\n          <UnitOfMeasure>XML Correct Value</UnitOfMeasure>\r\n          <UnitPrice>123.45</UnitPrice>\r\n          <Description>XML Correct Value</Description>\r\n          <ProductSerialNumber>\r\n            <SerialNumber>XML Correct Value</SerialNumber>\r\n          </ProductSerialNumber>\r\n          <DebitAmount>123.45</DebitAmount>\r\n          <Tax>\r\n            <TaxType>IVA</TaxType>\r\n            <TaxCountryRegion>str12</TaxCountryRegion>\r\n            <TaxCode>str</TaxCode>\r\n            <TaxPercentage>123.45</TaxPercentage>\r\n          </Tax>\r\n          <SettlementAmount>123.45</SettlementAmount>\r\n          <CustomsInformation>\r\n            <ARCNo>XML Correct Value</ARCNo>\r\n            <IECAmount>123.45</IECAmount>\r\n          </CustomsInformation>\r\n        </Line>\r\n        <DocumentTotals>\r\n          <TaxPayable>123.45</TaxPayable>\r\n          <NetTotal>123.45</NetTotal>\r\n          <GrossTotal>123.45</GrossTotal>\r\n          <Currency>\r\n            <CurrencyCode>str</CurrencyCode>\r\n            <CurrencyAmount>123.45</CurrencyAmount>\r\n            <ExchangeRate>123.45</ExchangeRate>\r\n          </Currency>\r\n        </DocumentTotals>\r\n      ');
INSERT INTO `tec_saf_setting` (`id`, `field`, `value`) VALUES ('14', 'workingdocuments_pattern', '\r\n        <DocumentNumber>XML Correct Value</DocumentNumber>\r\n        <DocumentStatus>\r\n          <WorkStatus>N</WorkStatus>\r\n          <WorkStatusDate>YYYY-MM-DDT12:12:12</WorkStatusDate>\r\n          <Reason>XML Correct Value</Reason>\r\n          <SourceID>XML Correct Value</SourceID>\r\n          <SourceBilling>P</SourceBilling>\r\n        </DocumentStatus>\r\n        <Hash>XML Correct Value</Hash>\r\n        <HashControl>XML Correct Value</HashControl>\r\n        <Period>1234</Period>\r\n        <WorkDate>YYYY-MM-DD</WorkDate>\r\n        <WorkType>CM</WorkType>\r\n        <SourceID>XML Correct Value</SourceID>\r\n        <EACCode>str12</EACCode>\r\n        <SystemEntryDate>YYYY-MM-DDT12:12:12</SystemEntryDate>\r\n        <CustomerID>XML Correct Value</CustomerID>\r\n        <Line>\r\n          <LineNumber>33</LineNumber>\r\n          <OrderReferences>\r\n            <OriginatingON>XML Correct Value</OriginatingON>\r\n            <OrderDate>YYYY-MM-DD</OrderDate>\r\n          </OrderReferences>\r\n          <ProductCode>XML Correct Value</ProductCode>\r\n          <ProductDescription>XML Correct Value</ProductDescription>\r\n          <Quantity>123.45</Quantity>\r\n          <UnitOfMeasure>XML Correct Value</UnitOfMeasure>\r\n          <UnitPrice>123.45</UnitPrice>\r\n          <TaxPointDate>YYYY-MM-DD</TaxPointDate>\r\n          <Description>XML Correct Value</Description>\r\n          <ProductSerialNumber>\r\n            <SerialNumber>XML Correct Value</SerialNumber>\r\n          </ProductSerialNumber>\r\n          <DebitAmount>123.45</DebitAmount>\r\n          <Tax>\r\n            <TaxType>IVA</TaxType>\r\n            <TaxCountryRegion>str12</TaxCountryRegion>\r\n            <TaxCode>XML Correct Value</TaxCode>\r\n            <TaxPercentage>123.45</TaxPercentage>\r\n          </Tax>\r\n          <SettlementAmount>123.45</SettlementAmount>\r\n        </Line>\r\n        <DocumentTotals>\r\n          <TaxPayable>123.45</TaxPayable>\r\n          <NetTotal>123.45</NetTotal>\r\n          <GrossTotal>123.45</GrossTotal>\r\n          <Currency>\r\n            <CurrencyCode>str</CurrencyCode>\r\n            <CurrencyAmount>123.45</CurrencyAmount>\r\n            <ExchangeRate>123.45</ExchangeRate>\r\n          </Currency>\r\n        </DocumentTotals>\r\n      ');
INSERT INTO `tec_saf_setting` (`id`, `field`, `value`) VALUES ('15', 'payment_pattern', '\r\n        <PaymentRefNo>XML Correct Value</PaymentRefNo>\r\n        <Period>1234</Period>\r\n        <TransactionID>XML Correct Value</TransactionID>\r\n        <TransactionDate>YYYY-MM-DD</TransactionDate>\r\n        <PaymentType>RC</PaymentType>\r\n        <Description>XML Correct Value</Description>\r\n        <SystemID>XML Correct Value</SystemID>\r\n        <DocumentStatus>\r\n          <PaymentStatus>N</PaymentStatus>\r\n          <PaymentStatusDate>YYYY-MM-DDT12:12:12</PaymentStatusDate>\r\n          <Reason>XML Correct Value</Reason>\r\n          <SourceID>XML Correct Value</SourceID>\r\n          <SourcePayment>P</SourcePayment>\r\n        </DocumentStatus>\r\n        <PaymentMethod>\r\n          <PaymentMechanism>CC</PaymentMechanism>\r\n          <PaymentAmount>123.45</PaymentAmount>\r\n          <PaymentDate>YYYY-MM-DD</PaymentDate>\r\n        </PaymentMethod>\r\n        <SourceID>XML Correct Value</SourceID>\r\n        <SystemEntryDate>YYYY-MM-DDT12:12:12</SystemEntryDate>\r\n        <CustomerID>XML Correct Value</CustomerID>\r\n        <Line>\r\n          <LineNumber>33</LineNumber>\r\n          <SourceDocumentID>\r\n            <OriginatingON>XML Correct Value</OriginatingON>\r\n            <InvoiceDate>YYYY-MM-DD</InvoiceDate>\r\n            <Description>XML Correct Value</Description>\r\n          </SourceDocumentID>\r\n          <SettlementAmount>123.45</SettlementAmount>\r\n          <DebitAmount>123.45</DebitAmount>\r\n          <Tax>\r\n            <TaxType>IVA</TaxType>\r\n            <TaxCountryRegion>str12</TaxCountryRegion>\r\n            <TaxCode>XML Correct Value</TaxCode>\r\n            <TaxPercentage>123.45</TaxPercentage>\r\n          </Tax>\r\n        </Line>\r\n        <DocumentTotals>\r\n          <TaxPayable>123.45</TaxPayable>\r\n          <NetTotal>123.45</NetTotal>\r\n          <GrossTotal>123.45</GrossTotal>\r\n          <Settlement>\r\n            <SettlementAmount>123.45</SettlementAmount>\r\n          </Settlement>\r\n          <Currency>\r\n            <CurrencyCode>str</CurrencyCode>\r\n            <CurrencyAmount>123.45</CurrencyAmount>\r\n            <ExchangeRate>123.45</ExchangeRate>\r\n          </Currency>\r\n        </DocumentTotals>\r\n        <WithholdingTax>\r\n          <WithholdingTaxType>IRT</WithholdingTaxType>\r\n          <WithholdingTaxDescription>XML Correct Value</WithholdingTaxDescription>\r\n          <WithholdingTaxAmount>123.45</WithholdingTaxAmount>\r\n        </WithholdingTax>\r\n      ');
INSERT INTO `tec_saf_setting` (`id`, `field`, `value`) VALUES ('16', 'purchaseinvoice_pattern', '\r\n      <NumberOfEntries>33</NumberOfEntries>\r\n      <Invoice>\r\n        <InvoiceNo>XML Correct Value</InvoiceNo>\r\n        <Period>1234</Period>\r\n        <InvoiceDate>YYYY-MM-DD</InvoiceDate>\r\n        <InvoiceType>FT</InvoiceType>\r\n        <SourceID>XML Correct Value</SourceID>\r\n        <SupplierID>XML Correct Value</SupplierID>\r\n        <DocumentTotals>\r\n          <InputTax>123.45</InputTax>\r\n          <TaxPayable>123.45</TaxPayable>\r\n          <NetTotal>123.45</NetTotal>\r\n          <GrossTotal>123.45</GrossTotal>\r\n          <Currency>\r\n            <CurrencyCode>str</CurrencyCode>\r\n            <CurrencyAmount>123.45</CurrencyAmount>\r\n            <ExchangeRate>123.45</ExchangeRate>\r\n          </Currency>\r\n        </DocumentTotals>\r\n      </Invoice>\r\n    ');


#
# TABLE STRUCTURE FOR: tec_sale_items
#

DROP TABLE IF EXISTS `tec_sale_items`;

CREATE TABLE `tec_sale_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sale_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `quantity` decimal(15,2) NOT NULL,
  `unit_price` decimal(25,4) NOT NULL,
  `net_unit_price` decimal(25,4) NOT NULL,
  `discount` varchar(20) DEFAULT NULL,
  `item_discount` decimal(25,4) DEFAULT NULL,
  `tax_id` int(11) DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `item_tax` decimal(25,4) DEFAULT NULL,
  `subtotal` decimal(25,4) NOT NULL,
  `real_unit_price` decimal(25,4) DEFAULT NULL,
  `cost` decimal(25,2) DEFAULT '0.00',
  `create_by` int(11) DEFAULT NULL,
  `note` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=120 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('81', '59', '11', '1.00', '550.0000', '550.0000', '0', '0.0000', '1', '0', '77.0000', '627.0000', '550.0000', '440.00', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('82', '59', '14', '1.00', '2000.0000', '2000.0000', '0', '0.0000', '1', '0', '280.0000', '2280.0000', '2000.0000', '1439.00', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('83', '59', '15', '2.00', '700.0000', '700.0000', '0', '0.0000', '1', '0', '196.0000', '1596.0000', '700.0000', '698.00', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('84', '59', '16', '1.00', '50.0000', '50.0000', '0', '0.0000', '1', '0', '7.0000', '57.0000', '50.0000', '37.00', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('85', '59', '17', '1.00', '250.0000', '250.0000', '0', '0.0000', '1', '0', '35.0000', '285.0000', '250.0000', '180.00', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('86', '59', '18', '1.00', '150.0000', '150.0000', '0', '0.0000', '1', '0', '21.0000', '171.0000', '150.0000', '100.00', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('87', '59', '19', '1.00', '150.0000', '150.0000', '0', '0.0000', '1', '0', '21.0000', '171.0000', '150.0000', '114.00', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('88', '59', '20', '1.00', '150.0000', '150.0000', '0', '0.0000', '1', '0', '21.0000', '171.0000', '150.0000', '100.00', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('89', '59', '21', '1.00', '2500.0000', '2500.0000', '0', '0.0000', '1', '0', '350.0000', '2850.0000', '2500.0000', '1573.00', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('90', '59', '22', '2.00', '1200.0000', '1200.0000', '0', '0.0000', '1', '0', '336.0000', '2736.0000', '1200.0000', '919.00', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('91', '59', '23', '2.00', '840.0000', '840.0000', '30%', '720.0000', '1', '0', '235.2000', '1915.2000', '1200.0000', '919.00', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('92', '59', '25', '1.00', '100.0000', '100.0000', '0', '0.0000', '1', '0', '14.0000', '114.0000', '100.0000', '64.00', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('93', '59', '32', '1.00', '100.0000', '100.0000', '0', '0.0000', '1', '0', '14.0000', '114.0000', '100.0000', '80.00', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('94', '59', '39', '1.00', '250.0000', '250.0000', '0', '0.0000', '1', '0', '35.0000', '285.0000', '250.0000', '270.00', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('95', '59', '40', '2.00', '700.0000', '700.0000', '0', '0.0000', '1', '0', '196.0000', '1596.0000', '700.0000', '516.67', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('96', '59', '42', '2.00', '440.0000', '440.0000', '60%', '1320.0000', '1', '0', '123.2000', '1003.2000', '1100.0000', '866.66', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('97', '59', '43', '2.00', '200.0000', '200.0000', '0', '0.0000', '1', '0', '56.0000', '456.0000', '200.0000', '168.00', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('98', '59', '44', '1.00', '166.6700', '166.6700', '0', '0.0000', '1', '0', '23.3300', '190.0000', '166.6700', '143.75', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('99', '59', '45', '2.00', '230.0000', '230.0000', '0', '0.0000', '1', '0', '64.4000', '524.4000', '230.0000', '180.00', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('100', '59', '46', '1.00', '50.0000', '50.0000', '0', '0.0000', '3', '0', '0.0000', '50.0000', '50.0000', '37.00', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('101', '59', '47', '1.00', '166.6700', '166.6700', '0', '0.0000', '8', '0', '0.0000', '166.6700', '166.6700', '143.75', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('102', '59', '48', '1.00', '1400.0000', '1400.0000', '0', '0.0000', '3', '0', '0.0000', '1400.0000', '1400.0000', '0.00', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('103', '59', '50', '2.00', '350.0000', '350.0000', '0', '0.0000', '8', '0', '0.0000', '700.0000', '350.0000', '245.00', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('104', '59', '51', '1.00', '550.0000', '550.0000', '0', '0.0000', '8', '0', '0.0000', '550.0000', '550.0000', '422.00', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('105', '60', '16', '1.00', '50.0000', '50.0000', '0%%', '0.0000', '1', '0', '7.0000', '57.0000', '50.0000', '37.00', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('106', '60', '18', '1.00', '150.0000', '150.0000', '0%%', '0.0000', '1', '0', '21.0000', '171.0000', '150.0000', '100.00', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('107', '61', '47', '1.00', '166.6700', '166.6700', '0%%', '0.0000', '8', '0', '0.0000', '166.6700', '166.6700', '143.75', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('108', '61', '50', '1.00', '350.0000', '350.0000', '0%%', '0.0000', '8', '0', '0.0000', '350.0000', '350.0000', '245.00', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('109', '62', '18', '1.00', '60.0000', '60.0000', '60%', '90.0000', '1', '0', '8.4000', '68.4000', '150.0000', '100.00', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('110', '62', '20', '1.00', '105.0000', '105.0000', '30%', '45.0000', '1', '0', '14.7000', '119.7000', '150.0000', '100.00', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('111', '63', '16', '1.00', '50.0000', '50.0000', '0%%', '0.0000', '1', '0', '7.0000', '57.0000', '50.0000', '37.00', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('112', '63', '18', '1.00', '150.0000', '150.0000', '0%%', '0.0000', '1', '0', '21.0000', '171.0000', '150.0000', '100.00', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('113', '64', '15', '1.00', '700.0000', '700.0000', '0%%', '0.0000', '1', '0', '98.0000', '798.0000', '700.0000', '698.00', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('114', '64', '20', '2.00', '150.0000', '150.0000', '0%%', '0.0000', '1', '0', '42.0000', '342.0000', '150.0000', '100.00', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('115', '64', '22', '1.00', '1200.0000', '1200.0000', '0%%', '0.0000', '1', '0', '168.0000', '1368.0000', '1200.0000', '919.00', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('116', '65', '21', '1.00', '2500.0000', '2500.0000', '0%%', '0.0000', '1', '0', '350.0000', '2850.0000', '2500.0000', '1573.00', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('117', '65', '23', '1.00', '1080.0000', '1080.0000', '10%', '120.0000', '1', '0', '151.2000', '1231.2000', '1200.0000', '919.00', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('118', '66', '18', '1.00', '60.0000', '60.0000', '60%', '90.0000', '1', '0', '8.4000', '68.4000', '150.0000', '100.00', NULL, '');
INSERT INTO `tec_sale_items` (`id`, `sale_id`, `product_id`, `quantity`, `unit_price`, `net_unit_price`, `discount`, `item_discount`, `tax_id`, `tax`, `item_tax`, `subtotal`, `real_unit_price`, `cost`, `create_by`, `note`) VALUES ('119', '66', '20', '1.00', '105.0000', '105.0000', '30%', '45.0000', '1', '0', '14.7000', '119.7000', '150.0000', '100.00', NULL, '');


#
# TABLE STRUCTURE FOR: tec_sale_sub_items
#

DROP TABLE IF EXISTS `tec_sale_sub_items`;

CREATE TABLE `tec_sale_sub_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sale_id` int(11) NOT NULL,
  `subitem_id` int(11) NOT NULL,
  `quantity` decimal(15,2) NOT NULL,
  `discount` varchar(20) DEFAULT NULL,
  `subtotal` decimal(25,2) NOT NULL,
  `real_unit_price` decimal(25,2) DEFAULT NULL,
  `tax_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

#
# TABLE STRUCTURE FOR: tec_sales
#

DROP TABLE IF EXISTS `tec_sales`;

CREATE TABLE `tec_sales` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Hash` varchar(2555) DEFAULT NULL,
  `Hash_no` text NOT NULL,
  `HashControl` varchar(2555) DEFAULT NULL,
  `date` datetime NOT NULL,
  `customer_id` int(11) NOT NULL,
  `customer_name` varchar(55) NOT NULL,
  `total` decimal(25,2) NOT NULL,
  `product_discount` decimal(25,2) DEFAULT NULL,
  `order_discount_id` varchar(20) DEFAULT NULL,
  `order_discount` decimal(25,2) DEFAULT NULL,
  `total_discount` decimal(25,2) DEFAULT NULL,
  `total_balance` double NOT NULL DEFAULT '0',
  `product_tax` decimal(25,2) DEFAULT NULL,
  `order_tax_id` varchar(20) DEFAULT NULL,
  `order_tax` decimal(25,4) DEFAULT NULL,
  `total_tax` decimal(25,4) DEFAULT NULL,
  `grand_total` decimal(25,4) NOT NULL,
  `total_items` int(11) DEFAULT NULL,
  `total_quantity` decimal(15,4) DEFAULT NULL,
  `paid` decimal(25,4) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `note` varchar(1000) NOT NULL,
  `status` varchar(20) NOT NULL,
  `rounding` decimal(8,2) DEFAULT NULL,
  `InvoiceType` varchar(255) NOT NULL,
  `InvoiceStatus` varchar(255) NOT NULL,
  `InvoiceNo` varchar(255) NOT NULL,
  `InvoiceYear` year(4) NOT NULL,
  `InvoiceStatusDate` varchar(255) NOT NULL,
  `SourceBilling` varchar(4) NOT NULL,
  `CashVATSchemeIndicator` varchar(255) NOT NULL,
  `SelfBillingIndicator` varchar(4) NOT NULL,
  `ThirdPartiesBillingIndicator` varchar(100) NOT NULL,
  `OriginatingON` varchar(5555) NOT NULL,
  `Reason` varchar(50) NOT NULL,
  `OrderReferences` varchar(255) DEFAULT NULL,
  `mesa` varchar(255) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=67 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

INSERT INTO `tec_sales` (`id`, `Hash`, `Hash_no`, `HashControl`, `date`, `customer_id`, `customer_name`, `total`, `product_discount`, `order_discount_id`, `order_discount`, `total_discount`, `total_balance`, `product_tax`, `order_tax_id`, `order_tax`, `total_tax`, `grand_total`, `total_items`, `total_quantity`, `paid`, `created_by`, `updated_by`, `updated_at`, `note`, `status`, `rounding`, `InvoiceType`, `InvoiceStatus`, `InvoiceNo`, `InvoiceYear`, `InvoiceStatusDate`, `SourceBilling`, `CashVATSchemeIndicator`, `SelfBillingIndicator`, `ThirdPartiesBillingIndicator`, `OriginatingON`, `Reason`, `OrderReferences`, `mesa`) VALUES ('59', 'SwIsMqHJJKiZsq8xh4mdA6AoDDH2Gidyj/nLyeBkRfW7mQvJ8/BnSfu74kR1xBECEWTT7xi5s0J73Lm1tnPoK2PcjGyO6Ohd63r5Ml7o8SM19XElKrcsgfoqApjmFhhKgwwhYWqNOpBnotpG+woh4qAsxpW7g96xWin8lSOuVLI=', '2024-02-06;2024-02-06T17:16:59;FT SIF2024/1;20008.47;', '1', '2024-02-06 17:16:59', '73', 'Consumidor Final', '17903.34', '2040.00', NULL, '0.00', '2040.00', '0', '2105.13', '0%', '0.0000', '2105.1300', '20008.4700', '24', '32.0000', '20008.4700', '16', NULL, NULL, '', 'paid', '0.00', 'FT', 'N', 'FT SIF2024/1', '2024', '2024-02-06T17:16:59', 'P', '1', '0', '0', '', '', NULL, 'N');
INSERT INTO `tec_sales` (`id`, `Hash`, `Hash_no`, `HashControl`, `date`, `customer_id`, `customer_name`, `total`, `product_discount`, `order_discount_id`, `order_discount`, `total_discount`, `total_balance`, `product_tax`, `order_tax_id`, `order_tax`, `total_tax`, `grand_total`, `total_items`, `total_quantity`, `paid`, `created_by`, `updated_by`, `updated_at`, `note`, `status`, `rounding`, `InvoiceType`, `InvoiceStatus`, `InvoiceNo`, `InvoiceYear`, `InvoiceStatusDate`, `SourceBilling`, `CashVATSchemeIndicator`, `SelfBillingIndicator`, `ThirdPartiesBillingIndicator`, `OriginatingON`, `Reason`, `OrderReferences`, `mesa`) VALUES ('60', 'hHWhDECexdcr7uq8NuEMpQWSAb2M1gg3uHJzv+tkutljVeZp7z6TII4VYF4Qka3bjkfzfVkw5MCge5HOXpZbVYbh75TpGgF3KqQOGo/jR8YxO6y76doo0Ngf/G3PzXygGANsTnslgzmwlddIlhWcYYoVy7HEiJU/lm+esc1Zp3o=', '2024-02-06;2024-02-06T17:38:38;FT SIF2024/2;228.00;SwIsMqHJJKiZsq8xh4mdA6AoDDH2Gidyj/nLyeBkRfW7mQvJ8/BnSfu74kR1xBECEWTT7xi5s0J73Lm1tnPoK2PcjGyO6Ohd63r5Ml7o8SM19XElKrcsgfoqApjmFhhKgwwhYWqNOpBnotpG+woh4qAsxpW7g96xWin8lSOuVLI=', '1', '2024-02-06 17:38:38', '73', 'Consumidor Final', '200.00', '0.00', NULL, '0.00', '0.00', '0', '28.00', '0%', '0.0000', '28.0000', '228.0000', '2', '2.0000', '228.0000', '16', NULL, NULL, '', 'paid', '0.00', 'FT', 'N', 'FT SIF2024/2', '2024', '2024-02-06T17:38:38', 'P', '1', '0', '0', '', '', NULL, 'N');
INSERT INTO `tec_sales` (`id`, `Hash`, `Hash_no`, `HashControl`, `date`, `customer_id`, `customer_name`, `total`, `product_discount`, `order_discount_id`, `order_discount`, `total_discount`, `total_balance`, `product_tax`, `order_tax_id`, `order_tax`, `total_tax`, `grand_total`, `total_items`, `total_quantity`, `paid`, `created_by`, `updated_by`, `updated_at`, `note`, `status`, `rounding`, `InvoiceType`, `InvoiceStatus`, `InvoiceNo`, `InvoiceYear`, `InvoiceStatusDate`, `SourceBilling`, `CashVATSchemeIndicator`, `SelfBillingIndicator`, `ThirdPartiesBillingIndicator`, `OriginatingON`, `Reason`, `OrderReferences`, `mesa`) VALUES ('61', 'NZi4eoohngJmFrPFM/ol+VjUmBqkRnYGLxZoqQ24Pjf0S58JAMLm6PwLvJC3Txs09iy2UP7a+fIYa/GWMv1NMvyMsXcxBoxaktWYpC7emC8lcuIwDf+LROxL3IjUiLD8kW1k2PaYmCAsuZVdhz484wBez/5v+zNU8B7CQglMJK0=', '2024-02-06;2024-02-06T17:40:09;FT SIF2024/3;516.67;hHWhDECexdcr7uq8NuEMpQWSAb2M1gg3uHJzv+tkutljVeZp7z6TII4VYF4Qka3bjkfzfVkw5MCge5HOXpZbVYbh75TpGgF3KqQOGo/jR8YxO6y76doo0Ngf/G3PzXygGANsTnslgzmwlddIlhWcYYoVy7HEiJU/lm+esc1Zp3o=', '1', '2024-02-06 17:40:09', '73', 'Consumidor Final', '516.67', '0.00', NULL, '0.00', '0.00', '0', '0.00', '0%', '0.0000', '0.0000', '516.6700', '2', '2.0000', '0.0000', '16', NULL, NULL, '', 'no paid', '0.00', 'FT', 'N', 'FT SIF2024/3', '2024', '2024-02-06T17:40:09', 'P', '1', '0', '0', '', '', NULL, 'N');
INSERT INTO `tec_sales` (`id`, `Hash`, `Hash_no`, `HashControl`, `date`, `customer_id`, `customer_name`, `total`, `product_discount`, `order_discount_id`, `order_discount`, `total_discount`, `total_balance`, `product_tax`, `order_tax_id`, `order_tax`, `total_tax`, `grand_total`, `total_items`, `total_quantity`, `paid`, `created_by`, `updated_by`, `updated_at`, `note`, `status`, `rounding`, `InvoiceType`, `InvoiceStatus`, `InvoiceNo`, `InvoiceYear`, `InvoiceStatusDate`, `SourceBilling`, `CashVATSchemeIndicator`, `SelfBillingIndicator`, `ThirdPartiesBillingIndicator`, `OriginatingON`, `Reason`, `OrderReferences`, `mesa`) VALUES ('62', 'u6CxGFmv1qU1wU6mXo6jpdqbMfZ+vKUIQtDE0+3B3Z9SAT1Y9TD+21FkHZNGpdT+DdtKyGW/J3V64A2neCavstcBoPwtNA9LjAniyrNASajJZOkj3SqttHcCYtwdihqKbB1GC2DhZpRIkH3KJ4UnS4xm+wXgkkAOgF+W161je94=', '2024-02-06;2024-02-06T17:41:41;FT SIF2024/4;188.10;NZi4eoohngJmFrPFM/ol+VjUmBqkRnYGLxZoqQ24Pjf0S58JAMLm6PwLvJC3Txs09iy2UP7a+fIYa/GWMv1NMvyMsXcxBoxaktWYpC7emC8lcuIwDf+LROxL3IjUiLD8kW1k2PaYmCAsuZVdhz484wBez/5v+zNU8B7CQglMJK0=', '1', '2024-02-06 17:41:41', '73', 'Consumidor Final', '165.00', '135.00', NULL, '0.00', '135.00', '0', '23.10', '0%', '0.0000', '23.1000', '188.1000', '2', '2.0000', '0.0000', '16', NULL, NULL, '', 'no paid', '0.00', 'FT', 'N', 'FT SIF2024/4', '2024', '2024-02-06T17:41:41', 'P', '1', '0', '0', '', '', NULL, 'NC');
INSERT INTO `tec_sales` (`id`, `Hash`, `Hash_no`, `HashControl`, `date`, `customer_id`, `customer_name`, `total`, `product_discount`, `order_discount_id`, `order_discount`, `total_discount`, `total_balance`, `product_tax`, `order_tax_id`, `order_tax`, `total_tax`, `grand_total`, `total_items`, `total_quantity`, `paid`, `created_by`, `updated_by`, `updated_at`, `note`, `status`, `rounding`, `InvoiceType`, `InvoiceStatus`, `InvoiceNo`, `InvoiceYear`, `InvoiceStatusDate`, `SourceBilling`, `CashVATSchemeIndicator`, `SelfBillingIndicator`, `ThirdPartiesBillingIndicator`, `OriginatingON`, `Reason`, `OrderReferences`, `mesa`) VALUES ('63', 'mHCH8R8vkKHrwaJMopXydn38QFWEmWz+Si0+nI2PHklEvzT9lkjU/kPvbHfeABL0unqomET4D015cQp5BptMz/TpQJPL8ncWnG6DdXxjyfgkdN4yDjXgkfwkTQIJqGy4ffnaPUyX74k3tEbZmXBlm2VW9rPRnrM2iPW/wWWiYPw=', '2024-02-06;2024-02-06T17:42:24;FR SIF2024/1;228.00;', '1', '2024-02-06 17:42:24', '73', 'Consumidor Final', '200.00', '0.00', NULL, '0.00', '0.00', '0', '28.00', '0%', '0.0000', '28.0000', '228.0000', '2', '2.0000', '228.0000', '16', NULL, NULL, '', 'paid', '0.00', 'FR', 'N', 'FR SIF2024/1', '2024', '2024-02-06T17:42:24', 'P', '1', '0', '0', '', '', NULL, 'N');
INSERT INTO `tec_sales` (`id`, `Hash`, `Hash_no`, `HashControl`, `date`, `customer_id`, `customer_name`, `total`, `product_discount`, `order_discount_id`, `order_discount`, `total_discount`, `total_balance`, `product_tax`, `order_tax_id`, `order_tax`, `total_tax`, `grand_total`, `total_items`, `total_quantity`, `paid`, `created_by`, `updated_by`, `updated_at`, `note`, `status`, `rounding`, `InvoiceType`, `InvoiceStatus`, `InvoiceNo`, `InvoiceYear`, `InvoiceStatusDate`, `SourceBilling`, `CashVATSchemeIndicator`, `SelfBillingIndicator`, `ThirdPartiesBillingIndicator`, `OriginatingON`, `Reason`, `OrderReferences`, `mesa`) VALUES ('64', 'R4pqw5Es6LtKRO4ZydQANIhO/XVZE+gm23Hb5tmAfhTl6hmM62rsnHi4+nVEdqtLj2YqsXUwY98lcmALiX51YRNS+LV7H7nMfULz0vUz22mFNmPK5bnCxMB2ZbMApXifYOKnM10kb7RrKSj+tXcKa7mWMm4POJgx2h+uceramEQ=', '2024-02-06;2024-02-06T17:43:22;FR SIF2024/2;2508.00;mHCH8R8vkKHrwaJMopXydn38QFWEmWz+Si0+nI2PHklEvzT9lkjU/kPvbHfeABL0unqomET4D015cQp5BptMz/TpQJPL8ncWnG6DdXxjyfgkdN4yDjXgkfwkTQIJqGy4ffnaPUyX74k3tEbZmXBlm2VW9rPRnrM2iPW/wWWiYPw=', '1', '2024-02-06 17:43:22', '73', 'Consumidor Final', '2200.00', '0.00', NULL, '0.00', '0.00', '0', '308.00', '0%', '0.0000', '308.0000', '2508.0000', '3', '4.0000', '2606.0000', '16', NULL, NULL, '', 'paid', '0.00', 'FR', 'N', 'FR SIF2024/2', '2024', '2024-02-06T17:43:22', 'P', '1', '0', '0', '', '', NULL, 'N');
INSERT INTO `tec_sales` (`id`, `Hash`, `Hash_no`, `HashControl`, `date`, `customer_id`, `customer_name`, `total`, `product_discount`, `order_discount_id`, `order_discount`, `total_discount`, `total_balance`, `product_tax`, `order_tax_id`, `order_tax`, `total_tax`, `grand_total`, `total_items`, `total_quantity`, `paid`, `created_by`, `updated_by`, `updated_at`, `note`, `status`, `rounding`, `InvoiceType`, `InvoiceStatus`, `InvoiceNo`, `InvoiceYear`, `InvoiceStatusDate`, `SourceBilling`, `CashVATSchemeIndicator`, `SelfBillingIndicator`, `ThirdPartiesBillingIndicator`, `OriginatingON`, `Reason`, `OrderReferences`, `mesa`) VALUES ('65', 'pEpZiiqKLNGNaO+KGH1rrEiHxMjNdIdKG5XgRGDMexlvVi8jyARLdK5a2SYeJtm6ZVhU6uHBYL3/5ao02S2/5vu19eo/nkGZY2Z8eBgy7NweZxifZt1JoxVZ4Pmv8d1uQLFus3/nYyFp4U3/wjAactgl+I8t6ymcNrzwoiuNG80=', '2024-02-06;2024-02-06T17:44:15;FR SIF2024/3;4081.20;R4pqw5Es6LtKRO4ZydQANIhO/XVZE+gm23Hb5tmAfhTl6hmM62rsnHi4+nVEdqtLj2YqsXUwY98lcmALiX51YRNS+LV7H7nMfULz0vUz22mFNmPK5bnCxMB2ZbMApXifYOKnM10kb7RrKSj+tXcKa7mWMm4POJgx2h+uceramEQ=', '1', '2024-02-06 17:44:15', '73', 'Consumidor Final', '3580.00', '120.00', NULL, '0.00', '120.00', '0', '501.20', '0%', '0.0000', '501.2000', '4081.2000', '2', '2.0000', '4081.2000', '16', NULL, NULL, '', 'paid', '0.00', 'FR', 'N', 'FR SIF2024/3', '2024', '2024-02-06T17:44:15', 'P', '1', '0', '0', '', '', NULL, 'N');
INSERT INTO `tec_sales` (`id`, `Hash`, `Hash_no`, `HashControl`, `date`, `customer_id`, `customer_name`, `total`, `product_discount`, `order_discount_id`, `order_discount`, `total_discount`, `total_balance`, `product_tax`, `order_tax_id`, `order_tax`, `total_tax`, `grand_total`, `total_items`, `total_quantity`, `paid`, `created_by`, `updated_by`, `updated_at`, `note`, `status`, `rounding`, `InvoiceType`, `InvoiceStatus`, `InvoiceNo`, `InvoiceYear`, `InvoiceStatusDate`, `SourceBilling`, `CashVATSchemeIndicator`, `SelfBillingIndicator`, `ThirdPartiesBillingIndicator`, `OriginatingON`, `Reason`, `OrderReferences`, `mesa`) VALUES ('66', 'VOIiH3QMBXEGny3IXEvEb+xydnBpoNxa+/f25PQjmQ41DCtKhPfXSMA70q6ekhyW9SXagPalSkaXEJnsnMbfTZTWJxVElOJV0pnwyAaAJWDrFupbVXqHMW4DvKjEQ89i7y/jNVSkXfS5J2Tf/PCLDrArbnacOzN0LvJ+zUyDVYg=', '2024-02-06;2024-02-06T17:45:08;NC SIF2024/1;188.10;', '1', '2024-02-06 17:45:08', '73', 'Consumidor Final', '165.00', '135.00', NULL, '0.00', '135.00', '0', '23.10', '0%', '0.0000', '23.1000', '188.1000', '2', '2.0000', '0.0000', '16', NULL, NULL, '', 'no paid', '0.00', 'NC', 'N', 'NC SIF2024/1', '2024', '2024-02-06T17:45:08', 'P', '1', '0', '0', 'FT SIF2024/4', 'Devolução', NULL, 'N');


#
# TABLE STRUCTURE FOR: tec_sessions
#

DROP TABLE IF EXISTS `tec_sessions`;

CREATE TABLE `tec_sessions` (
  `id` varchar(40) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `data` blob NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `ci_sessions_timestamp` (`timestamp`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

INSERT INTO `tec_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9c7ccc1799c2077310b7e4ae7e8b165b2b0154a3', '127.0.0.1', '1707305174', '__ci_last_regenerate|i:1707304930;identity|s:9:\"superuser\";username|s:9:\"superuser\";email|s:9:\"superuser\";user_id|s:2:\"16\";first_name|s:11:\"Mactoscohen\";last_name|s:3:\"lda\";created_on|s:20:\"22-11-2019 14:47:11 \";old_last_login|s:10:\"1707303449\";last_ip|s:9:\"127.0.0.1\";avatar|N;gender|s:4:\"male\";group_id|s:4:\"NA==\";sale_id|N;redirect_page|s:0:\"\";register_id|s:2:\"10\";cash_in_hand|s:4:\"0.00\";register_open_time|s:19:\"2024-01-22 14:13:22\";');


#
# TABLE STRUCTURE FOR: tec_settings
#

DROP TABLE IF EXISTS `tec_settings`;

CREATE TABLE `tec_settings` (
  `setting_id` int(11) NOT NULL,
  `logo` varchar(255) NOT NULL,
  `site_name` varchar(55) NOT NULL,
  `Telephone` varchar(200) NOT NULL,
  `dateformat` varchar(20) DEFAULT NULL,
  `timeformat` varchar(20) DEFAULT NULL,
  `default_email` varchar(100) NOT NULL,
  `language` varchar(20) NOT NULL,
  `version` varchar(5) NOT NULL DEFAULT '1.0',
  `theme` varchar(20) NOT NULL,
  `timezone` varchar(255) NOT NULL DEFAULT '0',
  `protocol` varchar(20) NOT NULL DEFAULT 'mail',
  `smtp_host` varchar(255) DEFAULT NULL,
  `smtp_user` varchar(100) DEFAULT NULL,
  `smtp_pass` varchar(255) DEFAULT NULL,
  `smtp_port` varchar(10) DEFAULT '25',
  `smtp_crypto` varchar(5) DEFAULT NULL,
  `mmode` tinyint(1) NOT NULL,
  `captcha` tinyint(1) NOT NULL DEFAULT '1',
  `mailpath` varchar(55) DEFAULT NULL,
  `currency_prefix` varchar(3) NOT NULL,
  `default_customer` int(11) NOT NULL,
  `default_tax_rate` varchar(20) NOT NULL,
  `rows_per_page` int(11) NOT NULL,
  `total_rows` int(11) NOT NULL,
  `header` varchar(1000) NOT NULL,
  `footer` varchar(1000) NOT NULL,
  `bsty` tinyint(4) NOT NULL,
  `display_kb` tinyint(4) NOT NULL,
  `default_category` int(11) NOT NULL,
  `default_discount` varchar(20) NOT NULL,
  `item_addition` tinyint(1) NOT NULL,
  `barcode_symbology` varchar(55) NOT NULL,
  `pro_limit` tinyint(4) NOT NULL,
  `decimals` tinyint(1) NOT NULL DEFAULT '2',
  `thousands_sep` varchar(2) NOT NULL DEFAULT ',',
  `decimals_sep` varchar(2) NOT NULL DEFAULT '.',
  `focus_add_item` varchar(55) DEFAULT NULL,
  `add_customer` varchar(55) DEFAULT NULL,
  `toggle_category_slider` varchar(55) DEFAULT NULL,
  `cancel_sale` varchar(55) DEFAULT NULL,
  `suspend_sale` varchar(55) DEFAULT NULL,
  `print_order` varchar(55) DEFAULT NULL,
  `print_bill` varchar(55) DEFAULT NULL,
  `finalize_sale` varchar(55) DEFAULT NULL,
  `today_sale` varchar(55) DEFAULT NULL,
  `open_hold_bills` varchar(55) DEFAULT NULL,
  `close_register` varchar(55) DEFAULT NULL,
  `java_applet` tinyint(1) NOT NULL,
  `receipt_printer` varchar(55) DEFAULT NULL,
  `pos_printers` varchar(255) DEFAULT NULL,
  `cash_drawer_codes` varchar(55) DEFAULT NULL,
  `char_per_line` tinyint(4) DEFAULT '42',
  `rounding` tinyint(1) DEFAULT '0',
  `pin_code` varchar(20) DEFAULT NULL,
  `stripe` tinyint(1) DEFAULT NULL,
  `stripe_secret_key` varchar(100) DEFAULT NULL,
  `stripe_publishable_key` varchar(100) DEFAULT NULL,
  `purchase_code` varchar(100) DEFAULT NULL,
  `envato_username` varchar(50) DEFAULT NULL,
  `nif` varchar(255) DEFAULT NULL,
  `descricao` varchar(255) DEFAULT NULL,
  `rua` varchar(255) DEFAULT NULL,
  `CompanyID` varchar(100) DEFAULT NULL,
  `TaxRegistrationNumber` varchar(100) DEFAULT NULL,
  `TaxAccountingBasis` varchar(255) DEFAULT NULL,
  `CompanyName` varchar(200) DEFAULT NULL,
  `BusinessName` varchar(60) DEFAULT NULL,
  `BuildingNumber` varchar(15) DEFAULT NULL,
  `StreetName` varchar(200) DEFAULT NULL,
  `AddressDetail` varchar(255) DEFAULT NULL,
  `City` varchar(50) DEFAULT NULL,
  `PostalCode` varchar(20) DEFAULT NULL,
  `Province` varchar(50) DEFAULT NULL,
  `FiscalYear` year(4) DEFAULT NULL,
  `CurrencyCode` varchar(255) DEFAULT NULL,
  `TaxEntity` varchar(20) DEFAULT NULL,
  `ProductCompanyTaxID` varchar(20) DEFAULT NULL,
  `SoftwareValidationNumber` varchar(20) DEFAULT NULL,
  `ProductID` varchar(100) DEFAULT NULL,
  `ProductVersion` varchar(15) DEFAULT NULL,
  `HeaderComment` varchar(255) DEFAULT NULL,
  `Fax` varchar(255) DEFAULT NULL,
  `Email` varchar(255) DEFAULT NULL,
  `Website` varchar(255) DEFAULT NULL,
  `phone` varchar(200) NOT NULL,
  `licence` varchar(100) DEFAULT NULL,
  `expired_month` varchar(200) DEFAULT NULL,
  `regime` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`setting_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

INSERT INTO `tec_settings` (`setting_id`, `logo`, `site_name`, `Telephone`, `dateformat`, `timeformat`, `default_email`, `language`, `version`, `theme`, `timezone`, `protocol`, `smtp_host`, `smtp_user`, `smtp_pass`, `smtp_port`, `smtp_crypto`, `mmode`, `captcha`, `mailpath`, `currency_prefix`, `default_customer`, `default_tax_rate`, `rows_per_page`, `total_rows`, `header`, `footer`, `bsty`, `display_kb`, `default_category`, `default_discount`, `item_addition`, `barcode_symbology`, `pro_limit`, `decimals`, `thousands_sep`, `decimals_sep`, `focus_add_item`, `add_customer`, `toggle_category_slider`, `cancel_sale`, `suspend_sale`, `print_order`, `print_bill`, `finalize_sale`, `today_sale`, `open_hold_bills`, `close_register`, `java_applet`, `receipt_printer`, `pos_printers`, `cash_drawer_codes`, `char_per_line`, `rounding`, `pin_code`, `stripe`, `stripe_secret_key`, `stripe_publishable_key`, `purchase_code`, `envato_username`, `nif`, `descricao`, `rua`, `CompanyID`, `TaxRegistrationNumber`, `TaxAccountingBasis`, `CompanyName`, `BusinessName`, `BuildingNumber`, `StreetName`, `AddressDetail`, `City`, `PostalCode`, `Province`, `FiscalYear`, `CurrencyCode`, `TaxEntity`, `ProductCompanyTaxID`, `SoftwareValidationNumber`, `ProductID`, `ProductVersion`, `HeaderComment`, `Fax`, `Email`, `Website`, `phone`, `licence`, `expired_month`, `regime`) VALUES ('1', 'aghichem.jpg', 'SIF-POS', '', 'd-m-Y', 'H:i:s ', 'geral@mactsystem.info', 'portugues', '4', 'default', 'Local', 'mail', 'luanda.angoweb.biz', 'geral@mactsystem.info', '', '25', '', '0', '0', NULL, '', '73', '0%', '10', '30', 'ESCEDEMOS AS ESPECTATIVAS DOS NOSSOS CLIENTES!<br>SIF POS - 917254932<br><br>', 'Coordenadas Bancárias<br>BANCO KEVE<br>CONTA NUMERO: 02771224010001<br>IBAN: AO06 0047 0000 2771 2240 1018 2<br><br><br>', '3', '0', '43', '0', '1', '', '100', '2', '.', ',', 'ALT+F7', 'ALT+F2', 'ALT+F10', '120', '120', 'ALT+F11', 'ALT+F12', 'ALT+F8', 'Ctrl+F1', 'Ctrl+F2', 'ALT+F7', '0', 'EPSON TM-T88V Receipt', '', '', '42', '0', '1234', NULL, NULL, NULL, 'ff2400d9-f3aa-4db5-9dc5-4eee236c6254', 'patriciomelo', 'NIF 5000418552', 'LS E NIC - COMÉRCIO E SERVIÇOS, LDA', 'RUA: Rotunda Cruz Vermelha ', '5111043110', '5111043110', 'F', 'AGUISHEN, LDA', 'CONTRUÇÃO CIVIL E OBRAS PÚBLICAS, COMÉRCIO GERAL A GROSSO E ', '244', 'BAIRRO DA CAMUNDA, CASA Nº 244', 'BAIRRO DA CAMUNDA, CASA Nº 244', 'Benguela', '0', 'Benguela', '2024', 'AOA', 'Geral', '003136359BA034', '230/AGT/2019', 'SIF-POS', '1.0.4', NULL, '0', 'aguishen1@hotmail.com', 'Benguela - Angola', '+244915142685 | +2272338865', '4c210d8518aecb992ba02f7dba639a9a', 'MjAyNS0wMS0yMg==', 'Regime Geral');


#
# TABLE STRUCTURE FOR: tec_signkey
#

DROP TABLE IF EXISTS `tec_signkey`;

CREATE TABLE `tec_signkey` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `private` varchar(5555) NOT NULL,
  `public` varchar(5555) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

INSERT INTO `tec_signkey` (`id`, `private`, `public`) VALUES ('1', '-----BEGIN PRIVATE KEY-----\nMIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBAMPkWGMVmnDXwi81\nMUeXjqCAMtxHlF2kqmXy7eaQ06w5hlTyyDI+KgiTxTR/YO+23ikuvutgH1pUev8U\nX6/dG/kJ93Y63ThUEpmAnCvbNOQ3p2PylSPd57Cw4rbDKxRb4tvNGbBscg1WALVG\nkkaP4WyjtXthkZWzev/fwVgcJ48hAgMBAAECgYEAgCkb/q96nIs8e2BEvn8UjENz\ngxS9p8p8xTh7lxZ3tjzoexlgCycKnxP2uJMB27N7g9wWgq4ftRyCX/J3a/qwOkay\naybdxmLLmz2bYAZNsvVdRIrmnrLU1vSbtz42C7Z1Dyv64zNfiPF61Rk7pi92J9cs\nRLjM7TV9uoNR9ltNLcUCQQD8ykPgN4R7Ax4U11x43h7hqff36lbwGa9CXxDd694x\nFJ0h8zRIR5JqP8WIjtSlLbHRPCVOu7MaqNaSBwVqr6PLAkEAxmEfpYfTBdV0NpXU\ndH9BdSeqAymO2zD1Ap9BvuJhtSIS4tr5XcuhPWugJfHSxtKpVqA3mXGrS4nN1Any\nzGLzQwJAU4E5VMriH4STHk1aBa9SQjdUa3fkyiGh7Gnc94If/tSRZ5KgVbQW4LQ6\nO3b7NalXkQeuR0jnzEmzv79EAc8NawJBALHbP+lDlhFD55ZMzJbJxOEJd6awKrEf\n+nqoV+SQyHMCIpabJjlOqLgNdx6t6YByPHo62L5Mp/voh84UQUe3a0sCQA0wE3jW\nRMpC3XdWOSUO69ooeTxsy7ouiaUJbbLvxsuLCtcLoRvHoiJ19rHk+Cc0cd60ivqf\nLFqg1E0zZBpOKMk=\n-----END PRIVATE KEY-----\n', '-----BEGIN PUBLIC KEY-----\nMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDD5FhjFZpw18IvNTFHl46ggDLc\nR5RdpKpl8u3mkNOsOYZU8sgyPioIk8U0f2Dvtt4pLr7rYB9aVHr/FF+v3Rv5Cfd2\nOt04VBKZgJwr2zTkN6dj8pUj3eewsOK2wysUW+LbzRmwbHINVgC1RpJGj+Fso7V7\nYZGVs3r/38FYHCePIQIDAQAB\n-----END PUBLIC KEY-----\n');


#
# TABLE STRUCTURE FOR: tec_stock
#

DROP TABLE IF EXISTS `tec_stock`;

CREATE TABLE `tec_stock` (
  `stock_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `quatity` double(12,2) NOT NULL,
  `date` datetime NOT NULL,
  `date_update` datetime NOT NULL,
  `price` double(12,2) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `date_created` datetime DEFAULT NULL,
  `date_modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`stock_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

#
# TABLE STRUCTURE FOR: tec_suppliers
#

DROP TABLE IF EXISTS `tec_suppliers`;

CREATE TABLE `tec_suppliers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(55) NOT NULL,
  `cf1` varchar(255) NOT NULL,
  `cf2` varchar(255) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `email` varchar(100) NOT NULL,
  `date` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `endereco` varchar(255) DEFAULT NULL,
  `complemento` varchar(255) DEFAULT NULL,
  `numero` varchar(20) NOT NULL,
  `bairro` varchar(255) NOT NULL,
  `cep` varchar(100) NOT NULL,
  `cidade` varchar(100) NOT NULL,
  `estado` varchar(100) NOT NULL,
  `Country` varchar(100) DEFAULT NULL,
  `AccountID` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

INSERT INTO `tec_suppliers` (`id`, `name`, `cf1`, `cf2`, `phone`, `email`, `date`, `created_by`, `endereco`, `complemento`, `numero`, `bairro`, `cep`, `cidade`, `estado`, `Country`, `AccountID`) VALUES ('1', 'Modelo', '999999', ' ', '0', 'm@gmail.com', NULL, NULL, 'Benguela', ' ', '0', 'Benguela', ' ', 'Benguela', 'Benguela', NULL, '1');


#
# TABLE STRUCTURE FOR: tec_suspended_items
#

DROP TABLE IF EXISTS `tec_suspended_items`;

CREATE TABLE `tec_suspended_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `suspend_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `quantity` decimal(15,2) NOT NULL,
  `unit_price` decimal(25,2) NOT NULL,
  `net_unit_price` decimal(25,2) NOT NULL,
  `discount` varchar(20) DEFAULT NULL,
  `item_discount` decimal(25,2) DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `item_tax` decimal(25,2) DEFAULT NULL,
  `subtotal` decimal(25,2) NOT NULL,
  `real_unit_price` decimal(25,2) DEFAULT NULL,
  `tax_id` int(11) DEFAULT NULL,
  `note` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

#
# TABLE STRUCTURE FOR: tec_suspended_sales
#

DROP TABLE IF EXISTS `tec_suspended_sales`;

CREATE TABLE `tec_suspended_sales` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL,
  `customer_id` int(11) NOT NULL,
  `customer_name` varchar(55) NOT NULL,
  `total` decimal(25,2) NOT NULL,
  `product_discount` decimal(25,2) DEFAULT NULL,
  `order_discount_id` varchar(20) DEFAULT NULL,
  `order_discount` decimal(25,2) DEFAULT NULL,
  `total_discount` decimal(25,2) DEFAULT NULL,
  `product_tax` decimal(25,2) DEFAULT NULL,
  `order_tax_id` varchar(20) DEFAULT NULL,
  `order_tax` decimal(25,2) DEFAULT NULL,
  `total_tax` decimal(25,2) DEFAULT NULL,
  `grand_total` decimal(25,2) NOT NULL,
  `total_items` int(11) DEFAULT NULL,
  `total_quantity` decimal(15,2) DEFAULT NULL,
  `paid` decimal(25,2) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `note` varchar(1000) DEFAULT NULL,
  `hold_ref` varchar(255) DEFAULT NULL,
  `mesa` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

#
# TABLE STRUCTURE FOR: tec_suspended_subitems
#

DROP TABLE IF EXISTS `tec_suspended_subitems`;

CREATE TABLE `tec_suspended_subitems` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `suspend_id` int(11) NOT NULL,
  `product` int(11) NOT NULL,
  `sub_product_id` int(11) NOT NULL,
  `quantity` decimal(15,2) NOT NULL,
  `unit_price` decimal(25,2) NOT NULL,
  `subtotal` decimal(25,2) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

#
# TABLE STRUCTURE FOR: tec_tax
#

DROP TABLE IF EXISTS `tec_tax`;

CREATE TABLE `tec_tax` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(200) NOT NULL,
  `reason` varchar(250) NOT NULL,
  `tax` varchar(20) NOT NULL DEFAULT '0',
  `tax_type` varchar(4) DEFAULT NULL,
  `tax_code` varchar(4) DEFAULT NULL,
  `metodo` varchar(1) DEFAULT NULL,
  `tax_code_payment` varchar(4) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=32 DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

INSERT INTO `tec_tax` (`id`, `code`, `reason`, `tax`, `tax_type`, `tax_code`, `metodo`, `tax_code_payment`) VALUES ('1', 'M01', 'Regime Geral', '14', 'IVA', 'NOR', '0', 'NA');
INSERT INTO `tec_tax` (`id`, `code`, `reason`, `tax`, `tax_type`, `tax_code`, `metodo`, `tax_code_payment`) VALUES ('2', 'M00', 'Regime Simplificado', '0', 'IVA', 'OUT', '0', 'NA');
INSERT INTO `tec_tax` (`id`, `code`, `reason`, `tax`, `tax_type`, `tax_code`, `metodo`, `tax_code_payment`) VALUES ('3', 'M02', 'Transmissão de bens e serviço não sujeita', '0', 'IVA', 'ISE', '0', 'NA');
INSERT INTO `tec_tax` (`id`, `code`, `reason`, `tax`, `tax_type`, `tax_code`, `metodo`, `tax_code_payment`) VALUES ('4', 'M04', 'IVA – Regime de Exclusão', '0', 'NS', 'NS', '0', 'ISE');
INSERT INTO `tec_tax` (`id`, `code`, `reason`, `tax`, `tax_type`, `tax_code`, `metodo`, `tax_code_payment`) VALUES ('5', 'M10', 'Isento nos termos da alínea a) do nº1 do artigo 12.º do CIVA', '0', 'IVA', 'ISE', '0', 'ISE');
INSERT INTO `tec_tax` (`id`, `code`, `reason`, `tax`, `tax_type`, `tax_code`, `metodo`, `tax_code_payment`) VALUES ('7', 'M11', 'Isento nos termos da alínea b) do nº1 do artigo 12.º do CIVA', '0', 'IVA', 'ISE', '0', 'ISE');
INSERT INTO `tec_tax` (`id`, `code`, `reason`, `tax`, `tax_type`, `tax_code`, `metodo`, `tax_code_payment`) VALUES ('8', 'M12', 'Isento nos termos da alínea c) do nº1 do artigo 12.º do CIVA', '0', 'IVA', 'ISE', '0', 'ISE');
INSERT INTO `tec_tax` (`id`, `code`, `reason`, `tax`, `tax_type`, `tax_code`, `metodo`, `tax_code_payment`) VALUES ('9', 'M13', 'Isento nos termos da alínea d) do nº1 do artigo 12.º do CIVA', '0', 'IVA', 'ISE', '0', 'ISE');
INSERT INTO `tec_tax` (`id`, `code`, `reason`, `tax`, `tax_type`, `tax_code`, `metodo`, `tax_code_payment`) VALUES ('10', 'M14', 'Isento nos termos da alínea e) do nº1 do artigo 12.º do CIVA', '0', 'IVA', 'ISE', '0', 'ISE');
INSERT INTO `tec_tax` (`id`, `code`, `reason`, `tax`, `tax_type`, `tax_code`, `metodo`, `tax_code_payment`) VALUES ('11', 'M15', 'Isento nos termos da alínea f) do nº1 do artigo 12.º do CIVA', '0', 'IVA', 'ISE', '0', 'ISE');
INSERT INTO `tec_tax` (`id`, `code`, `reason`, `tax`, `tax_type`, `tax_code`, `metodo`, `tax_code_payment`) VALUES ('12', 'M16', 'Isento nos termos da alínea g) do nº1 do artigo 12.º do CIVA', '0', 'IVA', 'ISE', '0', 'ISE');
INSERT INTO `tec_tax` (`id`, `code`, `reason`, `tax`, `tax_type`, `tax_code`, `metodo`, `tax_code_payment`) VALUES ('13', 'M17', 'Isento nos termos da alínea h) do nº1 do artigo 12.º do CIVA', '0', 'IVA', 'ISE', '0', 'ISE');
INSERT INTO `tec_tax` (`id`, `code`, `reason`, `tax`, `tax_type`, `tax_code`, `metodo`, `tax_code_payment`) VALUES ('14', 'M18', 'Isento nos termos da alínea i) do nº1 artigo 12.º do CIVA', '0', 'IVA', 'ISE', '0', 'ISE');
INSERT INTO `tec_tax` (`id`, `code`, `reason`, `tax`, `tax_type`, `tax_code`, `metodo`, `tax_code_payment`) VALUES ('15', 'M19', 'Isento nos termos da alínea j) do nº1 do artigo 12.º do CIVA', '0', 'IVA', 'ISE', '0', 'ISE');
INSERT INTO `tec_tax` (`id`, `code`, `reason`, `tax`, `tax_type`, `tax_code`, `metodo`, `tax_code_payment`) VALUES ('16', 'M21', 'Isento nos termos da alínea l) do nº1 do artigo 12.º do CIVA', '0', 'IVA', 'ISE', '0', 'ISE');
INSERT INTO `tec_tax` (`id`, `code`, `reason`, `tax`, `tax_type`, `tax_code`, `metodo`, `tax_code_payment`) VALUES ('17', 'M22', 'Isento nos termos da alínea m) do artigo 12.º do CIVA', '0', 'IVA', 'ISE', '0', 'ISE');
INSERT INTO `tec_tax` (`id`, `code`, `reason`, `tax`, `tax_type`, `tax_code`, `metodo`, `tax_code_payment`) VALUES ('18', 'M23', 'Isento nos termos da alínea n) do artigo 12.º do CIVA', '0', 'IVA', 'ISE', '0', 'ISE');
INSERT INTO `tec_tax` (`id`, `code`, `reason`, `tax`, `tax_type`, `tax_code`, `metodo`, `tax_code_payment`) VALUES ('19', 'M24', 'Isento nos termos da alínea o) do artigo 12.º do CIVA', '0', 'IVA', 'ISE', '0', 'ISE');
INSERT INTO `tec_tax` (`id`, `code`, `reason`, `tax`, `tax_type`, `tax_code`, `metodo`, `tax_code_payment`) VALUES ('20', 'M30', 'Isento nos termos da alínea a) do artigo 15.º do CIVA', '0', 'IVA ', 'ISE', '0', 'ISE');
INSERT INTO `tec_tax` (`id`, `code`, `reason`, `tax`, `tax_type`, `tax_code`, `metodo`, `tax_code_payment`) VALUES ('21', 'M31', 'Isento nos termos da alínea b) do artigo 15.º do CIVA', '0', 'IVA ', 'ISE', '0', 'ISE');
INSERT INTO `tec_tax` (`id`, `code`, `reason`, `tax`, `tax_type`, `tax_code`, `metodo`, `tax_code_payment`) VALUES ('22', 'M32', 'Isento nos termos da alínea c) do artigo 15.º do CIVA', '0', 'IVA ', 'ISE', '0', 'ISE');
INSERT INTO `tec_tax` (`id`, `code`, `reason`, `tax`, `tax_type`, `tax_code`, `metodo`, `tax_code_payment`) VALUES ('23', 'M83', 'Isento nos termos da alinea d) do nº1 do artigo 14.º', '0', 'IVA ', 'ISE', '0', 'ISE');
INSERT INTO `tec_tax` (`id`, `code`, `reason`, `tax`, `tax_type`, `tax_code`, `metodo`, `tax_code_payment`) VALUES ('24', 'M33', 'Isento nos termos da alínea d) do artigo 15.º do CIVA', '0', 'IVA ', 'ISE', '0', 'ISE');
INSERT INTO `tec_tax` (`id`, `code`, `reason`, `tax`, `tax_type`, `tax_code`, `metodo`, `tax_code_payment`) VALUES ('25', 'M34', 'Isento nos termos da alínea e) do artigo 15.º do CIVA', '0', 'IVA ', 'ISE', '0', 'ISE');
INSERT INTO `tec_tax` (`id`, `code`, `reason`, `tax`, `tax_type`, `tax_code`, `metodo`, `tax_code_payment`) VALUES ('26', 'M35', 'Isento nos termos da alínea f) do artigo 15.º do CIVA', '0', 'IVA ', 'ISE', '0', 'ISE');
INSERT INTO `tec_tax` (`id`, `code`, `reason`, `tax`, `tax_type`, `tax_code`, `metodo`, `tax_code_payment`) VALUES ('27', 'M36', 'Isento nos termos da alínea g) do artigo 15.º do CIVA', '0', 'IVA ', 'ISE', '0', 'ISE');
INSERT INTO `tec_tax` (`id`, `code`, `reason`, `tax`, `tax_type`, `tax_code`, `metodo`, `tax_code_payment`) VALUES ('28', 'M37', 'Isento nos termos da alínea h) do artigo 15.º do CIVA', '0', 'IVA ', 'ISE', '0', 'ISE');
INSERT INTO `tec_tax` (`id`, `code`, `reason`, `tax`, `tax_type`, `tax_code`, `metodo`, `tax_code_payment`) VALUES ('29', 'M38', 'Isento nos termos da alínea i) do artigo 15.º do CIVA', '0', 'IVA ', 'ISE', '0', 'ISE');
INSERT INTO `tec_tax` (`id`, `code`, `reason`, `tax`, `tax_type`, `tax_code`, `metodo`, `tax_code_payment`) VALUES ('30', 'M01', 'Regime Geral', '5', 'IVA', 'NOR', '0', 'NA');
INSERT INTO `tec_tax` (`id`, `code`, `reason`, `tax`, `tax_type`, `tax_code`, `metodo`, `tax_code_payment`) VALUES ('31', 'M01', 'Regime Geral s', '7', 'IVA', 'NOR', '0', 'NA');


#
# TABLE STRUCTURE FOR: tec_user_logins
#

DROP TABLE IF EXISTS `tec_user_logins`;

CREATE TABLE `tec_user_logins` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `company_id` int(11) DEFAULT NULL,
  `ip_address` varbinary(16) NOT NULL,
  `login` varchar(100) NOT NULL,
  `time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=58 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('1', '16', NULL, '::1', 'Superuser', '2023-01-06 12:54:01');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('2', '16', NULL, '::1', 'Superuser', '2023-01-06 13:21:05');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('3', '16', NULL, '::1', 'Superuser', '2023-01-06 14:07:48');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('4', '16', NULL, '127.0.0.1', 'Superuser', '2023-01-06 14:33:25');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('5', '16', NULL, '127.0.0.1', 'Superuser', '2023-01-10 14:18:21');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('6', '16', NULL, '::1', 'superuser', '2023-01-10 16:23:04');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('7', '16', NULL, '127.0.0.1', 'Superuser', '2023-01-11 14:45:17');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('8', '16', NULL, '127.0.0.1', 'Superuser', '2023-01-12 12:30:28');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('9', '16', NULL, '127.0.0.1', 'Superuser', '2023-01-23 12:53:45');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('10', '16', NULL, '127.0.0.1', 'Superuser', '2023-01-23 17:55:34');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('11', '41', NULL, '127.0.0.1', 'mactos', '2023-01-23 17:57:48');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('12', '16', NULL, '127.0.0.1', 'Superuser', '2023-01-23 18:49:36');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('13', '16', NULL, '127.0.0.1', 'Superuser', '2023-01-24 13:29:50');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('14', '16', NULL, '127.0.0.1', 'Superuser', '2023-01-24 14:20:49');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('15', '16', NULL, '127.0.0.1', 'Superuser', '2023-01-24 18:29:45');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('16', '16', NULL, '127.0.0.1', 'Superuser', '2023-01-25 09:45:08');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('17', '16', NULL, '127.0.0.1', 'Superuser', '2023-01-26 12:16:50');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('18', '16', NULL, '127.0.0.1', 'Superuser', '2023-01-26 12:41:25');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('19', '16', NULL, '127.0.0.1', 'Superuser', '2023-01-30 14:24:08');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('20', '16', NULL, '127.0.0.1', 'Superuser', '2023-01-30 14:48:28');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('21', '16', NULL, '127.0.0.1', 'Superuser', '2023-02-01 11:06:07');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('22', '16', NULL, '127.0.0.1', 'Superuser', '2023-02-01 11:14:56');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('23', '16', NULL, '127.0.0.1', 'Superuser', '2023-02-01 15:26:16');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('24', '16', NULL, '127.0.0.1', 'Superuser', '2023-02-02 12:48:44');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('25', '16', NULL, '127.0.0.1', 'Superuser', '2023-02-26 15:44:43');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('26', '16', NULL, '127.0.0.1', 'Superuser', '2023-03-02 15:49:32');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('27', '16', NULL, '127.0.0.1', 'Superuser', '2023-03-11 17:25:03');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('28', '16', NULL, '127.0.0.1', 'Superuser', '2023-03-11 17:27:24');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('29', '16', NULL, '127.0.0.1', 'Superuser', '2023-03-13 15:02:52');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('30', '16', NULL, '127.0.0.1', 'Superuser', '2023-03-14 13:45:35');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('31', '16', NULL, '127.0.0.1', 'Superuser', '2023-03-14 18:28:56');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('32', '16', NULL, '127.0.0.1', 'Superuser', '2023-03-16 18:32:38');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('33', '16', NULL, '127.0.0.1', 'Superuser', '2023-03-28 10:49:58');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('34', '16', NULL, '127.0.0.1', 'Superuser', '2023-03-28 17:10:09');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('35', '16', NULL, '127.0.0.1', 'Superuser', '2023-05-13 10:39:06');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('36', '16', NULL, '127.0.0.1', 'Superuser', '2023-05-25 19:00:03');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('37', '16', NULL, '127.0.0.1', 'Superuser', '2023-08-16 17:01:33');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('38', '16', NULL, '127.0.0.1', 'Superuser', '2023-12-29 19:53:18');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('39', '16', NULL, '127.0.0.1', 'Superuser', '2024-01-09 17:12:55');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('40', '16', NULL, '127.0.0.1', 'Superuser', '2024-01-21 22:47:26');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('41', '16', NULL, '::1', 'superuser', '2024-01-22 01:26:41');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('42', '16', NULL, '::1', 'superuser', '2024-01-22 01:30:58');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('43', '16', NULL, '127.0.0.1', 'Superuser', '2024-01-22 01:31:12');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('44', '16', NULL, '127.0.0.1', 'Superuser', '2024-01-22 01:31:34');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('45', '16', NULL, '127.0.0.1', 'Superuser', '2024-01-22 08:57:17');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('46', '16', NULL, '127.0.0.1', 'Superuser', '2024-01-22 14:10:31');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('47', '41', NULL, '127.0.0.1', 'mactos', '2024-01-22 14:14:23');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('48', '41', NULL, '127.0.0.1', 'mactos', '2024-01-22 14:14:34');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('49', '16', NULL, '127.0.0.1', 'Superuser', '2024-01-22 14:57:00');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('50', '16', NULL, '127.0.0.1', 'Superuser', '2024-01-23 11:14:17');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('51', '16', NULL, '127.0.0.1', 'Superuser', '2024-02-06 16:48:42');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('52', '16', NULL, '::1', 'superuser', '2024-02-06 17:34:02');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('53', '16', NULL, '127.0.0.1', 'Superuser', '2024-02-07 11:52:02');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('54', '42', NULL, '127.0.0.1', 'mactos1', '2024-02-07 11:53:25');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('55', '16', NULL, '127.0.0.1', 'Superuser', '2024-02-07 11:57:29');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('56', '43', NULL, '127.0.0.1', 'wima', '2024-02-07 11:58:20');
INSERT INTO `tec_user_logins` (`id`, `user_id`, `company_id`, `ip_address`, `login`, `time`) VALUES ('57', '16', NULL, '127.0.0.1', 'Superuser', '2024-02-07 12:22:17');


#
# TABLE STRUCTURE FOR: tec_users
#

DROP TABLE IF EXISTS `tec_users`;

CREATE TABLE `tec_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `last_ip_address` varbinary(45) DEFAULT NULL,
  `ip_address` varbinary(45) DEFAULT NULL,
  `username` varchar(100) NOT NULL,
  `password` varchar(40) NOT NULL,
  `salt` varchar(40) DEFAULT NULL,
  `email` varchar(100) NOT NULL,
  `activation_code` varchar(40) DEFAULT NULL,
  `forgotten_password_code` varchar(40) DEFAULT NULL,
  `forgotten_password_time` int(10) unsigned DEFAULT NULL,
  `remember_code` varchar(40) DEFAULT NULL,
  `created_on` int(10) unsigned NOT NULL,
  `last_login` int(10) unsigned DEFAULT NULL,
  `active` tinyint(1) unsigned DEFAULT NULL,
  `first_name` varchar(50) DEFAULT NULL,
  `last_name` varchar(50) DEFAULT NULL,
  `company` varchar(100) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `avatar` varchar(55) DEFAULT NULL,
  `gender` varchar(20) DEFAULT NULL,
  `group_id` varchar(100) NOT NULL DEFAULT '2',
  `licence` varchar(250) DEFAULT NULL,
  `expired_date` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `group_id` (`group_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=44 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

INSERT INTO `tec_users` (`id`, `last_ip_address`, `ip_address`, `username`, `password`, `salt`, `email`, `activation_code`, `forgotten_password_code`, `forgotten_password_time`, `remember_code`, `created_on`, `last_login`, `active`, `first_name`, `last_name`, `company`, `phone`, `avatar`, `gender`, `group_id`, `licence`, `expired_date`) VALUES ('16', '127.0.0.1', '::1', 'superuser', 'd972ee2c4d4e58be37142eee98feba6f3bd377dc', NULL, 'superuser', NULL, NULL, NULL, NULL, '1574430431', '1707304937', '1', 'Mactoscohen', 'lda', NULL, '917254932', NULL, 'male', 'NA==', 'NA==', '1969-12-31');
INSERT INTO `tec_users` (`id`, `last_ip_address`, `ip_address`, `username`, `password`, `salt`, `email`, `activation_code`, `forgotten_password_code`, `forgotten_password_time`, `remember_code`, `created_on`, `last_login`, `active`, `first_name`, `last_name`, `company`, `phone`, `avatar`, `gender`, `group_id`, `licence`, `expired_date`) VALUES ('20', '105.168.167.202', '::1', 'mactsystem', '0a3ddef8b2906dd0a9352faefa38dcc483f14044', NULL, 'geral@mactsystem.info', NULL, NULL, NULL, NULL, '1575535878', '1614167760', '1', 'Mactsystem', 'lda', NULL, '0', NULL, 'male', 'MQ==', 'e6cb59ed603fb62f48f69be1febe105d15102e35', 'MjAyMC0xMi0wNQ==');
INSERT INTO `tec_users` (`id`, `last_ip_address`, `ip_address`, `username`, `password`, `salt`, `email`, `activation_code`, `forgotten_password_code`, `forgotten_password_time`, `remember_code`, `created_on`, `last_login`, `active`, `first_name`, `last_name`, `company`, `phone`, `avatar`, `gender`, `group_id`, `licence`, `expired_date`) VALUES ('39', '154.127.169.209', '::1', 'jose', '718613bf2af7c0252c1c93831a9ab01f95c072f8', NULL, 'jose', NULL, NULL, NULL, NULL, '1590584743', '1636452774', '1', 'JOSÉ ', 'Cabral', NULL, '0', NULL, 'male', 'MQ==', 'f4b587ca99927820694878f153f602eba7303ba1', 'MjAyMS0wNS0yNw==');
INSERT INTO `tec_users` (`id`, `last_ip_address`, `ip_address`, `username`, `password`, `salt`, `email`, `activation_code`, `forgotten_password_code`, `forgotten_password_time`, `remember_code`, `created_on`, `last_login`, `active`, `first_name`, `last_name`, `company`, `phone`, `avatar`, `gender`, `group_id`, `licence`, `expired_date`) VALUES ('40', '127.0.0.1', '::1', 'caly', 'd972ee2c4d4e58be37142eee98feba6f3bd377dc', NULL, 'caly', NULL, NULL, NULL, NULL, '1598011775', '1650479873', '1', 'Caly', 'Januario', NULL, '925781275 ', NULL, 'male', 'MQ==', '425e0b2c446d8d10190a6e5470208afb53f89897', 'MjAyMS0wNy0yNA==');
INSERT INTO `tec_users` (`id`, `last_ip_address`, `ip_address`, `username`, `password`, `salt`, `email`, `activation_code`, `forgotten_password_code`, `forgotten_password_time`, `remember_code`, `created_on`, `last_login`, `active`, `first_name`, `last_name`, `company`, `phone`, `avatar`, `gender`, `group_id`, `licence`, `expired_date`) VALUES ('41', '127.0.0.1', '127.0.0.1', 'mactos', 'd930ae43ecbbf2b426eaaef32c5395f5358b5ed9', NULL, 'mactos', NULL, NULL, NULL, NULL, '1673523146', '1705929274', '1', 'Mactos ', 'Barros', NULL, '0', NULL, 'male', 'Mg==', NULL, NULL);
INSERT INTO `tec_users` (`id`, `last_ip_address`, `ip_address`, `username`, `password`, `salt`, `email`, `activation_code`, `forgotten_password_code`, `forgotten_password_time`, `remember_code`, `created_on`, `last_login`, `active`, `first_name`, `last_name`, `company`, `phone`, `avatar`, `gender`, `group_id`, `licence`, `expired_date`) VALUES ('42', '127.0.0.1', '127.0.0.1', 'barros1', '7b2e79cedf65929fc333fc0bbe509753e7af952b', NULL, 'mactos1', NULL, NULL, NULL, NULL, '1707303188', '1707303205', '1', 'mactos', 'Barros', NULL, '0', NULL, 'male', 'Mg==', NULL, NULL);
INSERT INTO `tec_users` (`id`, `last_ip_address`, `ip_address`, `username`, `password`, `salt`, `email`, `activation_code`, `forgotten_password_code`, `forgotten_password_time`, `remember_code`, `created_on`, `last_login`, `active`, `first_name`, `last_name`, `company`, `phone`, `avatar`, `gender`, `group_id`, `licence`, `expired_date`) VALUES ('43', '127.0.0.1', '127.0.0.1', 'wima', '1052fb91806b237ecb48212e582b63a65c9e50d2', NULL, 'wima', NULL, NULL, NULL, NULL, '1707303476', '1707303500', '1', 'wima', 'wima', NULL, '1', NULL, 'male', 'Mg==', NULL, NULL);


